/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.xml;

import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.xml.CategoryDatasetHandler;
import com.jrefinery.data.xml.PieDatasetHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DatasetReader {
    public static PieDataset readPieDatasetFromXML(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return DatasetReader.readPieDatasetFromXML(fileInputStream);
    }

    public static PieDataset readPieDatasetFromXML(InputStream inputStream) throws IOException {
        PieDataset pieDataset = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            PieDatasetHandler pieDatasetHandler = new PieDatasetHandler();
            sAXParser.parse(inputStream, (DefaultHandler)pieDatasetHandler);
            pieDataset = pieDatasetHandler.getDataset();
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException.getMessage());
        }
        return pieDataset;
    }

    public static CategoryDataset readCategoryDatasetFromXML(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        return DatasetReader.readCategoryDatasetFromXML(fileInputStream);
    }

    public static CategoryDataset readCategoryDatasetFromXML(InputStream inputStream) throws IOException {
        CategoryDataset categoryDataset = null;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            CategoryDatasetHandler categoryDatasetHandler = new CategoryDatasetHandler();
            sAXParser.parse(inputStream, (DefaultHandler)categoryDatasetHandler);
            categoryDataset = categoryDatasetHandler.getDataset();
        }
        catch (SAXException sAXException) {
            System.out.println(sAXException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            System.out.println(parserConfigurationException.getMessage());
        }
        return categoryDataset;
    }
}

