/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.Series;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.XYDataPair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class XYSeries
extends Series {
    private List data;
    private int maximumItemCount = Integer.MAX_VALUE;
    private boolean allowDuplicateXValues;

    public XYSeries(String string) {
        this(string, true);
    }

    public XYSeries(String string, boolean bl) {
        super(string);
        this.allowDuplicateXValues = bl;
        this.data = new ArrayList();
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public void add(XYDataPair xYDataPair) throws SeriesException {
        if (xYDataPair == null) {
            throw new IllegalArgumentException("XYSeries.add(...): null item not allowed.");
        }
        int n = Collections.binarySearch(this.data, xYDataPair);
        if (n < 0) {
            this.data.add(-n - 1, xYDataPair);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            this.fireSeriesChanged();
        } else if (this.allowDuplicateXValues) {
            this.data.add(n, xYDataPair);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            this.fireSeriesChanged();
        } else {
            throw new SeriesException("XYSeries.add(...): x-value already exists.");
        }
    }

    public void add(double d, double d2) throws SeriesException {
        this.add(new Double(d), (Number)new Double(d2));
    }

    public void add(double d, Number number) throws SeriesException {
        this.add(new Double(d), number);
    }

    public void add(Number number, Number number2) throws SeriesException {
        XYDataPair xYDataPair = new XYDataPair(number, number2);
        this.add(xYDataPair);
    }

    public void delete(int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            this.data.remove(n);
            ++n3;
        }
        this.fireSeriesChanged();
    }

    public void clear() {
        if (this.data.size() > 0) {
            this.data.clear();
            this.fireSeriesChanged();
        }
    }

    public XYDataPair getDataPair(int n) {
        return (XYDataPair)this.data.get(n);
    }

    public Number getXValue(int n) {
        return this.getDataPair(n).getX();
    }

    public Number getYValue(int n) {
        return this.getDataPair(n).getY();
    }

    public void update(int n, Number number) {
        XYDataPair xYDataPair = this.getDataPair(n);
        xYDataPair.setY(number);
        this.fireSeriesChanged();
    }

    public Object clone() {
        XYSeries xYSeries = this.createCopy(0, this.getItemCount() - 1);
        return xYSeries;
    }

    public XYSeries createCopy(int n, int n2) {
        XYSeries xYSeries = (XYSeries)super.clone();
        xYSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            int n3 = n;
            while (n3 <= n2) {
                XYDataPair xYDataPair = (XYDataPair)this.data.get(n3);
                XYDataPair xYDataPair2 = (XYDataPair)xYDataPair.clone();
                try {
                    xYSeries.add(xYDataPair2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("XYSeries.createCopy(): unable to add cloned data pair.");
                }
                ++n3;
            }
        }
        return xYSeries;
    }
}

