/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractSeriesDataset;
import com.jrefinery.data.DomainInfo;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.Range;
import com.jrefinery.data.RegularTimePeriod;
import com.jrefinery.data.TimeSeries;
import com.jrefinery.data.TimeSeriesDataPair;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;

public class TimeSeriesCollection
extends AbstractSeriesDataset
implements IntervalXYDataset,
DomainInfo {
    public static final int START = 0;
    public static final int MIDDLE = 1;
    public static final int END = 2;
    private List data = new ArrayList();
    private Calendar workingCalendar;
    private int position;
    private boolean domainIsPointsInTime;

    public TimeSeriesCollection() {
        this(null, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeZone timeZone) {
        this(null, timeZone);
    }

    public TimeSeriesCollection(TimeSeries timeSeries) {
        this(timeSeries, TimeZone.getDefault());
    }

    public TimeSeriesCollection(TimeSeries timeSeries, TimeZone timeZone) {
        if (timeSeries != null) {
            this.data.add(timeSeries);
            timeSeries.addChangeListener(this);
        }
        this.workingCalendar = Calendar.getInstance(timeZone);
        this.position = 0;
        this.domainIsPointsInTime = true;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public boolean getDomainIsPointsInTime() {
        return this.domainIsPointsInTime;
    }

    public void setDomainIsPointsInTime(boolean bl) {
        this.domainIsPointsInTime = bl;
    }

    public int getSeriesCount() {
        return this.data.size();
    }

    public TimeSeries getSeries(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TimeSeriesDataset.getSeries(...): index outside valid range.");
        }
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        return timeSeries;
    }

    public String getSeriesName(int n) {
        return this.getSeries(n).getName();
    }

    public void addSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.add(timeSeries);
        timeSeries.addChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(TimeSeries timeSeries) {
        if (timeSeries == null) {
            throw new IllegalArgumentException("TimeSeriesDataset.addSeries(...): cannot add null series.");
        }
        this.data.remove(timeSeries);
        timeSeries.removeChangeListener(this);
        this.fireDatasetChanged();
    }

    public void removeSeries(int n) {
        TimeSeries timeSeries = this.getSeries(n);
        if (timeSeries != null) {
            this.removeSeries(timeSeries);
        }
    }

    public int getItemCount(int n) {
        return this.getSeries(n).getItemCount();
    }

    public Number getXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = timeSeries.getDataPair(n2);
        RegularTimePeriod regularTimePeriod = timeSeriesDataPair.getPeriod();
        return new Long(this.getX(regularTimePeriod));
    }

    private long getX(RegularTimePeriod regularTimePeriod) {
        long l = 0L;
        switch (this.position) {
            case 0: {
                l = regularTimePeriod.getFirstMillisecond(this.workingCalendar);
                break;
            }
            case 1: {
                l = regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
                break;
            }
            case 2: {
                l = regularTimePeriod.getLastMillisecond(this.workingCalendar);
                break;
            }
            default: {
                l = regularTimePeriod.getMiddleMillisecond(this.workingCalendar);
            }
        }
        return l;
    }

    public Number getStartXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = timeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getFirstMillisecond(this.workingCalendar));
    }

    public Number getEndXValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = timeSeries.getDataPair(n2);
        return new Long(timeSeriesDataPair.getPeriod().getLastMillisecond(this.workingCalendar));
    }

    public Number getYValue(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)this.data.get(n);
        TimeSeriesDataPair timeSeriesDataPair = timeSeries.getDataPair(n2);
        return timeSeriesDataPair.getValue();
    }

    public Number getStartYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getEndYValue(int n, int n2) {
        return this.getYValue(n, n2);
    }

    public Number getMinimumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getLowerBound());
    }

    public Number getMaximumDomainValue() {
        Range range = this.getDomainRange();
        return new Double(range.getUpperBound());
    }

    public Range getDomainRange() {
        Range range = null;
        Range range2 = null;
        Iterator iterator = this.data.iterator();
        while (iterator.hasNext()) {
            TimeSeries timeSeries = (TimeSeries)iterator.next();
            int n = timeSeries.getItemCount();
            if (n <= 0) continue;
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(0);
            RegularTimePeriod regularTimePeriod2 = timeSeries.getTimePeriod(n - 1);
            range2 = this.domainIsPointsInTime ? new Range(this.getX(regularTimePeriod), this.getX(regularTimePeriod2)) : new Range(regularTimePeriod.getFirstMillisecond(this.workingCalendar), regularTimePeriod2.getLastMillisecond(this.workingCalendar));
            range = Range.combine(range, range2);
        }
        return range;
    }
}

