/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.RegularTimePeriod;
import com.jrefinery.data.Series;
import com.jrefinery.data.SeriesException;
import com.jrefinery.data.TimeSeriesDataPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class TimeSeries
extends Series {
    protected static final String DEFAULT_DOMAIN_DESCRIPTION = "Time";
    protected static final String DEFAULT_RANGE_DESCRIPTION = "Value";
    private String domain;
    private String range;
    private Class timePeriodClass;
    private List data;
    private int maximumItemCount;
    private int historyCount;
    static /* synthetic */ Class class$com$jrefinery$data$Day;

    public TimeSeries(String string) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, class$com$jrefinery$data$Day == null ? (class$com$jrefinery$data$Day = TimeSeries.class$("com.jrefinery.data.Day")) : class$com$jrefinery$data$Day);
    }

    public TimeSeries(String string, Class clazz) {
        this(string, DEFAULT_DOMAIN_DESCRIPTION, DEFAULT_RANGE_DESCRIPTION, clazz);
    }

    public TimeSeries(String string, String string2, String string3, Class clazz) {
        super(string);
        this.domain = string2;
        this.range = string3;
        this.timePeriodClass = clazz;
        this.data = new ArrayList();
        this.maximumItemCount = Integer.MAX_VALUE;
        this.historyCount = 0;
    }

    public String getDomainDescription() {
        return this.domain;
    }

    public void setDomainDescription(String string) {
        String string2 = this.domain;
        this.domain = string;
        this.firePropertyChange("Domain", string2, string);
    }

    public String getRangeDescription() {
        return this.range;
    }

    public void setRangeDescription(String string) {
        String string2 = this.range;
        this.range = string;
        this.firePropertyChange("Range", string2, string);
    }

    public int getItemCount() {
        return this.data.size();
    }

    public int getMaximumItemCount() {
        return this.maximumItemCount;
    }

    public void setMaximumItemCount(int n) {
        this.maximumItemCount = n;
    }

    public int getHistoryCount() {
        return this.historyCount;
    }

    public void setHistoryCount(int n) {
        this.historyCount = n;
    }

    public Class getTimePeriodClass() {
        return this.timePeriodClass;
    }

    public TimeSeriesDataPair getDataPair(int n) {
        return (TimeSeriesDataPair)this.data.get(n);
    }

    public TimeSeriesDataPair getDataPair(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod == null) {
            throw new IllegalArgumentException("TimeSeries.getDataPair(...): null time period not allowed.");
        }
        TimeSeriesDataPair timeSeriesDataPair = new TimeSeriesDataPair(regularTimePeriod, new Integer(0));
        int n = Collections.binarySearch(this.data, timeSeriesDataPair);
        if (n >= 0) {
            return (TimeSeriesDataPair)this.data.get(n);
        }
        return null;
    }

    public RegularTimePeriod getTimePeriod(int n) {
        return this.getDataPair(n).getPeriod();
    }

    public RegularTimePeriod getNextTimePeriod() {
        RegularTimePeriod regularTimePeriod = this.getTimePeriod(this.getItemCount() - 1);
        return regularTimePeriod.next();
    }

    public Collection getTimePeriods() {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        int n = 0;
        while (n < this.getItemCount()) {
            arrayList.add(this.getTimePeriod(n));
            ++n;
        }
        return arrayList;
    }

    public Collection getTimePeriodsUniqueToOtherSeries(TimeSeries timeSeries) {
        ArrayList<RegularTimePeriod> arrayList = new ArrayList<RegularTimePeriod>();
        int n = 0;
        while (n < timeSeries.getItemCount()) {
            RegularTimePeriod regularTimePeriod = timeSeries.getTimePeriod(n);
            int n2 = this.getIndex(regularTimePeriod);
            if (n2 < 0) {
                arrayList.add(regularTimePeriod);
            }
            ++n;
        }
        return arrayList;
    }

    public int getIndex(RegularTimePeriod regularTimePeriod) {
        if (regularTimePeriod != null) {
            TimeSeriesDataPair timeSeriesDataPair = new TimeSeriesDataPair(regularTimePeriod, new Integer(0));
            int n = Collections.binarySearch(this.data, timeSeriesDataPair);
            return n;
        }
        return -1;
    }

    public Number getValue(int n) {
        return this.getDataPair(n).getValue();
    }

    public Number getValue(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        if (n >= 0) {
            return this.getValue(n);
        }
        return null;
    }

    public void add(TimeSeriesDataPair timeSeriesDataPair) throws SeriesException {
        if (timeSeriesDataPair == null) {
            throw new IllegalArgumentException("TimeSeries.add(...): null item not allowed.");
        }
        if (!timeSeriesDataPair.getPeriod().getClass().equals(this.timePeriodClass)) {
            String string = "TimeSeries.add(): you are trying to add data where the time ";
            string = string + "period class is " + timeSeriesDataPair.getPeriod().getClass().getName() + ", ";
            string = string + "but the TimeSeries is expecting an instance of " + this.timePeriodClass.getName() + ".";
            throw new SeriesException(string);
        }
        int n = Collections.binarySearch(this.data, timeSeriesDataPair);
        if (n < 0) {
            this.data.add(-n - 1, timeSeriesDataPair);
            if (this.getItemCount() > this.maximumItemCount) {
                this.data.remove(0);
            }
            if (this.getItemCount() > 1 && this.historyCount > 0) {
                long l = this.getTimePeriod(this.getItemCount() - 1).getSerialIndex();
                while (l - this.getTimePeriod(0).getSerialIndex() >= (long)this.historyCount) {
                    this.data.remove(0);
                }
            }
        } else {
            throw new SeriesException("TimeSeries.add(...): time period already exists.");
        }
        this.fireSeriesChanged();
    }

    public void add(RegularTimePeriod regularTimePeriod, double d) throws SeriesException {
        TimeSeriesDataPair timeSeriesDataPair = new TimeSeriesDataPair(regularTimePeriod, d);
        this.add(timeSeriesDataPair);
    }

    public void add(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataPair timeSeriesDataPair = new TimeSeriesDataPair(regularTimePeriod, number);
        this.add(timeSeriesDataPair);
    }

    public void update(RegularTimePeriod regularTimePeriod, Number number) throws SeriesException {
        TimeSeriesDataPair timeSeriesDataPair = new TimeSeriesDataPair(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataPair);
        if (n < 0) {
            throw new SeriesException("TimeSeries.update(TimePeriod, Number): period does not exist.");
        }
        TimeSeriesDataPair timeSeriesDataPair2 = (TimeSeriesDataPair)this.data.get(n);
        timeSeriesDataPair2.setValue(number);
        this.fireSeriesChanged();
    }

    public void update(int n, Number number) {
        TimeSeriesDataPair timeSeriesDataPair = this.getDataPair(n);
        timeSeriesDataPair.setValue(number);
        this.fireSeriesChanged();
    }

    public TimeSeries addAndOrUpdate(TimeSeries timeSeries) {
        TimeSeries timeSeries2 = new TimeSeries("Overwritten values from: " + this.getName());
        int n = 0;
        while (n < timeSeries.getItemCount()) {
            TimeSeriesDataPair timeSeriesDataPair = timeSeries.getDataPair(n);
            TimeSeriesDataPair timeSeriesDataPair2 = this.addOrUpdate(timeSeriesDataPair.getPeriod(), timeSeriesDataPair.getValue());
            if (timeSeriesDataPair2 != null) {
                try {
                    timeSeries2.add(timeSeriesDataPair2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimeSeries.addAndOrUpdate(series): unable to add data to overwritten series.");
                }
            }
            ++n;
        }
        return timeSeries2;
    }

    public TimeSeriesDataPair addOrUpdate(RegularTimePeriod regularTimePeriod, Number number) {
        TimeSeriesDataPair timeSeriesDataPair = null;
        TimeSeriesDataPair timeSeriesDataPair2 = new TimeSeriesDataPair(regularTimePeriod, number);
        int n = Collections.binarySearch(this.data, timeSeriesDataPair2);
        if (n >= 0) {
            TimeSeriesDataPair timeSeriesDataPair3 = (TimeSeriesDataPair)this.data.get(n);
            timeSeriesDataPair = (TimeSeriesDataPair)timeSeriesDataPair3.clone();
            timeSeriesDataPair3.setValue(number);
            this.fireSeriesChanged();
        } else {
            this.data.add(-n - 1, new TimeSeriesDataPair(regularTimePeriod, number));
            this.fireSeriesChanged();
        }
        return timeSeriesDataPair;
    }

    public void delete(RegularTimePeriod regularTimePeriod) {
        int n = this.getIndex(regularTimePeriod);
        this.data.remove(n);
    }

    public void delete(int n, int n2) {
        int n3 = 0;
        while (n3 <= n2 - n) {
            this.data.remove(n);
            ++n3;
        }
        this.fireSeriesChanged();
    }

    public Object clone() {
        TimeSeries timeSeries = this.createCopy(0, this.getItemCount() - 1);
        return timeSeries;
    }

    public TimeSeries createCopy(int n, int n2) {
        TimeSeries timeSeries = (TimeSeries)super.clone();
        timeSeries.data = new ArrayList();
        if (this.data.size() > 0) {
            int n3 = n;
            while (n3 <= n2) {
                TimeSeriesDataPair timeSeriesDataPair = (TimeSeriesDataPair)this.data.get(n3);
                TimeSeriesDataPair timeSeriesDataPair2 = (TimeSeriesDataPair)timeSeriesDataPair.clone();
                try {
                    timeSeries.add(timeSeriesDataPair2);
                }
                catch (SeriesException seriesException) {
                    System.err.println("TimeSeries.createCopy(): unable to add cloned data pair.");
                }
                ++n3;
            }
        }
        return timeSeries;
    }

    public TimeSeries createCopy(RegularTimePeriod regularTimePeriod, RegularTimePeriod regularTimePeriod2) {
        int n = this.getIndex(regularTimePeriod);
        int n2 = this.getIndex(regularTimePeriod2);
        TimeSeries timeSeries = this.createCopy(n, n2);
        return timeSeries;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

