/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.RegularTimePeriod;
import com.jrefinery.data.Second;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Millisecond
extends RegularTimePeriod {
    public static final int FIRST_MILLISECOND_IN_SECOND = 0;
    public static final int LAST_MILLISECOND_IN_SECOND = 999;
    private int millisecond;
    private Second second;

    public Millisecond() {
        this(new Date());
    }

    public Millisecond(int n, Second second) {
        this.millisecond = n;
        this.second = second;
    }

    public Millisecond(Date date) {
        this(date, RegularTimePeriod.DEFAULT_TIME_ZONE);
    }

    public Millisecond(Date date, TimeZone timeZone) {
        this.second = new Second(date, timeZone);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        this.millisecond = calendar.get(14);
    }

    public Second getSecond() {
        return this.second;
    }

    public long getMillisecond() {
        return this.millisecond;
    }

    public RegularTimePeriod previous() {
        Millisecond millisecond = null;
        if (this.millisecond != 0) {
            millisecond = new Millisecond(this.millisecond - 1, this.second);
        } else {
            Second second = (Second)this.second.previous();
            if (second != null) {
                millisecond = new Millisecond(999, second);
            }
        }
        return millisecond;
    }

    public RegularTimePeriod next() {
        Millisecond millisecond = null;
        if (this.millisecond != 999) {
            millisecond = new Millisecond(this.millisecond + 1, this.second);
        } else {
            Second second = (Second)this.second.next();
            if (second != null) {
                millisecond = new Millisecond(0, second);
            }
        }
        return millisecond;
    }

    public long getSerialIndex() {
        return this.second.getSerialIndex() * 1000L + (long)this.millisecond;
    }

    public boolean equals(Object object) {
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            return (long)this.millisecond == millisecond.getMillisecond() && this.second.equals(millisecond.getSecond());
        }
        return false;
    }

    public int compareTo(Object object) {
        int n;
        if (object instanceof Millisecond) {
            Millisecond millisecond = (Millisecond)object;
            long l = this.getFirstMillisecond() - millisecond.getFirstMillisecond();
            n = l > 0L ? 1 : (l < 0L ? -1 : 0);
        } else {
            n = object instanceof RegularTimePeriod ? 0 : 1;
        }
        return n;
    }

    public long getFirstMillisecond() {
        return this.second.getFirstMillisecond() + (long)this.millisecond;
    }

    public long getFirstMillisecond(Calendar calendar) {
        return this.second.getFirstMillisecond(calendar) + (long)this.millisecond;
    }

    public long getLastMillisecond() {
        return this.second.getFirstMillisecond() + (long)this.millisecond;
    }

    public long getLastMillisecond(Calendar calendar) {
        return this.second.getFirstMillisecond(calendar) + (long)this.millisecond;
    }

    public String toString() {
        return String.valueOf(this.getStart());
    }
}

