/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.Range;
import com.jrefinery.data.RangeInfo;
import com.jrefinery.data.XYDataset;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Vector;

public class JDBCXYDataset
extends AbstractDataset
implements XYDataset,
RangeInfo {
    Connection connection;
    Statement statement;
    ResultSet resultSet;
    ResultSetMetaData metaData;
    String[] columnNames = new String[0];
    Vector rows = new Vector(0);
    protected double maxValue = 0.0;
    protected double minValue = 0.0;
    public boolean isTimeSeries = false;

    public JDBCXYDataset(String string, String string2, String string3, String string4) {
        try {
            Class.forName(string2);
            this.connection = DriverManager.getConnection(string, string3, string4);
            this.statement = this.connection.createStatement();
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Cannot find the database driver classes.");
            System.err.println(classNotFoundException);
        }
        catch (SQLException sQLException) {
            System.err.println("Cannot connect to this database.");
            System.err.println(sQLException);
        }
    }

    public JDBCXYDataset(Connection connection) {
        try {
            this.connection = connection;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDBCXYDataset(Connection connection, String string) {
        this(connection);
        this.executeQuery(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(String string) {
        Object object = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int[] nArray = null;
        if (this.connection == null) {
            System.err.println("There is no database to execute the query.");
            return;
        }
        try {
            this.statement = this.connection.createStatement();
            this.resultSet = this.statement.executeQuery(string);
            this.metaData = this.resultSet.getMetaData();
            n3 = this.metaData.getColumnCount();
            nArray = new int[n3];
            n = 0;
            while (n < n3) {
                try {
                    int n5 = this.metaData.getColumnType(n + 1);
                    switch (n5) {
                        case -7: 
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 91: 
                        case 92: 
                        case 93: {
                            ++n4;
                            nArray[n] = n5;
                            break;
                        }
                        default: {
                            System.err.println("Unable to load column " + n + " (" + n5 + "," + this.metaData.getColumnClassName(n + 1) + ")");
                            nArray[n] = 0;
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    nArray[n] = 0;
                }
                ++n;
            }
            this.columnNames = new String[n4 - 1];
            n2 = 0;
            n = 1;
            while (n < n3) {
                if (nArray[n] != 0) {
                    this.columnNames[n2] = this.metaData.getColumnLabel(n + 1);
                    ++n2;
                }
                ++n;
            }
            if (this.rows != null) {
                n = 0;
                while (n < this.rows.size()) {
                    Vector vector = (Vector)this.rows.get(n);
                    vector.removeAllElements();
                    ++n;
                }
                this.rows.removeAllElements();
            }
            switch (nArray[0]) {
                case 91: 
                case 92: 
                case 93: {
                    this.isTimeSeries = true;
                    break;
                }
                default: {
                    this.isTimeSeries = false;
                }
            }
            this.rows = new Vector();
            while (this.resultSet.next()) {
                Vector<Number> vector = new Vector<Number>();
                n = 0;
                while (n < n3) {
                    object = this.resultSet.getObject(n + 1);
                    switch (nArray[n]) {
                        case -5: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 6: 
                        case 7: 
                        case 8: {
                            vector.addElement((Number)object);
                            break;
                        }
                        case 91: 
                        case 92: 
                        case 93: {
                            vector.addElement(new Long(((Date)object).getTime()));
                            break;
                        }
                        case 0: {
                            break;
                        }
                        default: {
                            System.err.println("Unknown data");
                            nArray[n] = 0;
                        }
                    }
                    ++n;
                }
                this.rows.addElement(vector);
            }
            if (this.rows.size() == 0) {
                Vector<Integer> vector = new Vector<Integer>();
                n = 0;
                while (n < n3) {
                    if (nArray[n] != 0) {
                        vector.addElement(new Integer(0));
                    }
                    ++n;
                }
                this.rows.addElement(vector);
            }
            if (this.rows.size() < 1) {
                this.maxValue = 0.0;
                this.minValue = 0.0;
            } else {
                Vector vector = (Vector)this.rows.elementAt(0);
                this.minValue = this.maxValue = ((Number)vector.get(1)).doubleValue();
                int n6 = 0;
                while (n6 < this.rows.size()) {
                    vector = (Vector)this.rows.elementAt(n6);
                    n = 1;
                    while (n < n3) {
                        double d = ((Number)vector.get(n)).doubleValue();
                        if (d < this.minValue) {
                            this.minValue = d;
                        }
                        if (d > this.maxValue) {
                            this.maxValue = d;
                        }
                        ++n;
                    }
                    ++n6;
                }
            }
            this.fireDatasetChanged();
        }
        catch (SQLException sQLException) {
            System.err.println(sQLException);
            sQLException.printStackTrace();
        }
        finally {
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (Exception exception) {}
            }
            if (this.statement != null) {
                try {
                    this.statement.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Number getXValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(0);
    }

    public Number getYValue(int n, int n2) {
        Vector vector = (Vector)this.rows.elementAt(n2);
        return (Number)vector.elementAt(n + 1);
    }

    public int getItemCount(int n) {
        return this.rows.size();
    }

    public int getSeriesCount() {
        return this.columnNames.length;
    }

    public String getSeriesName(int n) {
        if (n < this.columnNames.length && this.columnNames[n] != null) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getLegendItemCount() {
        return this.getSeriesCount();
    }

    public String[] getLegendItemLabels() {
        return this.columnNames;
    }

    public Number getMinimumRangeValue() {
        return new Double(this.minValue);
    }

    public Number getMaximumRangeValue() {
        return new Double(this.maxValue);
    }

    public void close() {
        try {
            this.resultSet.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.statement.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }

    public Range getValueRange() {
        return new Range(this.minValue, this.maxValue);
    }
}

