/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.ContourDataset;
import com.jrefinery.data.Range;
import java.util.Arrays;
import java.util.Date;
import java.util.Vector;

public class DefaultContourDataset
extends AbstractDataset
implements ContourDataset {
    protected String seriesName = null;
    protected Number[] xValues = null;
    protected Number[] yValues = null;
    protected Number[] zValues = null;
    protected int[] xIndex = null;
    protected int numX = 0;
    protected int numY = 0;
    boolean[] dateAxis = new boolean[3];

    public DefaultContourDataset() {
    }

    public DefaultContourDataset(String string, Object[] objectArray, Object[] objectArray2, Object[] objectArray3) {
        Object object;
        this.seriesName = string;
        this.xValues = new Double[objectArray.length];
        this.yValues = new Double[objectArray2.length];
        this.zValues = new Double[objectArray3.length];
        Vector<Integer> vector = new Vector<Integer>();
        double d = 1.123452E31;
        int n = 0;
        while (n < this.xValues.length) {
            if (objectArray[n] != null) {
                object = null;
                if (objectArray[n] instanceof Number) {
                    object = (Number)objectArray[n];
                } else if (objectArray[n] instanceof Date) {
                    this.dateAxis[0] = true;
                    Date date = (Date)objectArray[n];
                    object = new Long(date.getTime());
                } else {
                    object = new Integer(0);
                }
                this.xValues[n] = new Double(((Number)object).doubleValue());
                if (d != this.xValues[n].doubleValue()) {
                    vector.add(new Integer(n));
                    d = this.xValues[n].doubleValue();
                }
            }
            ++n;
        }
        object = vector.toArray();
        this.xIndex = new int[((Object[])object).length];
        int n2 = 0;
        while (n2 < ((Object[])object).length) {
            this.xIndex[n2] = (Integer)object[n2];
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.yValues.length) {
            this.yValues[n3] = (Double)objectArray2[n3];
            if (objectArray3[n3] != null) {
                this.zValues[n3] = (Double)objectArray3[n3];
            }
            ++n3;
        }
    }

    public static Object[][] formObjectArray(double[][] dArray) {
        Object[][] objectArray = new Double[dArray.length][dArray[0].length];
        int n = 0;
        while (n < objectArray.length) {
            int n2 = 0;
            while (n2 < objectArray[n].length) {
                objectArray[n][n2] = new Double(dArray[n][n2]);
                ++n2;
            }
            ++n;
        }
        return objectArray;
    }

    public static Object[] formObjectArray(double[] dArray) {
        Object[] objectArray = new Double[dArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = new Double(dArray[n]);
            ++n;
        }
        return objectArray;
    }

    public int getItemCount(int n) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues.length;
    }

    public double getMaxZValue() {
        double d = -1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d = Math.max(d, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d;
    }

    public double getMinZValue() {
        double d = 1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d = Math.min(d, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d;
    }

    public Range getZValueRange(Range range, Range range2) {
        double d = range.getLowerBound();
        double d2 = range2.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = range2.getUpperBound();
        double d5 = 1.0E20;
        double d6 = -1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.xValues[n].doubleValue() >= d && this.xValues[n].doubleValue() <= d3 && this.yValues[n].doubleValue() >= d2 && this.yValues[n].doubleValue() <= d4 && this.zValues[n] != null) {
                d5 = Math.min(d5, this.zValues[n].doubleValue());
                d6 = Math.max(d6, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return new Range(d5, d6);
    }

    public double getMinZValue(double d, double d2, double d3, double d4) {
        double d5 = 1.0E20;
        int n = 0;
        while (n < this.zValues.length) {
            if (this.zValues[n] != null) {
                d5 = Math.min(d5, this.zValues[n].doubleValue());
            }
            ++n;
        }
        return d5;
    }

    public int getSeriesCount() {
        return 1;
    }

    public String getSeriesName(int n) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.seriesName;
    }

    public int[] getXIndices() {
        return this.xIndex;
    }

    public Number[] getXValues() {
        return this.xValues;
    }

    public Number getXValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.xValues[n2];
    }

    public Number getXValue(int n) {
        return this.xValues[n];
    }

    public Number[] getYValues() {
        return this.yValues;
    }

    public Number getYValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.yValues[n2];
    }

    public Number[] getZValues() {
        return this.zValues;
    }

    public Number getZValue(int n, int n2) {
        if (n > 0) {
            System.out.println("Only one series for contour");
        }
        return this.zValues[n2];
    }

    public int[] indexX() {
        int[] nArray = new int[this.xValues.length];
        int n = 0;
        while (n < nArray.length) {
            nArray[n] = this.indexX(n);
            ++n;
        }
        return nArray;
    }

    public int indexX(int n) {
        int n2 = Arrays.binarySearch(this.xIndex, n);
        if (n2 >= 0) {
            return n2;
        }
        return -1 * n2 - 2;
    }

    public int indexY(int n) {
        return n / this.xValues.length;
    }

    public int indexZ(int n, int n2) {
        return this.xValues.length * n2 + n;
    }

    public boolean isDateAxis(int n) {
        if (n < 0 || n > 2) {
            return false;
        }
        return this.dateAxis[n];
    }

    public void setSeriesNames(String[] stringArray) {
        if (stringArray.length > 1) {
            System.out.println("Contours only support one series");
        }
        this.seriesName = stringArray[0];
        this.fireDatasetChanged();
    }
}

