/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data;

import com.jrefinery.data.AbstractDataset;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.PieDataset;
import java.util.List;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset {
    public static final int ROW = 0;
    public static final int COLUMN = 1;
    private CategoryDataset source;
    private int extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset categoryDataset, int n, int n2) {
        this.source = categoryDataset;
        this.extract = n;
        this.index = n2;
    }

    public int getItemCount() {
        int n = 0;
        switch (this.extract) {
            case 0: {
                n = this.source.getColumnCount();
                break;
            }
            case 1: {
                n = this.source.getRowCount();
                break;
            }
        }
        return n;
    }

    public Number getValue(int n) {
        Number number = null;
        switch (this.extract) {
            case 0: {
                number = this.source.getValue(this.index, n);
                break;
            }
            case 1: {
                number = this.source.getValue(n, this.index);
                break;
            }
        }
        return number;
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        switch (this.extract) {
            case 0: {
                comparable = this.source.getColumnKey(n);
                break;
            }
            case 1: {
                comparable = this.source.getRowKey(n);
                break;
            }
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        switch (this.extract) {
            case 0: {
                n = this.source.getColumnIndex(comparable);
                break;
            }
            case 1: {
                n = this.source.getRowIndex(comparable);
                break;
            }
        }
        return n;
    }

    public List getKeys() {
        List list = null;
        switch (this.extract) {
            case 0: {
                list = this.source.getColumnKeys();
                break;
            }
            case 1: {
                list = this.source.getRowKeys();
                break;
            }
        }
        return list;
    }

    public Number getValue(Comparable comparable) {
        Number number = null;
        int n = this.getIndex(comparable);
        switch (this.extract) {
            case 0: {
                number = this.source.getValue(this.index, n);
                break;
            }
            case 1: {
                number = this.source.getValue(n, this.index);
                break;
            }
        }
        return number;
    }
}

