/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.axis.Axis;
import com.jrefinery.chart.axis.ColorBarAxis;
import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.ui.AxisPropertyEditPanel;
import com.jrefinery.chart.ui.NumberAxisPropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.ColorPalette;
import com.jrefinery.ui.GreyPalette;
import com.jrefinery.ui.PaletteChooserPanel;
import com.jrefinery.ui.PaletteSample;
import com.jrefinery.ui.RainbowPalette;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class ColorBarPropertyEditPanel
extends NumberAxisPropertyEditPanel {
    private JCheckBox invertPaletteCheckBox;
    private boolean invertPalette = false;
    private JCheckBox stepPaletteCheckBox;
    private boolean stepPalette = false;
    private PaletteSample currentPalette;
    private PaletteSample[] availablePaletteSamples;

    public ColorBarPropertyEditPanel(NumberAxis numberAxis) {
        super(numberAxis);
        this.invertPalette = ((ColorBarAxis)((Object)numberAxis)).getColorPalette().isInverse();
        this.stepPalette = ((ColorBarAxis)((Object)numberAxis)).getColorPalette().isStepped();
        this.currentPalette = new PaletteSample(((ColorBarAxis)((Object)numberAxis)).getColorPalette());
        this.availablePaletteSamples = new PaletteSample[2];
        this.availablePaletteSamples[0] = new PaletteSample((ColorPalette)new RainbowPalette());
        this.availablePaletteSamples[1] = new PaletteSample((ColorPalette)new GreyPalette());
        JTabbedPane jTabbedPane = this.getOtherTabs();
        JPanel jPanel = new JPanel((LayoutManager)new LCBLayout(4));
        jPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(new JPanel());
        this.invertPaletteCheckBox = new JCheckBox("Invert Palette:", this.invertPalette);
        this.invertPaletteCheckBox.setActionCommand("invertPalette");
        this.invertPaletteCheckBox.addActionListener(this);
        jPanel.add(this.invertPaletteCheckBox);
        jPanel.add(new JPanel());
        jPanel.add(new JPanel());
        this.stepPaletteCheckBox = new JCheckBox("Step Palette:", this.stepPalette);
        this.stepPaletteCheckBox.setActionCommand("stepPalette");
        this.stepPaletteCheckBox.addActionListener(this);
        jPanel.add(this.stepPaletteCheckBox);
        jPanel.add(new JPanel());
        jPanel.add(new JLabel("Palette:"));
        JButton jButton = new JButton("Set palette...");
        jButton.setActionCommand("PaletteChoice");
        jButton.addActionListener(this);
        jPanel.add((Component)this.currentPalette);
        jPanel.add(jButton);
        jTabbedPane.add("Palette", jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("PaletteChoice")) {
            this.attemptPaletteSelection();
        } else if (string.equals("invertPalette")) {
            this.invertPalette = this.invertPaletteCheckBox.isSelected();
        } else if (string.equals("stepPalette")) {
            this.stepPalette = this.stepPaletteCheckBox.isSelected();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void attemptPaletteSelection() {
        PaletteChooserPanel paletteChooserPanel = new PaletteChooserPanel(null, this.availablePaletteSamples);
        int n = JOptionPane.showConfirmDialog(this, paletteChooserPanel, "Palette Selection", 2, -1);
        if (n == 0) {
            double d = this.currentPalette.getPalette().getMinZ();
            double d2 = this.currentPalette.getPalette().getMaxZ();
            this.currentPalette.setPalette(paletteChooserPanel.getSelectedPalette());
            this.currentPalette.getPalette().setMinZ(d);
            this.currentPalette.getPalette().setMaxZ(d2);
        }
    }

    public void setAxisProperties(Axis axis) {
        super.setAxisProperties(axis);
        ((ColorBarAxis)((Object)axis)).setColorPalette(this.currentPalette.getPalette());
        ((ColorBarAxis)((Object)axis)).getColorPalette().setInverse(this.invertPalette);
        ((ColorBarAxis)((Object)axis)).getColorPalette().setStepped(this.stepPalette);
    }

    public static AxisPropertyEditPanel getInstance(Axis axis) {
        if (axis != null) {
            if (axis instanceof ColorBarAxis) {
                return new ColorBarPropertyEditPanel((NumberAxis)axis);
            }
            return null;
        }
        return null;
    }
}

