/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.ui;

import com.jrefinery.chart.axis.Axis;
import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.ui.NumberAxisPropertyEditPanel;
import com.jrefinery.layout.LCBLayout;
import com.jrefinery.ui.FontChooserPanel;
import com.jrefinery.ui.FontDisplayField;
import com.jrefinery.ui.InsetsChooserPanel;
import com.jrefinery.ui.InsetsTextField;
import com.jrefinery.ui.PaintSample;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class AxisPropertyEditPanel
extends JPanel
implements ActionListener {
    private JTextField label;
    private Font labelFont;
    private PaintSample labelPaintSample;
    private JTextField labelFontField;
    private Font tickLabelFont;
    private JTextField tickLabelFontField;
    private PaintSample tickLabelPaintSample;
    private JPanel slot1;
    private JPanel slot2;
    private JCheckBox showTickLabelsCheckBox;
    private JCheckBox showTickMarksCheckBox;
    private InsetsTextField tickLabelInsetsTextField;
    private InsetsTextField labelInsetsTextField;
    private Insets tickLabelInsets;
    private Insets labelInsets;
    private JTabbedPane otherTabs;

    public static AxisPropertyEditPanel getInstance(Axis axis) {
        if (axis != null) {
            if (axis instanceof NumberAxis) {
                return new NumberAxisPropertyEditPanel((NumberAxis)axis);
            }
            return new AxisPropertyEditPanel(axis);
        }
        return null;
    }

    public AxisPropertyEditPanel(Axis axis) {
        this.labelFont = axis.getLabelFont();
        this.labelPaintSample = new PaintSample(axis.getLabelPaint());
        this.tickLabelFont = axis.getTickLabelFont();
        this.tickLabelPaintSample = new PaintSample(axis.getTickLabelPaint());
        this.tickLabelInsets = axis.getTickLabelInsets();
        this.labelInsets = axis.getLabelInsets();
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "General:"));
        JPanel jPanel2 = new JPanel((LayoutManager)new LCBLayout(5));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        jPanel2.add(new JLabel("Label:"));
        this.label = new JTextField(axis.getLabel());
        jPanel2.add(this.label);
        jPanel2.add(new JPanel());
        jPanel2.add(new JLabel("Font:"));
        this.labelFontField = new FontDisplayField(this.labelFont);
        jPanel2.add(this.labelFontField);
        JButton jButton = new JButton("Select...");
        jButton.setActionCommand("SelectLabelFont");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel2.add(new JLabel("Paint:"));
        jPanel2.add((Component)this.labelPaintSample);
        jButton = new JButton("Select...");
        jButton.setActionCommand("SelectLabelPaint");
        jButton.addActionListener(this);
        jPanel2.add(jButton);
        jPanel2.add(new JLabel("Label Insets:"));
        jButton = new JButton("Edit...");
        jButton.setActionCommand("LabelInsets");
        jButton.addActionListener(this);
        this.labelInsetsTextField = new InsetsTextField(this.labelInsets);
        jPanel2.add((Component)this.labelInsetsTextField);
        jPanel2.add(jButton);
        jPanel2.add(new JLabel("Tick Label Insets:"));
        jButton = new JButton("Edit...");
        jButton.setActionCommand("TickLabelInsets");
        jButton.addActionListener(this);
        this.tickLabelInsetsTextField = new InsetsTextField(this.tickLabelInsets);
        jPanel2.add((Component)this.tickLabelInsetsTextField);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        this.add((Component)jPanel, "North");
        this.slot1 = new JPanel(new BorderLayout());
        JPanel jPanel3 = new JPanel(new BorderLayout());
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Other:"));
        this.otherTabs = new JTabbedPane();
        this.otherTabs.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel jPanel4 = new JPanel((LayoutManager)new LCBLayout(3));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.showTickLabelsCheckBox = new JCheckBox("Show tick labels", axis.isTickLabelsVisible());
        jPanel4.add(this.showTickLabelsCheckBox);
        jPanel4.add(new JPanel());
        jPanel4.add(new JPanel());
        jPanel4.add(new JLabel("Tick label font:"));
        this.tickLabelFontField = new FontDisplayField(this.tickLabelFont);
        jPanel4.add(this.tickLabelFontField);
        jButton = new JButton("Select...");
        jButton.setActionCommand("SelectTickLabelFont");
        jButton.addActionListener(this);
        jPanel4.add(jButton);
        this.showTickMarksCheckBox = new JCheckBox("Show tick marks", axis.isTickMarksVisible());
        jPanel4.add(this.showTickMarksCheckBox);
        jPanel4.add(new JPanel());
        jPanel4.add(new JPanel());
        this.otherTabs.add("Ticks", jPanel4);
        jPanel3.add(this.otherTabs);
        this.slot1.add(jPanel3);
        this.slot2 = new JPanel(new BorderLayout());
        this.slot2.add((Component)this.slot1, "North");
        this.add(this.slot2);
    }

    public String getLabel() {
        return this.label.getText();
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public Paint getLabelPaint() {
        return this.labelPaintSample.getPaint();
    }

    public boolean isTickLabelsVisible() {
        return this.showTickLabelsCheckBox.isSelected();
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaintSample.getPaint();
    }

    public boolean isTickMarksVisible() {
        return this.showTickMarksCheckBox.isSelected();
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets == null ? new Insets(0, 0, 0, 0) : this.tickLabelInsets;
    }

    public Insets getLabelInsets() {
        return this.labelInsets == null ? new Insets(0, 0, 0, 0) : this.labelInsets;
    }

    public JTabbedPane getOtherTabs() {
        return this.otherTabs;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("SelectLabelFont")) {
            this.attemptLabelFontSelection();
        } else if (string.equals("SelectLabelPaint")) {
            this.attemptModifyLabelPaint();
        } else if (string.equals("SelectTickLabelFont")) {
            this.attemptTickLabelFontSelection();
        } else if (string.equals("LabelInsets")) {
            this.editLabelInsets();
        } else if (string.equals("TickLabelInsets")) {
            this.editTickLabelInsets();
        }
    }

    private void attemptLabelFontSelection() {
        FontChooserPanel fontChooserPanel = new FontChooserPanel(this.labelFont);
        int n = JOptionPane.showConfirmDialog(this, fontChooserPanel, "Font Selection", 2, -1);
        if (n == 0) {
            this.labelFont = fontChooserPanel.getSelectedFont();
            this.labelFontField.setText(this.labelFont.getFontName() + " " + this.labelFont.getSize());
        }
    }

    private void attemptModifyLabelPaint() {
        Color color = JColorChooser.showDialog(this, "Label Color", Color.blue);
        if (color != null) {
            this.labelPaintSample.setPaint((Paint)color);
        }
    }

    public void attemptTickLabelFontSelection() {
        FontChooserPanel fontChooserPanel = new FontChooserPanel(this.tickLabelFont);
        int n = JOptionPane.showConfirmDialog(this, fontChooserPanel, "Font Selection", 2, -1);
        if (n == 0) {
            this.tickLabelFont = fontChooserPanel.getSelectedFont();
            this.tickLabelFontField.setText(this.tickLabelFont.getFontName() + " " + this.tickLabelFont.getSize());
        }
    }

    private void editTickLabelInsets() {
        InsetsChooserPanel insetsChooserPanel = new InsetsChooserPanel(this.tickLabelInsets);
        int n = JOptionPane.showConfirmDialog(this, insetsChooserPanel, "Edit Insets", 2, -1);
        if (n == 0) {
            this.tickLabelInsets = insetsChooserPanel.getInsets();
            this.tickLabelInsetsTextField.setInsets(this.tickLabelInsets);
        }
    }

    private void editLabelInsets() {
        InsetsChooserPanel insetsChooserPanel = new InsetsChooserPanel(this.labelInsets);
        int n = JOptionPane.showConfirmDialog(this, insetsChooserPanel, "Edit Insets", 2, -1);
        if (n == 0) {
            this.labelInsets = insetsChooserPanel.getInsets();
            this.labelInsetsTextField.setInsets(this.labelInsets);
        }
    }

    public void setAxisProperties(Axis axis) {
        axis.setLabel(this.getLabel());
        axis.setLabelFont(this.getLabelFont());
        axis.setLabelPaint(this.getLabelPaint());
        axis.setTickMarksVisible(this.isTickMarksVisible());
        axis.setTickLabelsVisible(this.isTickLabelsVisible());
        axis.setTickLabelFont(this.getTickLabelFont());
        axis.setTickLabelPaint(this.getTickLabelPaint());
        axis.setTickLabelInsets(this.getTickLabelInsets());
        axis.setLabelInsets(this.getLabelInsets());
    }
}

