/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import java.text.DateFormat;
import java.text.NumberFormat;

public class StandardCategoryToolTipGenerator
implements CategoryToolTipGenerator {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public StandardCategoryToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public StandardCategoryToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public StandardCategoryToolTipGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        String string = "";
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Comparable comparable = categoryDataset.getRowKey(n);
            if (comparable != null) {
                string = string + comparable.toString() + ", ";
            }
            Comparable comparable2 = categoryDataset.getColumnKey(n2);
            String string2 = comparable2.toString();
            String string3 = null;
            if (this.numberFormat != null) {
                string3 = this.numberFormat.format(number);
            } else if (this.dateFormat != null) {
                string3 = this.dateFormat.format(number);
            }
            string = string + string2 + " = " + string3;
        }
        return string;
    }
}

