/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.tooltips;

import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import java.text.DateFormat;
import java.text.NumberFormat;

public class IntervalCategoryToolTipGenerator
implements CategoryToolTipGenerator {
    private NumberFormat numberFormat;
    private DateFormat dateFormat;

    public IntervalCategoryToolTipGenerator() {
        this(NumberFormat.getInstance());
    }

    public IntervalCategoryToolTipGenerator(NumberFormat numberFormat) {
        this.numberFormat = numberFormat;
        this.dateFormat = null;
    }

    public IntervalCategoryToolTipGenerator(DateFormat dateFormat) {
        this.numberFormat = null;
        this.dateFormat = dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public String generateToolTip(CategoryDataset categoryDataset, int n, int n2) {
        Object object;
        Number number;
        Number number2 = number = categoryDataset.getValue(n, n2);
        Number number3 = number;
        if (categoryDataset instanceof IntervalCategoryDataset) {
            object = (IntervalCategoryDataset)categoryDataset;
            number2 = object.getStartValue(n, n2);
            number3 = object.getEndValue(n, n2);
        }
        object = "";
        if (number2 != null && number3 != null) {
            Comparable comparable = categoryDataset.getRowKey(n);
            if (comparable != null) {
                object = (String)object + comparable.toString() + ", ";
            }
            String string = categoryDataset.getColumnKey(n2).toString();
            String string2 = null;
            String string3 = null;
            if (this.numberFormat != null) {
                string2 = this.numberFormat.format(number2);
                string3 = this.numberFormat.format(number3);
            } else if (this.dateFormat != null) {
                string2 = this.dateFormat.format(number2);
                string3 = this.dateFormat.format(number3);
            }
            object = (String)object + string + " : " + string2 + " to " + string3;
        }
        return object;
    }
}

