/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.chart.renderer.AbstractXYItemRenderer;
import com.jrefinery.chart.renderer.XYItemRenderer;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class YIntervalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    public YIntervalRenderer() {
        this((XYToolTipGenerator)null);
    }

    public YIntervalRenderer(XYToolTipGenerator xYToolTipGenerator) {
        super(xYToolTipGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Rectangle rectangle = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Number number = intervalXYDataset.getXValue(n2, n3);
        Number number2 = intervalXYDataset.getStartYValue(n2, n3);
        Number number3 = intervalXYDataset.getEndYValue(n2, n3);
        double d = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
        double d2 = valueAxis2.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        double d3 = valueAxis2.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        Line2D.Double double_ = new Line2D.Double(d, d2, d, d3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        graphics2D.draw(double_);
        Shape shape = this.getItemShape(n, n2, n3);
        Shape shape2 = this.createTransformedShape(shape, d, d3);
        graphics2D.fill(shape2);
        Shape shape3 = this.createTransformedShape(shape, d, d2);
        graphics2D.fill(shape3);
        if (entityCollection != null) {
            if (rectangle == null) {
                rectangle = double_.getBounds();
            }
            String string = "";
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(rectangle, string, string2, n2, n3);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

