/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.chart.renderer.AbstractXYItemRenderer;
import com.jrefinery.chart.renderer.XYItemRenderer;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.chart.urls.XYURLGenerator;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class VerticalXYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer {
    private double margin;
    private double translatedRangeZero;

    public VerticalXYBarRenderer() {
        this(0.0);
    }

    public VerticalXYBarRenderer(double d) {
        this(d, null, null);
    }

    public VerticalXYBarRenderer(double d, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(xYToolTipGenerator, xYURLGenerator);
        this.margin = d;
    }

    public void setMargin(double d) {
        Double d2 = new Double(this.margin);
        this.margin = d;
        this.firePropertyChanged("VerticalXYBarRenderer.margin", d2, new Double(d));
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, xYPlot, xYDataset, chartRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxis();
        this.translatedRangeZero = valueAxis.translateValueToJava2D(0.0, rectangle2D);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        EntityCollection entityCollection;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2, n3);
        Paint paint2 = this.getSeriesOutlinePaint(n, n2);
        Number number = intervalXYDataset.getYValue(n2, n3);
        double d = valueAxis2.translateValueToJava2D(number.doubleValue(), rectangle2D);
        Number number2 = intervalXYDataset.getStartXValue(n2, n3);
        double d2 = valueAxis.translateValueToJava2D(number2.doubleValue(), rectangle2D);
        Number number3 = intervalXYDataset.getEndXValue(n2, n3);
        double d3 = valueAxis.translateValueToJava2D(number3.doubleValue(), rectangle2D);
        double d4 = Math.max(1.0, d3 - d2);
        double d5 = Math.abs(d - this.translatedRangeZero);
        if (this.margin > 0.0) {
            double d6 = d4 * this.margin;
            d4 -= d6;
            d2 += d6 / 2.0;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d2, Math.min(this.translatedRangeZero, d), d4, d5);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (d3 - d2 > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
        }
        if (chartRenderingInfo != null && (entityCollection = chartRenderingInfo.getEntityCollection()) != null) {
            String string = "";
            if (this.getToolTipGenerator() != null) {
                string = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, string, string2, n2, n3);
            entityCollection.addEntity(xYItemEntity);
        }
    }
}

