/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.CategoryItemRenderer;
import com.jrefinery.chart.renderer.VerticalBarRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.StatisticalCategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class VerticalStatisticalBarRenderer
extends VerticalBarRenderer
implements CategoryItemRenderer {
    public VerticalStatisticalBarRenderer() {
        this(null, null);
    }

    public VerticalStatisticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalStatisticalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalStatisticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        if (!(categoryDataset instanceof StatisticalCategoryDataset)) {
            throw new IllegalArgumentException("VerticalStatisticalBarRenderer.drawCategoryItem() : the data should be of type StatisticalCategoryDataSet only.");
        }
        StatisticalCategoryDataset statisticalCategoryDataset = (StatisticalCategoryDataset)categoryDataset;
        double d = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
        int n4 = this.getRowCount();
        int n5 = this.getColumnCount();
        if (n4 > 1) {
            double d2 = rectangle2D.getWidth() * this.getItemMargin() / (double)(n5 * (n4 - 1));
            d += (double)n2 * (this.getBarWidth() + d2);
        } else {
            d += (double)n2 * this.getBarWidth();
        }
        Number number = statisticalCategoryDataset.getMeanValue(n2, n3);
        double d3 = number.doubleValue();
        double d4 = 0.0;
        double d5 = this.getLowerClip();
        double d6 = this.getUpperClip();
        if (d6 <= 0.0) {
            if (d3 >= d6) {
                return;
            }
            d4 = d6;
            if (d3 <= d5) {
                d3 = d5;
            }
        } else if (d5 <= 0.0) {
            if (d3 >= d6) {
                d3 = d6;
            } else if (d3 <= d5) {
                d3 = d5;
            }
        } else {
            if (d3 <= d5) {
                return;
            }
            d4 = this.getLowerClip();
            if (d3 >= d6) {
                d3 = d6;
            }
        }
        double d7 = valueAxis.translateValueToJava2D(d4, rectangle2D);
        double d8 = valueAxis.translateValueToJava2D(d3, rectangle2D);
        double d9 = Math.min(d8, d7);
        double d10 = this.getBarWidth();
        double d11 = Math.abs(d8 - d7);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d9, d10, d11);
        Paint paint = this.getItemPaint(0, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
            graphics2D.draw(double_);
        }
        double d12 = statisticalCategoryDataset.getStdDevValue(n2, n3).doubleValue();
        double d13 = valueAxis.translateValueToJava2D(number.doubleValue() + d12, rectangle2D);
        double d14 = valueAxis.translateValueToJava2D(number.doubleValue() - d12, rectangle2D);
        Line2D.Double double_2 = null;
        double_2 = new Line2D.Double(d + d10 / 2.0, d14, d + d10 / 2.0, d13);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d10 / 2.0 - 5.0, d13, d + d10 / 2.0 + 5.0, d13);
        graphics2D.draw(double_2);
        double_2 = new Line2D.Double(d + d10 / 2.0 - 5.0, d14, d + d10 / 2.0 + 5.0, d14);
        graphics2D.draw(double_2);
    }
}

