/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.BarRenderer;
import com.jrefinery.chart.renderer.CategoryItemRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class VerticalBarRenderer
extends BarRenderer
implements CategoryItemRenderer {
    public VerticalBarRenderer() {
        this(null, null);
    }

    public VerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public VerticalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public VerticalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getColumnCount();
            int n2 = categoryDataset.getRowCount();
            double d = 0.0;
            double d2 = 0.0;
            if (n > 1) {
                d = categoryAxis.getCategoryMargin();
            }
            if (n2 > 1) {
                d2 = this.getItemMargin();
            }
            double d3 = rectangle2D.getWidth() * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d - d2);
            if (n2 * n > 0) {
                this.setBarWidth(d3 / (double)(categoryDataset.getColumnCount() * categoryDataset.getRowCount()));
            } else {
                this.setBarWidth(d3);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            double d;
            double d2 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
            int n4 = this.getRowCount();
            int n5 = this.getColumnCount();
            if (n4 > 1) {
                d = rectangle2D.getWidth() * this.getItemMargin() / (double)(n5 * (n4 - 1));
                d2 += (double)n2 * (this.getBarWidth() + d);
            } else {
                d2 += (double)n2 * this.getBarWidth();
            }
            d = number.doubleValue();
            double d3 = 0.0;
            double d4 = this.getLowerClip();
            double d5 = this.getUpperClip();
            if (d5 <= 0.0) {
                if (d >= d5) {
                    return;
                }
                d3 = d5;
                if (d <= d4) {
                    d = d4;
                }
            } else if (d4 <= 0.0) {
                if (d >= d5) {
                    d = d5;
                } else if (d <= d4) {
                    d = d4;
                }
            } else {
                if (d <= d4) {
                    return;
                }
                d3 = this.getLowerClip();
                if (d >= d5) {
                    d = d5;
                }
            }
            double d6 = valueAxis.translateValueToJava2D(d3, rectangle2D);
            double d7 = valueAxis.translateValueToJava2D(d, rectangle2D);
            double d8 = Math.min(d7, d6);
            double d9 = this.getBarWidth();
            double d10 = Math.abs(d7 - d6);
            Rectangle2D.Double double_ = new Rectangle2D.Double(d2, d8, d9, d10);
            Paint paint = null;
            paint = !this.getUseCategoriesPaint() ? this.getItemPaint(n, n2, n3) : this.getCategoryPaint(n3);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_);
                if (categoryPlot.getValueLabelsVisible()) {
                    object4 = categoryPlot.getValueLabelFont();
                    graphics2D.setFont((Font)object4);
                    object3 = categoryPlot.getValueLabelPaint();
                    graphics2D.setPaint((Paint)object3);
                    object2 = categoryPlot.getValueLabelFormatter();
                    object = ((Format)object2).format(number);
                    FontMetrics fontMetrics = graphics2D.getFontMetrics();
                    int n6 = (int)((this.getBarWidth() - (double)fontMetrics.stringWidth((String)object)) / 2.0);
                    graphics2D.drawString((String)object, (int)(d2 + (double)n6), (int)(d8 - 5.0));
                }
            }
            if (this.getInfo() != null && (object4 = this.getInfo().getEntityCollection()) != null) {
                object3 = null;
                if (this.getToolTipGenerator() != null) {
                    object3 = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                object2 = null;
                if (this.getURLGenerator() != null) {
                    object2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                object = new CategoryItemEntity(double_, (String)object3, (String)object2, n2, categoryDataset.getColumnKey(n3), n3);
                object4.addEntity((ChartEntity)object);
            }
        }
    }
}

