/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.renderer.DefaultDrawingSupplier;
import com.jrefinery.chart.renderer.DrawingSupplier;
import java.awt.BasicStroke;
import java.awt.Stroke;

public class StrokeTable {
    private int rows = 0;
    private int columns = 0;
    private Stroke[][] data = new Stroke[0][0];
    private DrawingSupplier supplier = new DefaultDrawingSupplier();

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.supplier = drawingSupplier;
    }

    public int getRowCount() {
        return this.rows;
    }

    public int getColumnCount() {
        return this.columns;
    }

    public Stroke getStroke(int n, int n2) {
        Stroke[] strokeArray;
        Stroke stroke = null;
        if (n < this.data.length && n2 < (strokeArray = this.data[n]).length) {
            stroke = strokeArray[n2];
        }
        if (stroke == null) {
            stroke = this.supplier != null ? this.supplier.getNextStroke() : new BasicStroke(1.0f);
            this.setStroke(n, n2, stroke);
        }
        return stroke;
    }

    public void setStroke(int n, int n2, Stroke stroke) {
        int n3;
        Stroke[][] strokeArrayArray;
        if (n >= this.data.length) {
            strokeArrayArray = new Stroke[n + 1][];
            int n4 = 0;
            while (n4 < this.data.length) {
                strokeArrayArray[n4] = this.data[n4];
                ++n4;
            }
            n3 = this.data.length;
            while (n3 <= n) {
                strokeArrayArray[n3] = new Stroke[0];
                ++n3;
            }
            this.data = strokeArrayArray;
        }
        if (n2 >= (strokeArrayArray = this.data[n]).length) {
            Stroke[] strokeArray = new Stroke[n2 + 1];
            n3 = 0;
            while (n3 < strokeArrayArray.length) {
                strokeArray[n3] = strokeArrayArray[n3];
                ++n3;
            }
            strokeArray[n2] = stroke;
            this.data[n] = strokeArray;
        } else {
            strokeArrayArray[n2] = stroke;
        }
    }
}

