/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis3D;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.VerticalBarRenderer3D;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class StackedVerticalBarRenderer3D
extends VerticalBarRenderer3D {
    public StackedVerticalBarRenderer3D(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public int getRangeType() {
        return 1;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getColumnCount();
            double d = 0.0;
            if (n > 1) {
                d = categoryAxis.getCategoryMargin();
            }
            double d2 = rectangle2D.getWidth() * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d);
            if (n > 0) {
                this.setBarWidth(d2 / (double)n);
            } else {
                this.setBarWidth(d2);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        double d;
        Number number;
        Paint paint = this.getItemPaint(n, n2, n3);
        Paint paint2 = this.getItemOutlinePaint(n, n2, n3);
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        double d2 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), double_);
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            number = categoryDataset.getValue(n4, n3);
            if (number != null) {
                d = number.doubleValue();
                if (d > 0.0) {
                    d3 += d;
                } else {
                    d4 += d;
                }
            }
            ++n4;
        }
        number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            EntityCollection entityCollection;
            double d5;
            double d6;
            d = number.doubleValue();
            if (d > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d3, double_);
                d5 = valueAxis.translateValueToJava2D(d3 + d, double_);
            } else {
                d6 = valueAxis.translateValueToJava2D(d4, double_);
                d5 = valueAxis.translateValueToJava2D(d4 + d, double_);
            }
            double d7 = Math.max(d6, d5);
            double d8 = Math.min(d6, d5);
            double d9 = d2 + this.getBarWidth();
            double d10 = d2 + this.getXOffset();
            double d11 = d9 + this.getXOffset();
            double d12 = d7 - this.getYOffset();
            double d13 = d8 - this.getYOffset();
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d2, d8, d9 - d2, d7 - d8);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            double d14 = this.getXOffset();
            double d15 = this.getYOffset();
            VerticalAxis verticalAxis = (VerticalAxis)((Object)categoryPlot.getRangeAxis());
            if (d7 - d8 != 0.0 && verticalAxis instanceof VerticalNumberAxis3D) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d9, (float)d7);
                generalPath.lineTo((float)d9, (float)d8);
                generalPath.lineTo((float)d11, (float)d13);
                generalPath.lineTo((float)d11, (float)d12);
                generalPath.closePath();
                if (paint instanceof Color) {
                    graphics2D.setPaint(((Color)paint).darker());
                }
                graphics2D.fill(generalPath);
                if (d > 0.0) {
                    generalPath2 = new GeneralPath();
                    generalPath2.moveTo((float)d2, (float)d8);
                    generalPath2.lineTo((float)d9, (float)d8);
                    generalPath2.lineTo((float)d11, (float)d13);
                    generalPath2.lineTo((float)d10, (float)d13);
                    generalPath2.closePath();
                    if (paint instanceof Color) {
                        graphics2D.setPaint((Color)paint);
                    }
                    graphics2D.fill(generalPath2);
                }
            }
            if (d9 - d2 > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = "";
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_2, string, string2, n2, categoryDataset.getColumnKey(n3), n3);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }
}

