/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.HorizontalBarRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;

public class StackedHorizontalBarRenderer
extends HorizontalBarRenderer {
    public StackedHorizontalBarRenderer() {
        this(null, null);
    }

    public StackedHorizontalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    public StackedHorizontalBarRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    public StackedHorizontalBarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public int getRangeType() {
        return 1;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        CategoryAxis categoryAxis = categoryPlot.getDomainAxis();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            int n = categoryDataset.getColumnCount();
            double d = 0.0;
            if (n > 1) {
                d = categoryAxis.getCategoryMargin();
            }
            double d2 = rectangle2D.getHeight() * (1.0 - categoryAxis.getLowerMargin() - categoryAxis.getUpperMargin() - d);
            if (n > 0) {
                this.setBarWidth(d2 / (double)n);
            } else {
                this.setBarWidth(d2);
            }
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        double d;
        Number number;
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n2) {
            number = categoryDataset.getValue(n4, n3);
            if (number != null) {
                d = number.doubleValue();
                if (d > 0.0) {
                    d2 += d;
                } else {
                    d3 += d;
                }
            }
            ++n4;
        }
        number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            EntityCollection entityCollection;
            double d4;
            double d5;
            double d6;
            d = number.doubleValue();
            if (d > 0.0) {
                d6 = valueAxis.translateValueToJava2D(d2, rectangle2D);
                d5 = valueAxis.translateValueToJava2D(d2 + d, rectangle2D);
                d4 = Math.min(d6, d5);
            } else {
                d6 = valueAxis.translateValueToJava2D(d3, rectangle2D);
                d5 = valueAxis.translateValueToJava2D(d3 + d, rectangle2D);
                d4 = Math.min(d6, d5);
            }
            double d7 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), rectangle2D);
            double d8 = Math.abs(d5 - d6);
            double d9 = this.getBarWidth();
            Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d7, d8, d9);
            Paint paint = this.getItemPaint(n, n2, n3);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_);
            }
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = "";
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, n2, categoryDataset.getColumnKey(n3), n3);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }
}

