/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.entity.XYItemEntity;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.chart.renderer.StandardXYItemRenderer;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.chart.urls.XYURLGenerator;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class ReverseXYItemRenderer
extends StandardXYItemRenderer {
    private Line2D line = new Line2D.Double(0.0, 0.0, 0.0, 0.0);

    public ReverseXYItemRenderer() {
        this(2, new StandardXYToolTipGenerator());
    }

    public ReverseXYItemRenderer(int n) {
        this(n, new StandardXYToolTipGenerator());
    }

    public ReverseXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator) {
        this(n, xYToolTipGenerator, null);
    }

    public ReverseXYItemRenderer(int n, XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        super(n, xYToolTipGenerator, xYURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, int n3, CrosshairInfo crosshairInfo) {
        Object object = null;
        EntityCollection entityCollection = null;
        if (chartRenderingInfo != null) {
            entityCollection = chartRenderingInfo.getEntityCollection();
        }
        Paint paint = this.getItemPaint(n, n2, n3);
        Stroke stroke = this.getItemStroke(n, n2, n3);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        Number number = xYDataset.getYValue(n2, n3);
        Number number2 = xYDataset.getXValue(n2, n3);
        if (number2 != null) {
            Object object2;
            Object object3;
            double d;
            double d2 = number.doubleValue();
            double d3 = number2.doubleValue();
            double d4 = valueAxis.translateValueToJava2D(d2, rectangle2D);
            Paint paint2 = this.getPaint(xYPlot, n2, n3, d4, d = valueAxis2.translateValueToJava2D(d3, rectangle2D));
            if (paint2 != null) {
                graphics2D.setPaint(paint2);
            }
            if (this.getPlotLines() && n3 > 0) {
                object3 = xYDataset.getYValue(n2, n3 - 1);
                object2 = xYDataset.getXValue(n2, n3 - 1);
                if (object2 != null) {
                    double d5 = ((Number)object3).doubleValue();
                    double d6 = ((Number)object2).doubleValue();
                    boolean bl = true;
                    if (this.getPlotDiscontinuous()) {
                        int n4 = xYDataset.getItemCount(n2);
                        double d7 = xYDataset.getXValue(n2, 0).doubleValue();
                        double d8 = xYDataset.getXValue(n2, n4 - 1).doubleValue();
                        boolean bl2 = bl = d2 - d5 <= (d8 - d7) / (double)n4 * this.getGapThreshold();
                    }
                    if (bl) {
                        double d9 = valueAxis.translateValueToJava2D(d5, rectangle2D);
                        double d10 = valueAxis2.translateValueToJava2D(d6, rectangle2D);
                        this.line.setLine(d9, d10, d4, d);
                        if (this.line.intersects(rectangle2D)) {
                            graphics2D.draw(this.line);
                        }
                    }
                }
            }
            if (this.getPlotShapes()) {
                object3 = this.getItemShape(n, n2, n3);
                if (object3.intersects(rectangle2D)) {
                    if (this.isShapeFilled(xYPlot, n2, n3, d4, d)) {
                        graphics2D.fill((Shape)object3);
                    } else {
                        graphics2D.draw((Shape)object3);
                    }
                }
                object = object3;
            }
            if (this.getPlotImages() && (object3 = this.getImage(xYPlot, n2, n3, d4, d)) != null) {
                object2 = this.getImageHotspot(xYPlot, n2, n3, d4, d, (Image)object3);
                graphics2D.drawImage((Image)object3, (int)(d4 - ((Point)object2).getX()), (int)(d - ((Point)object2).getY()), null);
            }
            if (entityCollection != null) {
                if (object == null) {
                    object = new Rectangle2D.Double(d4 - 2.0, d - 2.0, 4.0, 4.0);
                }
                object3 = "";
                if (this.getToolTipGenerator() != null) {
                    object3 = this.getToolTipGenerator().generateToolTip(xYDataset, n2, n3);
                }
                object2 = null;
                if (this.getURLGenerator() != null) {
                    object2 = this.getURLGenerator().generateURL(xYDataset, n2, n3);
                }
                XYItemEntity xYItemEntity = new XYItemEntity((Shape)object, (String)object3, (String)object2, n2, n3);
                entityCollection.addEntity(xYItemEntity);
            }
            if (xYPlot.isDomainCrosshairLockedOnData()) {
                if (xYPlot.isRangeCrosshairLockedOnData()) {
                    crosshairInfo.updateCrosshairPoint(d2, d3);
                } else {
                    crosshairInfo.updateCrosshairX(d2);
                }
            } else if (xYPlot.isRangeCrosshairLockedOnData()) {
                crosshairInfo.updateCrosshairY(d3);
            }
        }
    }
}

