/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.AbstractCategoryItemRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;

public class LineAndShapeRenderer
extends AbstractCategoryItemRenderer {
    public static final int SHAPES = 1;
    public static final int LINES = 2;
    public static final int SHAPES_AND_LINES = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    private boolean drawShapes;
    private boolean drawLines;
    private double shapeScale = 6.0;
    private int labelPosition;

    public LineAndShapeRenderer() {
        this(3, 1);
    }

    public LineAndShapeRenderer(int n) {
        this(n, 1);
    }

    public LineAndShapeRenderer(int n, int n2) {
        this(n, n2, null, null);
    }

    public LineAndShapeRenderer(int n, int n2, CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
        if (n == 1) {
            this.drawShapes = true;
        }
        if (n == 2) {
            this.drawLines = true;
        }
        if (n == 3) {
            this.drawShapes = true;
            this.drawLines = true;
        }
        this.labelPosition = n2;
    }

    public boolean isDrawShapes() {
        return this.drawShapes;
    }

    public void setDrawShapes(boolean bl) {
        if (bl != this.drawShapes) {
            this.drawShapes = bl;
            this.firePropertyChanged("Shapes", new Boolean(!bl), new Boolean(bl));
        }
    }

    public boolean isDrawLines() {
        return this.drawLines;
    }

    public void setDrawLines(boolean bl) {
        if (bl != this.drawLines) {
            this.drawLines = bl;
            this.firePropertyChanged("Lines", new Boolean(!bl), new Boolean(bl));
        }
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            Object object;
            Object object2;
            double d = categoryAxis.getCategoryMiddle(n3, this.getColumnCount(), rectangle2D);
            double d2 = valueAxis.translateValueToJava2D(number.doubleValue(), rectangle2D);
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.setStroke(this.getItemStroke(n, n2, n3));
            Shape shape = this.getItemShape(n, n2, n3);
            shape = this.createTransformedShape(shape, d, d2);
            if (this.drawShapes) {
                graphics2D.fill(shape);
            }
            if (this.drawLines && n3 != 0 && (object2 = categoryDataset.getValue(n2, n3 - 1)) != null) {
                double d3 = ((Number)object2).doubleValue();
                double d4 = categoryAxis.getCategoryMiddle(n3 - 1, this.getColumnCount(), rectangle2D);
                double d5 = valueAxis.translateValueToJava2D(d3, rectangle2D);
                graphics2D.setPaint(this.getItemPaint(n, n2, n3));
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                Line2D.Double double_ = new Line2D.Double(d4, d5, d, d2);
                graphics2D.draw(double_);
            }
            if (categoryPlot.getValueLabelsVisible()) {
                object2 = categoryPlot.getValueLabelFormatter();
                Font font = categoryPlot.getValueLabelFont();
                graphics2D.setFont(font);
                object = categoryPlot.getValueLabelPaint();
                graphics2D.setPaint((Paint)object);
                boolean bl = categoryPlot.getVerticalValueLabels();
                String string = ((Format)object2).format(number);
                this.drawLabel(graphics2D, string, d, d2, font, bl);
            }
            if (this.getInfo() != null && (object2 = this.getInfo().getEntityCollection()) != null && shape != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                object = null;
                if (this.getURLGenerator() != null) {
                    object = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(shape, string, (String)object, n2, categoryDataset.getColumnKey(n3), n3);
                object2.addEntity(categoryItemEntity);
            }
        }
    }

    private void drawLabel(Graphics2D graphics2D, String string, double d, double d2, Font font, boolean bl) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        float f = lineMetrics.getLeading();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        int n = this.labelPosition;
        if (bl) {
            float f2;
            float f3;
            if (n == 1) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 - this.shapeScale);
            } else if (n == 2) {
                f3 = (float)(d + d4 / 2.0 - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + this.shapeScale + d3);
            } else if (n == 3) {
                f3 = (float)(d - this.shapeScale / 2.0 - (double)f - (double)lineMetrics.getDescent());
                f2 = (float)(d2 + d3 / 2.0);
            } else {
                f3 = (float)(d + this.shapeScale / 2.0 + (double)f + (double)lineMetrics.getAscent());
                f2 = (float)(d2 + d3 / 2.0);
            }
            RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)f3, (float)f2, (double)-1.5707963267948966);
        } else {
            float f4;
            float f5;
            if (n == 1) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 - this.shapeScale / 2.0 - (double)lineMetrics.getDescent() - (double)f);
            } else if (n == 2) {
                f5 = (float)(d - d3 / 2.0);
                f4 = (float)(d2 + this.shapeScale / 2.0 + (double)lineMetrics.getAscent() + (double)f);
            } else if (n == 3) {
                f5 = (float)(d - this.shapeScale - d3);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            } else {
                f5 = (float)(d + this.shapeScale);
                f4 = (float)(d2 + d4 / 2.0 - (double)lineMetrics.getDescent());
            }
            graphics2D.drawString(string, f5, f4);
        }
    }
}

