/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.Effect3D;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.HorizontalNumberAxis3D;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.ChartEntity;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.renderer.HorizontalBarRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class HorizontalBarRenderer3D
extends HorizontalBarRenderer
implements Effect3D {
    public static final double DEFAULT_X_OFFSET = 10.0;
    public static final double DEFAULT_Y_OFFSET = 10.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset;
    private double yOffset;
    private int valuesGap = 2;
    private Area hiddenClip;
    private Paint wallPaint;

    public HorizontalBarRenderer3D() {
        this(10.0, 10.0);
    }

    public HorizontalBarRenderer3D(double d, double d2) {
        this(d, d2, null, null);
    }

    public HorizontalBarRenderer3D(double d, double d2, CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
        this.xOffset = d;
        this.yOffset = d2;
        this.wallPaint = DEFAULT_WALL_PAINT;
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Paint paint = categoryPlot.getBackgroundPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(f, f5);
        generalPath2.lineTo(f, f8);
        generalPath2.lineTo(f2, f7);
        generalPath2.lineTo(f2, f6);
        generalPath2.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(f, f5);
        generalPath3.lineTo(f2, f6);
        generalPath3.lineTo(f3, f6);
        generalPath3.lineTo(f4, f5);
        generalPath3.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath3);
        graphics2D.setPaint(Color.lightGray);
        Line2D.Double double_ = new Line2D.Double(f, f5, f2, f6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f2, f7);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f3, f6);
        graphics2D.draw(double_);
        Image image = categoryPlot.getBackgroundImage();
        if (image != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, categoryPlot.getBackgroundAlpha()));
            graphics2D.drawImage(image, (int)f2, (int)f7, (int)(f3 - f2 + 1.0f), (int)(f6 - f7 + 1.0f), null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Stroke stroke = categoryPlot.getOutlineStroke();
        Paint paint = categoryPlot.getOutlinePaint();
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(generalPath);
        }
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        double d2 = d;
        double d3 = d - this.getYOffset();
        double d4 = rectangle2D.getMinX();
        double d5 = d4 + this.getXOffset();
        double d6 = rectangle2D.getMaxY();
        Line2D.Double double_ = new Line2D.Double(d4, d2, d5, d3);
        Line2D.Double double_2 = new Line2D.Double(d5, d3, d6, d3);
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        double d2 = valueAxis.translateValueToJava2D(d, double_);
        double d3 = d2 + this.getXOffset();
        double d4 = rectangle2D.getMaxY();
        double d5 = d4 - this.getYOffset();
        double d6 = rectangle2D.getMinY();
        Line2D.Double double_2 = new Line2D.Double(d2, d4, d3, d5);
        Line2D.Double double_3 = new Line2D.Double(d3, d5, d3, d6);
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        float f = (float)valueAxis.translateValueToJava2D(marker.getValue(), double_);
        float f2 = (float)double_.getMaxY();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f2);
        generalPath.lineTo((float)((double)f + this.xOffset), f2 - (float)this.yOffset);
        generalPath.lineTo((float)((double)f + this.xOffset), (float)(double_.getMinY() - this.yOffset));
        generalPath.lineTo(f, (float)double_.getMinY());
        generalPath.closePath();
        graphics2D.setPaint(marker.getPaint());
        graphics2D.fill(generalPath);
        graphics2D.setPaint(marker.getOutlinePaint());
        graphics2D.draw(generalPath);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number;
        if (n2 == 0 && n3 == 0) {
            this.hiddenClip = new Area(graphics2D.getClip());
        }
        if ((number = categoryDataset.getValue(n2, n3)) != null) {
            Object object;
            String string;
            Object object2;
            Object object3;
            double d;
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
            double d2 = number.doubleValue();
            double d3 = 0.0;
            double d4 = this.getLowerClip();
            double d5 = this.getUpperClip();
            if (d5 <= 0.0) {
                if (d2 >= d5) {
                    return;
                }
                d3 = d5;
                if (d2 <= d4) {
                    d2 = d4;
                }
            } else if (d4 <= 0.0) {
                if (d2 >= d5) {
                    d2 = d5;
                } else if (d2 <= d4) {
                    d2 = d4;
                }
            } else {
                if (d2 <= d4) {
                    return;
                }
                d3 = d4;
                if (d2 >= d5) {
                    d2 = d5;
                }
            }
            double d6 = valueAxis.translateValueToJava2D(d3, double_);
            double d7 = valueAxis.translateValueToJava2D(d2, double_);
            double d8 = Math.min(d6, d7);
            double d9 = Math.max(d6, d7);
            double d10 = d8 + this.xOffset;
            double d11 = d9 + this.xOffset;
            double d12 = categoryAxis.getCategoryStart(n3, this.getColumnCount(), double_);
            int n4 = this.getRowCount();
            int n5 = this.getColumnCount();
            if (n4 > 1) {
                d = rectangle2D.getHeight() * this.getItemMargin() / (double)(n5 * (n4 - 1));
                d12 += (double)n2 * (this.getBarWidth() + d);
            } else {
                d12 += (double)n2 * this.getBarWidth();
            }
            d = d12 + this.getBarWidth();
            double d13 = d - this.yOffset;
            double d14 = d12 - this.yOffset;
            if ((double)categoryPlot.getForegroundAlpha() == 1.0) {
                graphics2D.setClip(this.hiddenClip);
            }
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d8, d12, d9 - d8, d - d12);
            Paint paint = null;
            paint = !this.getUseCategoriesPaint() ? this.getItemPaint(n, n2, n3) : this.getCategoryPaint(n3);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_2);
            this.hiddenClip.subtract(new Area(double_2));
            GeneralPath generalPath = null;
            GeneralPath generalPath2 = null;
            double d15 = 0.0;
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)categoryPlot.getRangeAxis());
            if (d9 - d8 != 0.0 && horizontalAxis instanceof HorizontalNumberAxis3D) {
                generalPath = new GeneralPath();
                generalPath.moveTo((float)d9, (float)d12);
                generalPath.lineTo((float)d9, (float)d);
                generalPath.lineTo((float)d11, (float)d13);
                generalPath.lineTo((float)d11, (float)d14);
                generalPath.closePath();
                graphics2D.fill(generalPath);
                this.hiddenClip.subtract(new Area(generalPath));
                generalPath2 = new GeneralPath();
                generalPath2.moveTo((float)d8, (float)d12);
                generalPath2.lineTo((float)d10, (float)d14);
                generalPath2.lineTo((float)d11, (float)d14);
                generalPath2.lineTo((float)d9, (float)d12);
                generalPath2.closePath();
                graphics2D.fill(generalPath2);
                this.hiddenClip.subtract(new Area(generalPath2));
            }
            if (this.getBarWidth() > 3.0) {
                graphics2D.setStroke(this.getItemStroke(n, n2, n3));
                graphics2D.setPaint(this.getItemOutlinePaint(n, n2, n3));
                graphics2D.draw(double_2);
                if (generalPath != null) {
                    graphics2D.draw(generalPath);
                }
                if (generalPath2 != null) {
                    graphics2D.draw(generalPath2);
                }
                if (categoryPlot.getValueLabelsVisible()) {
                    object3 = categoryPlot.getValueLabelFont();
                    graphics2D.setFont((Font)object3);
                    object2 = categoryPlot.getValueLabelPaint();
                    graphics2D.setPaint((Paint)object2);
                    string = categoryPlot.getValueLabelFormatter().format(number.doubleValue());
                    object = categoryPlot.getValueLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
                    double d16 = (d - d12 + (double)((LineMetrics)object).getAscent() - (double)((LineMetrics)object).getDescent()) / 2.0;
                    double d17 = ((Font)object3).getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
                    double d18 = d9 - d17 - (double)this.valuesGap;
                    graphics2D.drawString(string, (int)d18, (int)(d12 + d16));
                }
            }
            if (this.getInfo() != null && (object3 = this.getInfo().getEntityCollection()) != null) {
                object2 = null;
                if (this.getToolTipGenerator() != null) {
                    object2 = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                string = null;
                if (this.getURLGenerator() != null) {
                    string = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                object = new CategoryItemEntity(double_2, (String)object2, string, n2, categoryDataset.getColumnKey(n3), n3);
                object3.addEntity((ChartEntity)object);
            }
        }
    }
}

