/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartColor;
import com.jrefinery.chart.renderer.DrawingSupplier;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class DefaultDrawingSupplier
implements DrawingSupplier {
    public static final Paint[] DEFAULT_PAINT_SEQUENCE = ChartColor.createDefaultPaintArray();
    public static final Paint[] DEFAULT_OUTLINE_PAINT_SEQUENCE = new Paint[]{Color.lightGray};
    public static final Stroke[] DEFAULT_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Stroke[] DEFAULT_OUTLINE_STROKE_SEQUENCE = new Stroke[]{new BasicStroke(1.0f, 2, 2)};
    public static final Shape[] DEFAULT_SHAPE_SEQUENCE = DefaultDrawingSupplier.createStandardSeriesShapes();
    private Paint[] paintSequence;
    private int paintIndex;
    private Paint[] outlinePaintSequence;
    private int outlinePaintIndex;
    private Stroke[] strokeSequence;
    private int strokeIndex;
    private Stroke[] outlineStrokeSequence;
    private int outlineStrokeIndex;
    private Shape[] shapeSequence;
    private int shapeIndex;

    public DefaultDrawingSupplier() {
        this(DEFAULT_PAINT_SEQUENCE, DEFAULT_OUTLINE_PAINT_SEQUENCE, DEFAULT_STROKE_SEQUENCE, DEFAULT_OUTLINE_STROKE_SEQUENCE, DEFAULT_SHAPE_SEQUENCE);
    }

    public DefaultDrawingSupplier(Paint[] paintArray, Paint[] paintArray2, Stroke[] strokeArray, Stroke[] strokeArray2, Shape[] shapeArray) {
        this.paintSequence = paintArray;
        this.outlinePaintSequence = paintArray2;
        this.strokeSequence = strokeArray;
        this.outlineStrokeSequence = strokeArray2;
        this.shapeSequence = shapeArray;
    }

    public Paint getNextPaint() {
        Paint paint = this.paintSequence[this.paintIndex % this.paintSequence.length];
        ++this.paintIndex;
        return paint;
    }

    public Paint getNextOutlinePaint() {
        Paint paint = this.outlinePaintSequence[this.outlinePaintIndex % this.outlinePaintSequence.length];
        ++this.outlinePaintIndex;
        return paint;
    }

    public Stroke getNextStroke() {
        Stroke stroke = this.strokeSequence[this.strokeIndex % this.strokeSequence.length];
        ++this.strokeIndex;
        return stroke;
    }

    public Stroke getNextOutlineStroke() {
        Stroke stroke = this.outlineStrokeSequence[this.outlineStrokeIndex % this.outlineStrokeSequence.length];
        ++this.outlineStrokeIndex;
        return stroke;
    }

    public Shape getNextShape() {
        Shape shape = this.shapeSequence[this.shapeIndex % this.shapeSequence.length];
        ++this.shapeIndex;
        return shape;
    }

    public static Shape[] createStandardSeriesShapes() {
        Shape[] shapeArray = new Shape[10];
        double d = 6.0;
        double d2 = d / 2.0;
        int[] nArray = null;
        int[] nArray2 = null;
        shapeArray[0] = new Rectangle2D.Double(-d2, -d2, d, d);
        shapeArray[1] = new Ellipse2D.Double(-d2, -d2, d, d);
        nArray = DefaultDrawingSupplier.intArray(0.0, d2, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, d2, d2);
        shapeArray[2] = new Polygon(nArray, nArray2, 3);
        nArray = DefaultDrawingSupplier.intArray(0.0, d2, 0.0, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, 0.0, d2, 0.0);
        shapeArray[3] = new Polygon(nArray, nArray2, 4);
        shapeArray[4] = new Rectangle2D.Double(-d2, -d2 / 2.0, d, d / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, 0.0);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, -d2, d2);
        shapeArray[5] = new Polygon(nArray, nArray2, 3);
        shapeArray[6] = new Ellipse2D.Double(-d2, -d2 / 2.0, d, d / 2.0);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, -d2);
        nArray2 = DefaultDrawingSupplier.intArray(-d2, 0.0, d2);
        shapeArray[7] = new Polygon(nArray, nArray2, 3);
        shapeArray[8] = new Rectangle2D.Double(-d2 / 2.0, -d2, d / 2.0, d);
        nArray = DefaultDrawingSupplier.intArray(-d2, d2, d2);
        nArray2 = DefaultDrawingSupplier.intArray(0.0, -d2, d2);
        shapeArray[9] = new Polygon(nArray, nArray2, 3);
        return shapeArray;
    }

    private static int[] intArray(double d, double d2, double d3) {
        return new int[]{(int)d, (int)d2, (int)d3};
    }

    private static int[] intArray(double d, double d2, double d3, double d4) {
        return new int[]{(int)d, (int)d2, (int)d3, (int)d4};
    }
}

