/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.AbstractCategoryItemRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public abstract class BarRenderer
extends AbstractCategoryItemRenderer {
    public static final double DEFAULT_ITEM_MARGIN = 0.2;
    public static final double BAR_OUTLINE_WIDTH_THRESHOLD = 3.0;
    private double itemMargin = 0.2;
    private double barWidth;
    private double zeroInJava2D;
    private double upperClip;
    private double lowerClip;

    protected BarRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public double getItemMargin() {
        return this.itemMargin;
    }

    public void setItemMargin(double d) {
        this.itemMargin = d;
        this.firePropertyChanged("ItemMargin", null, null);
    }

    public double getBarWidth() {
        return this.barWidth;
    }

    protected void setBarWidth(double d) {
        this.barWidth = d;
    }

    public double getZeroInJava2D() {
        return this.lowerClip;
    }

    public double getLowerClip() {
        return this.lowerClip;
    }

    public double getUpperClip() {
        return this.upperClip;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        super.initialise(graphics2D, rectangle2D, categoryPlot, chartRenderingInfo);
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        this.lowerClip = valueAxis.getRange().getLowerBound();
        this.upperClip = valueAxis.getRange().getUpperBound();
    }
}

