/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.entity.CategoryItemEntity;
import com.jrefinery.chart.entity.EntityCollection;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.renderer.AbstractCategoryItemRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;

public class AreaRenderer
extends AbstractCategoryItemRenderer {
    public AreaRenderer() {
        this(null, null);
    }

    public AreaRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        super(categoryToolTipGenerator, categoryURLGenerator);
    }

    public void drawItem(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n2, n3);
        if (number != null) {
            EntityCollection entityCollection;
            Number number2;
            Number number3;
            float f = (float)categoryAxis.getCategoryStart(n3, categoryDataset.getColumnCount(), rectangle2D);
            float f2 = (float)categoryAxis.getCategoryMiddle(n3, categoryDataset.getColumnCount(), rectangle2D);
            float f3 = (float)categoryAxis.getCategoryEnd(n3, categoryDataset.getColumnCount(), rectangle2D);
            f = Math.round(f);
            f2 = Math.round(f2);
            f3 = Math.round(f3);
            double d = number.doubleValue();
            double d2 = 0.0;
            if (n3 > 0 && (number3 = categoryDataset.getValue(n2, n3 - 1)) != null) {
                d2 = (number3.doubleValue() + d) / 2.0;
            }
            double d3 = 0.0;
            if (n3 < categoryDataset.getColumnCount() - 1 && (number2 = categoryDataset.getValue(n2, n3 + 1)) != null) {
                d3 = (number2.doubleValue() + d) / 2.0;
            }
            float f4 = (float)valueAxis.translateValueToJava2D(d2, rectangle2D);
            float f5 = (float)valueAxis.translateValueToJava2D(d, rectangle2D);
            float f6 = (float)valueAxis.translateValueToJava2D(d3, rectangle2D);
            float f7 = (float)valueAxis.translateValueToJava2D(0.0, rectangle2D);
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.setStroke(this.getSeriesStroke(n, n2));
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(f, f7);
            generalPath.lineTo(f, f4);
            generalPath.lineTo(f2, f5);
            generalPath.lineTo(f3, f6);
            generalPath.lineTo(f3, f7);
            generalPath.closePath();
            graphics2D.setPaint(this.getItemPaint(n, n2, n3));
            graphics2D.fill(generalPath);
            if (this.getInfo() != null && (entityCollection = this.getInfo().getEntityCollection()) != null) {
                String string = null;
                if (this.getToolTipGenerator() != null) {
                    string = this.getToolTipGenerator().generateToolTip(categoryDataset, n2, n3);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(categoryDataset, n2, n3);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(generalPath, string, string2, n2, categoryDataset.getColumnKey(n3), n3);
                entityCollection.addEntity(categoryItemEntity);
            }
        }
    }
}

