/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.chart.renderer.AbstractRenderer;
import com.jrefinery.chart.renderer.XYItemRenderer;
import com.jrefinery.chart.tooltips.XYToolTipGenerator;
import com.jrefinery.chart.urls.XYURLGenerator;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractXYItemRenderer
extends AbstractRenderer
implements XYItemRenderer {
    private XYToolTipGenerator toolTipGenerator;
    private XYURLGenerator urlGenerator;

    protected AbstractXYItemRenderer() {
        this(null, null);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator) {
        this(xYToolTipGenerator, null);
    }

    protected AbstractXYItemRenderer(XYURLGenerator xYURLGenerator) {
        this(null, xYURLGenerator);
    }

    protected AbstractXYItemRenderer(XYToolTipGenerator xYToolTipGenerator, XYURLGenerator xYURLGenerator) {
        this.toolTipGenerator = xYToolTipGenerator;
        this.urlGenerator = xYURLGenerator;
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, ChartRenderingInfo chartRenderingInfo) {
        this.setInfo(chartRenderingInfo);
    }

    public XYToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(XYToolTipGenerator xYToolTipGenerator) {
        XYToolTipGenerator xYToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = xYToolTipGenerator;
        this.firePropertyChanged("renderer.ToolTipGenerator", xYToolTipGenerator2, xYToolTipGenerator);
    }

    public XYURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(XYURLGenerator xYURLGenerator) {
        XYURLGenerator xYURLGenerator2 = this.urlGenerator;
        this.urlGenerator = xYURLGenerator;
        this.firePropertyChanged("renderer.URLGenerator", xYURLGenerator2, xYURLGenerator);
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = (XYPlot)this.getPlot();
        if (xYPlot != null && (xYDataset = n == 0 ? (XYDataset)xYPlot.getDataset() : (XYDataset)xYPlot.getSecondaryDataset()) != null) {
            String string;
            String string2 = string = xYDataset.getSeriesName(n2);
            Shape shape = this.getSeriesShape(n, n2);
            Paint paint = this.getSeriesPaint(n, n2);
            Paint paint2 = this.getSeriesOutlinePaint(n, n2);
            Stroke stroke = this.getSeriesStroke(n, n2);
            legendItem = new LegendItem(string, string2, shape, paint, paint2, stroke);
        }
        return legendItem;
    }

    public void drawDomainGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = xYPlot.getDomainGridlinePaint();
        Stroke stroke = xYPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeGridLine(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = xYPlot.getRangeGridlinePaint();
        Stroke stroke = xYPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawDomainMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, XYPlot xYPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }
}

