/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.renderer.DefaultDrawingSupplier;
import com.jrefinery.chart.renderer.DrawingSupplier;
import com.jrefinery.chart.renderer.PaintTable;
import com.jrefinery.chart.renderer.Renderer;
import com.jrefinery.chart.renderer.ShapeTable;
import com.jrefinery.chart.renderer.StrokeTable;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class AbstractRenderer
implements Renderer {
    public static final Paint DEFAULT_PAINT = Color.blue;
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Stroke DEFAULT_STROKE = new BasicStroke(1.0f);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke(1.0f);
    public static final Shape DEFAULT_SHAPE = new Rectangle2D.Double(-3.0, -3.0, 6.0, 6.0);
    private Plot plot = null;
    private DrawingSupplier supplier = new DefaultDrawingSupplier();
    private Paint defaultPaint;
    private boolean paintTableActive = true;
    private PaintTable paintTable = new PaintTable();
    private Paint defaultOutlinePaint;
    private boolean outlinePaintTableActive = false;
    private PaintTable outlinePaintTable = null;
    private Stroke defaultStroke;
    private boolean strokeTableActive = false;
    private StrokeTable strokeTable = null;
    private Stroke defaultOutlineStroke;
    private boolean outlineStrokeTableActive = false;
    private StrokeTable outlineStrokeTable = null;
    private Shape defaultShape;
    private boolean shapeTableActive = true;
    private ShapeTable shapeTable;
    private ChartRenderingInfo info = null;
    private PropertyChangeSupport listeners;

    public AbstractRenderer() {
        this.defaultPaint = DEFAULT_PAINT;
        this.defaultOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.defaultStroke = DEFAULT_STROKE;
        this.defaultOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.shapeTable = new ShapeTable();
        this.defaultShape = DEFAULT_SHAPE;
        this.listeners = new PropertyChangeSupport(this);
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) {
        this.plot = plot;
    }

    public ChartRenderingInfo getInfo() {
        return this.info;
    }

    public void setInfo(ChartRenderingInfo chartRenderingInfo) {
        this.info = chartRenderingInfo;
    }

    public DrawingSupplier getDrawingSupplier() {
        return this.supplier;
    }

    public void setDrawingSupplier(DrawingSupplier drawingSupplier) {
        this.supplier = drawingSupplier;
    }

    public boolean isPaintTableActive() {
        return this.paintTableActive;
    }

    public void setPaintTableActive(boolean bl) {
        this.paintTableActive = bl;
        if (bl && this.paintTable == null) {
            this.paintTable = new PaintTable();
        }
    }

    public Paint getItemPaint(int n, int n2, int n3) {
        return this.getSeriesPaint(n, n2);
    }

    public Paint getSeriesPaint(int n, int n2) {
        Paint paint = this.defaultPaint;
        if (this.paintTableActive && (paint = this.paintTable.getPaint(n, n2)) == null) {
            paint = this.supplier.getNextPaint();
            this.paintTable.setPaint(n, n2, paint);
        }
        return paint;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.setSeriesPaint(0, n, paint);
    }

    public void setSeriesPaint(int n, int n2, Paint paint) {
        this.setPaintTableActive(true);
        this.paintTable.setPaint(n, n2, paint);
    }

    public Paint getDefaultPaint() {
        return this.defaultPaint;
    }

    public void setDefaultPaint(Paint paint) {
        this.defaultPaint = paint;
    }

    public boolean isOutlinePaintTableActive() {
        return this.outlinePaintTableActive;
    }

    public void setOutlinePaintTableActive(boolean bl) {
        this.outlinePaintTableActive = bl;
        if (bl && this.outlinePaintTable == null) {
            this.outlinePaintTable = new PaintTable();
        }
    }

    public Paint getItemOutlinePaint(int n, int n2, int n3) {
        return this.getSeriesOutlinePaint(n, n2);
    }

    public Paint getSeriesOutlinePaint(int n, int n2) {
        Paint paint = this.defaultOutlinePaint;
        if (this.outlinePaintTable != null) {
            paint = this.outlinePaintTable.getPaint(n, n2);
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.setSeriesOutlinePaint(0, n, paint);
    }

    public void setSeriesOutlinePaint(int n, int n2, Paint paint) {
        this.setOutlinePaintTableActive(true);
        this.outlinePaintTable.setPaint(n, n2, paint);
    }

    public Paint getDefaultOutlinePaint() {
        return this.defaultOutlinePaint;
    }

    public void setDefaultOutlinePaint(Paint paint) {
        this.defaultOutlinePaint = paint;
    }

    public boolean isStrokeTableActive() {
        return this.strokeTableActive;
    }

    public void setStrokeTableActive(boolean bl) {
        this.strokeTableActive = bl;
        if (bl && this.strokeTable == null) {
            this.strokeTable = new StrokeTable();
        }
    }

    public Stroke getItemStroke(int n, int n2, int n3) {
        return this.getSeriesStroke(n, n2);
    }

    public Stroke getSeriesStroke(int n, int n2) {
        Stroke stroke = this.defaultStroke;
        if (this.strokeTable != null) {
            stroke = this.strokeTable.getStroke(n, n2);
        }
        return stroke;
    }

    public void setSeriesStroke(int n, Stroke stroke) {
        this.setSeriesStroke(0, n, stroke);
    }

    public void setSeriesStroke(int n, int n2, Stroke stroke) {
        this.setStrokeTableActive(true);
        this.strokeTable.setStroke(n, n2, stroke);
    }

    public Stroke getDefaultStroke() {
        return this.defaultStroke;
    }

    public void setDefaultStroke(Stroke stroke) {
        this.defaultStroke = stroke;
    }

    public boolean isOutlineStrokeTableActive() {
        return this.outlineStrokeTableActive;
    }

    public void setOutlineStrokeTableActive(boolean bl) {
        this.outlineStrokeTableActive = bl;
        if (bl && this.outlineStrokeTable == null) {
            this.outlineStrokeTable = new StrokeTable();
        }
    }

    public Stroke getItemOutlineStroke(int n, int n2, int n3) {
        return this.getSeriesOutlineStroke(n, n2);
    }

    public Stroke getSeriesOutlineStroke(int n, int n2) {
        Stroke stroke = this.defaultOutlineStroke;
        if (this.outlineStrokeTable != null) {
            stroke = this.outlineStrokeTable.getStroke(n, n2);
        }
        return stroke;
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.setSeriesOutlineStroke(0, n, stroke);
    }

    public void setSeriesOutlineStroke(int n, int n2, Stroke stroke) {
        this.setOutlineStrokeTableActive(true);
        this.outlineStrokeTable.setStroke(n, n2, stroke);
    }

    public Stroke getDefaultOutlineStroke() {
        return this.defaultOutlineStroke;
    }

    public void setDefaultOutlineStroke(Stroke stroke) {
        this.defaultOutlineStroke = stroke;
    }

    protected synchronized Shape createTransformedShape(Shape shape, double d, double d2) {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToTranslation(d, d2);
        return affineTransform.createTransformedShape(shape);
    }

    public boolean isShapeTableActive() {
        return this.shapeTableActive;
    }

    public void setShapeTableActive(boolean bl) {
        this.shapeTableActive = bl;
    }

    public Shape getItemShape(int n, int n2, int n3) {
        return this.getSeriesShape(n, n2);
    }

    public Shape getSeriesShape(int n, int n2) {
        Shape shape = this.defaultShape;
        if (this.shapeTable != null) {
            shape = this.shapeTable.getShape(n, n2);
        }
        return shape;
    }

    public void setSeriesShape(int n, Shape shape) {
        this.setSeriesShape(0, n, shape);
    }

    public void setSeriesShape(int n, int n2, Shape shape) {
        this.setShapeTableActive(true);
        this.shapeTable.setShape(n, n2, shape);
    }

    public Shape getDefaultShape() {
        return this.defaultShape;
    }

    public void setDefaultShape(Shape shape) {
        this.defaultShape = shape;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    protected void firePropertyChanged(String string, Object object, Object object2) {
        this.listeners.firePropertyChange(string, object, object2);
    }
}

