/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.renderer;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.renderer.AbstractRenderer;
import com.jrefinery.chart.renderer.CategoryItemRenderer;
import com.jrefinery.chart.tooltips.CategoryToolTipGenerator;
import com.jrefinery.chart.urls.CategoryURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public abstract class AbstractCategoryItemRenderer
extends AbstractRenderer
implements CategoryItemRenderer {
    private int rowCount;
    private int columnCount;
    private Paint[] categoriesPaint = null;
    private CategoryToolTipGenerator toolTipGenerator;
    private CategoryURLGenerator urlGenerator;
    private boolean useCategoriesPaint;

    protected AbstractCategoryItemRenderer() {
        this(null, null);
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator) {
        this(categoryToolTipGenerator, null);
    }

    protected AbstractCategoryItemRenderer(CategoryURLGenerator categoryURLGenerator) {
        this(null, categoryURLGenerator);
    }

    protected AbstractCategoryItemRenderer(CategoryToolTipGenerator categoryToolTipGenerator, CategoryURLGenerator categoryURLGenerator) {
        this.toolTipGenerator = categoryToolTipGenerator;
        this.urlGenerator = categoryURLGenerator;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public boolean getUseCategoriesPaint() {
        return this.useCategoriesPaint;
    }

    public Paint[] getCategoriesPaint() {
        return this.categoriesPaint;
    }

    public void setCategoriesPaint(Paint[] paintArray) {
        Paint[] paintArray2 = this.categoriesPaint;
        this.categoriesPaint = paintArray;
        this.firePropertyChanged("renderer.CategoriesPaint", paintArray2, paintArray);
    }

    public Paint getCategoryPaint(int n) {
        Paint paint = null;
        if (this.categoriesPaint != null) {
            paint = this.categoriesPaint[n % this.categoriesPaint.length];
        }
        return paint;
    }

    public CategoryToolTipGenerator getToolTipGenerator() {
        return this.toolTipGenerator;
    }

    public void setToolTipGenerator(CategoryToolTipGenerator categoryToolTipGenerator) {
        CategoryToolTipGenerator categoryToolTipGenerator2 = this.toolTipGenerator;
        this.toolTipGenerator = categoryToolTipGenerator;
        this.firePropertyChanged("renderer.ToolTipGenerator", categoryToolTipGenerator2, categoryToolTipGenerator);
    }

    public CategoryURLGenerator getURLGenerator() {
        return this.urlGenerator;
    }

    public void setURLGenerator(CategoryURLGenerator categoryURLGenerator) {
        CategoryURLGenerator categoryURLGenerator2 = this.urlGenerator;
        this.urlGenerator = categoryURLGenerator;
        this.firePropertyChanged("renderer.URLGenerator", categoryURLGenerator2, categoryURLGenerator);
    }

    public void initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, ChartRenderingInfo chartRenderingInfo) {
        this.setPlot(categoryPlot);
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            this.rowCount = categoryDataset.getRowCount();
            this.columnCount = categoryDataset.getColumnCount();
            if (categoryDataset.getRowCount() == 1 && this.categoriesPaint != null) {
                this.useCategoriesPaint = this.categoriesPaint.length > 0;
            }
        } else {
            this.rowCount = 0;
            this.columnCount = 0;
        }
        this.setInfo(chartRenderingInfo);
    }

    public int getRangeType() {
        return 0;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawBackground(graphics2D, rectangle2D);
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        categoryPlot.drawOutline(graphics2D, rectangle2D);
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        Line2D.Double double_ = new Line2D.Double(d, rectangle2D.getMinY(), d, rectangle2D.getMaxY());
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        double d = marker.getValue();
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        double d2 = valueAxis.translateValueToJava2D(marker.getValue(), rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        Paint paint = marker.getOutlinePaint();
        Stroke stroke = marker.getOutlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
    }

    public LegendItem getLegendItem(int n, int n2) {
        String string;
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        if (categoryPlot == null) {
            return null;
        }
        CategoryDataset categoryDataset = n == 0 ? categoryPlot.getCategoryDataset() : categoryPlot.getSecondaryCategoryDataset();
        String string2 = string = categoryDataset.getRowKey(n2).toString();
        Shape shape = this.getSeriesShape(n, n2);
        Paint paint = this.getSeriesPaint(n, n2);
        Paint paint2 = this.getSeriesOutlinePaint(n, n2);
        Stroke stroke = this.getSeriesStroke(n, n2);
        return new LegendItem(string, string2, shape, paint, paint2, stroke);
    }
}

