/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.annotations.Annotation;
import com.jrefinery.chart.annotations.XYAnnotation;
import com.jrefinery.chart.axis.AxisNotCompatibleException;
import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.plot.HorizontalValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.PlotNotCompatibleException;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.chart.renderer.StandardXYItemRenderer;
import com.jrefinery.chart.renderer.XYItemRenderer;
import com.jrefinery.data.Dataset;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.Range;
import com.jrefinery.data.XYDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XYPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot,
PropertyChangeListener {
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    private ValueAxis domainAxis;
    private int domainAxisLocation;
    private ValueAxis rangeAxis;
    private int rangeAxisLocation;
    private XYItemRenderer renderer;
    private ValueAxis secondaryRangeAxis;
    private XYItemRenderer secondaryRenderer;
    private boolean domainGridlinesVisible;
    private Stroke domainGridlineStroke;
    private Paint domainGridlinePaint;
    private boolean rangeGridlinesVisible;
    private Stroke rangeGridlineStroke;
    private Paint rangeGridlinePaint;
    private boolean domainCrosshairVisible;
    private double domainCrosshairValue;
    private Stroke domainCrosshairStroke;
    private Paint domainCrosshairPaint;
    private boolean domainCrosshairLockedOnData = true;
    private boolean rangeCrosshairVisible;
    private double rangeCrosshairValue;
    private Stroke rangeCrosshairStroke;
    private Paint rangeCrosshairPaint;
    private boolean rangeCrosshairLockedOnData = true;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;
    private int weight;

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2) {
        this(xYDataset, valueAxis, valueAxis2, new StandardXYItemRenderer());
    }

    public XYPlot(XYDataset xYDataset, ValueAxis valueAxis, ValueAxis valueAxis2, XYItemRenderer xYItemRenderer) {
        super(xYDataset);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.domainAxisLocation = 1;
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
        this.rangeAxisLocation = 3;
        this.weight = 1;
        this.renderer = xYItemRenderer;
        if (xYItemRenderer != null) {
            xYItemRenderer.setPlot(this);
            xYItemRenderer.addPropertyChangeListener(this);
        }
        this.domainGridlinesVisible = true;
        this.domainGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.domainGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.rangeGridlinesVisible = true;
        this.rangeGridlineStroke = DEFAULT_GRIDLINE_STROKE;
        this.rangeGridlinePaint = DEFAULT_GRIDLINE_PAINT;
        this.domainCrosshairVisible = false;
        this.domainCrosshairValue = 0.0;
        this.domainCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.domainCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
        this.rangeCrosshairVisible = false;
        this.rangeCrosshairValue = 0.0;
        this.rangeCrosshairStroke = DEFAULT_CROSSHAIR_STROKE;
        this.rangeCrosshairPaint = DEFAULT_CROSSHAIR_PAINT;
    }

    public int getSeriesCount() {
        int n = 0;
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            n = xYDataset.getSeriesCount();
        }
        return n;
    }

    public LegendItemCollection getLegendItems() {
        int n;
        Object object;
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null && (object = this.getRenderer()) != null) {
            int n2 = xYDataset.getSeriesCount();
            n = 0;
            while (n < n2) {
                LegendItem legendItem = object.getLegendItem(0, n);
                legendItemCollection.add(legendItem);
                ++n;
            }
        }
        if ((object = this.getSecondaryXYDataset()) != null) {
            XYItemRenderer xYItemRenderer = this.getSecondaryRenderer();
            if (xYItemRenderer == null) {
                xYItemRenderer = this.getRenderer();
            }
            if (xYItemRenderer != null) {
                n = object.getSeriesCount();
                int n3 = 0;
                while (n3 < n) {
                    LegendItem legendItem = xYItemRenderer.getLegendItem(1, n3);
                    legendItemCollection.add(legendItem);
                    ++n3;
                }
            }
        }
        return legendItemCollection;
    }

    public int getWeight() {
        return this.weight;
    }

    public void setWeight(int n) {
        this.weight = n;
    }

    public XYItemRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(XYItemRenderer xYItemRenderer) {
        boolean bl = false;
        if (this.renderer != null) {
            if (!this.renderer.equals(xYItemRenderer)) {
                this.renderer.removePropertyChangeListener(this);
                this.renderer = xYItemRenderer;
                bl = true;
            }
        } else if (xYItemRenderer != null) {
            this.renderer = xYItemRenderer;
            bl = true;
        }
        if (bl) {
            this.renderer.setPlot(this);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public XYItemRenderer getSecondaryRenderer() {
        return this.secondaryRenderer;
    }

    public void setSecondaryRenderer(XYItemRenderer xYItemRenderer) {
        boolean bl = false;
        if (this.secondaryRenderer != null) {
            if (!this.secondaryRenderer.equals(xYItemRenderer)) {
                this.secondaryRenderer.removePropertyChangeListener(this);
                this.secondaryRenderer = xYItemRenderer;
                bl = true;
            }
        } else if (xYItemRenderer != null) {
            this.secondaryRenderer = xYItemRenderer;
            bl = true;
        }
        if (bl) {
            this.secondaryRenderer.setPlot(this);
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public ValueAxis getSecondaryRangeAxis() {
        return this.secondaryRangeAxis;
    }

    public void setSecondaryRangeAxis(ValueAxis valueAxis) {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("XYPlot.setSecondaryRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.secondaryRangeAxis != null) {
                this.secondaryRangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("XYPlot.setSecondaryRangeAxis(...): axis not compatible with plot.");
        }
        this.secondaryRangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public XYDataset getXYDataset() {
        return (XYDataset)this.getDataset();
    }

    public XYDataset getSecondaryXYDataset() {
        return (XYDataset)this.getSecondaryDataset();
    }

    public ValueAxis getDomainAxis() {
        Plot plot;
        ValueAxis valueAxis = this.domainAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getDomainAxis();
        }
        return valueAxis;
    }

    public void setDomainAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleDomainAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setDomainAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.domainAxis != null) {
                this.domainAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setDomainAxis(...): axis not compatible with plot.");
        }
        this.domainAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getDomainAxisLocation() {
        return this.domainAxisLocation;
    }

    public boolean isDomainGridlinesVisible() {
        return this.domainGridlinesVisible;
    }

    public void setDomainGridlinesVisible(boolean bl) {
        if (this.domainGridlinesVisible != bl) {
            this.domainGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainGridlineStroke() {
        return this.domainGridlineStroke;
    }

    public void setDomainGridlineStroke(Stroke stroke) {
        this.domainGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainGridlinePaint() {
        return this.domainGridlinePaint;
    }

    public void setDomainGridlinePaint(Paint paint) {
        this.domainGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public ValueAxis getRangeAxis() {
        Plot plot;
        ValueAxis valueAxis = this.rangeAxis;
        if (valueAxis == null && (plot = this.getParent()) instanceof XYPlot) {
            XYPlot xYPlot = (XYPlot)plot;
            valueAxis = xYPlot.getRangeAxis();
        }
        return valueAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public int getRangeAxisLocation() {
        return this.rangeAxisLocation;
    }

    public boolean isRangeGridlinesVisible() {
        return this.rangeGridlinesVisible;
    }

    public void setRangeGridlinesVisible(boolean bl) {
        if (this.rangeGridlinesVisible != bl) {
            this.rangeGridlinesVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeGridlineStroke() {
        return this.rangeGridlineStroke;
    }

    public void setRangeGridlineStroke(Stroke stroke) {
        this.rangeGridlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeGridlinePaint() {
        return this.rangeGridlinePaint;
    }

    public void setRangeGridlinePaint(Paint paint) {
        this.rangeGridlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void addDomainMarker(Marker marker) {
        if (this.domainMarkers == null) {
            this.domainMarkers = new ArrayList();
        }
        this.domainMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearDomainMarkers() {
        if (this.domainMarkers != null) {
            this.domainMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addRangeMarker(Marker marker) {
        if (this.rangeMarkers == null) {
            this.rangeMarkers = new ArrayList();
        }
        this.rangeMarkers.add(marker);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearRangeMarkers() {
        if (this.rangeMarkers != null) {
            this.rangeMarkers.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void addAnnotation(XYAnnotation xYAnnotation) {
        if (this.annotations == null) {
            this.annotations = new ArrayList();
        }
        this.annotations.add(xYAnnotation);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void clearAnnotations() {
        if (this.annotations != null) {
            this.annotations.clear();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isCompatibleDomainAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof HorizontalAxis;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Insets insets;
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D, this.domainAxisLocation);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            VerticalAxis verticalAxis = (VerticalAxis)((Object)this.rangeAxis);
            d2 = verticalAxis.reserveWidth(graphics2D, this, rectangle2D, this.getRangeAxisLocation(), d, this.getDomainAxisLocation());
        }
        double d3 = 0.0;
        int n = this.getOppositeAxisLocation(this.getRangeAxisLocation());
        VerticalAxis verticalAxis = (VerticalAxis)((Object)this.secondaryRangeAxis);
        if (verticalAxis != null) {
            d3 = verticalAxis.reserveWidth(graphics2D, this, rectangle2D, n, d, this.getDomainAxisLocation());
        }
        double d4 = this.getRectX(rectangle2D.getX(), d2, d3, this.getRangeAxisLocation());
        double d5 = this.getRectY(rectangle2D.getY(), d, 0.0, this.getDomainAxisLocation());
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, rectangle2D.getWidth() - d2 - d3, rectangle2D.getHeight() - d);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea(double_);
        }
        CrosshairInfo crosshairInfo = new CrosshairInfo();
        crosshairInfo.setCrosshairDistance(Double.POSITIVE_INFINITY);
        crosshairInfo.setAnchorX(this.getDomainAxis().getAnchorValue());
        crosshairInfo.setAnchorY(this.getRangeAxis().getAnchorValue());
        this.drawBackground(graphics2D, double_);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, rectangle2D, double_, this.domainAxisLocation);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, rectangle2D, double_, this.rangeAxisLocation);
        }
        if (this.secondaryRangeAxis != null) {
            this.secondaryRangeAxis.draw(graphics2D, rectangle2D, double_, n);
        }
        if (this.renderer != null) {
            Tick tick;
            Object object;
            Object object2;
            Iterator iterator;
            Shape shape = graphics2D.getClip();
            Composite composite = graphics2D.getComposite();
            graphics2D.clip(double_);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
            if (this.isDomainGridlinesVisible()) {
                iterator = this.getDomainGridlineStroke();
                object2 = this.getDomainGridlinePaint();
                if (iterator != null && object2 != null) {
                    object = this.getDomainAxis().getTicks().iterator();
                    while (object.hasNext()) {
                        tick = (Tick)object.next();
                        this.renderer.drawDomainGridLine(graphics2D, this, this.getDomainAxis(), double_, tick.getNumericalValue());
                    }
                }
            }
            if (this.isRangeGridlinesVisible()) {
                iterator = this.getRangeGridlineStroke();
                object2 = this.getRangeGridlinePaint();
                if (iterator != null && object2 != null) {
                    object = this.getRangeAxis().getTicks().iterator();
                    while (object.hasNext()) {
                        tick = (Tick)object.next();
                        this.renderer.drawRangeGridLine(graphics2D, this, this.getRangeAxis(), double_, tick.getNumericalValue());
                    }
                }
            }
            if (this.domainMarkers != null) {
                iterator = this.domainMarkers.iterator();
                while (iterator.hasNext()) {
                    object2 = (Marker)iterator.next();
                    this.renderer.drawDomainMarker(graphics2D, this, this.getDomainAxis(), (Marker)object2, double_);
                }
            }
            if (this.rangeMarkers != null) {
                iterator = this.rangeMarkers.iterator();
                while (iterator.hasNext()) {
                    object2 = (Marker)iterator.next();
                    this.renderer.drawRangeMarker(graphics2D, this, this.getRangeAxis(), (Marker)object2, double_);
                }
            }
            this.render(graphics2D, double_, chartRenderingInfo, crosshairInfo);
            this.render2(graphics2D, double_, chartRenderingInfo, crosshairInfo);
            if (this.annotations != null) {
                iterator = this.annotations.iterator();
                while (iterator.hasNext()) {
                    object2 = (Annotation)iterator.next();
                    if (!(object2 instanceof XYAnnotation)) continue;
                    object = (XYAnnotation)object2;
                    object.draw(graphics2D, double_, this.getDomainAxis(), this.getRangeAxis());
                }
            }
            graphics2D.setClip(shape);
            graphics2D.setComposite(composite);
        }
        this.drawOutline(graphics2D, double_);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        XYDataset xYDataset = this.getXYDataset();
        if (xYDataset != null) {
            this.renderer.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                Paint paint = this.renderer.getSeriesPaint(0, n2);
                Stroke stroke = this.renderer.getSeriesStroke(0, n2);
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    this.renderer.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, xYDataset, 0, n2, n4, crosshairInfo);
                    ++n4;
                }
                ++n2;
            }
            this.setDomainCrosshairValue(crosshairInfo.getCrosshairX(), false);
            if (this.isDomainCrosshairVisible()) {
                this.drawVerticalLine(graphics2D, rectangle2D, this.getDomainCrosshairValue(), this.getDomainCrosshairStroke(), this.getDomainCrosshairPaint());
            }
            this.setRangeCrosshairValue(crosshairInfo.getCrosshairY(), false);
            if (this.isRangeCrosshairVisible()) {
                this.drawHorizontalLine(graphics2D, rectangle2D, this.getRangeCrosshairValue(), this.getRangeCrosshairStroke(), this.getRangeCrosshairPaint());
            }
        }
    }

    public void render2(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        XYDataset xYDataset = this.getSecondaryXYDataset();
        if (xYDataset != null) {
            XYItemRenderer xYItemRenderer = this.secondaryRenderer;
            if (xYItemRenderer == null) {
                xYItemRenderer = this.getRenderer();
            }
            xYItemRenderer.initialise(graphics2D, rectangle2D, this, xYDataset, chartRenderingInfo);
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getSecondaryRangeAxis();
            int n = xYDataset.getSeriesCount();
            int n2 = 0;
            while (n2 < n) {
                Paint paint = xYItemRenderer.getSeriesPaint(1, n2);
                Stroke stroke = xYItemRenderer.getSeriesStroke(1, n2);
                graphics2D.setPaint(paint);
                graphics2D.setStroke(stroke);
                int n3 = xYDataset.getItemCount(n2);
                int n4 = 0;
                while (n4 < n3) {
                    xYItemRenderer.drawItem(graphics2D, rectangle2D, chartRenderingInfo, this, valueAxis, valueAxis2, xYDataset, 1, n2, n4, crosshairInfo);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected void drawVerticalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getDomainAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(d2, rectangle2D.getMinY(), d2, rectangle2D.getMaxY());
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    protected void drawHorizontalLine(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, Stroke stroke, Paint paint) {
        double d2 = this.getRangeAxis().translateValueToJava2D(d, rectangle2D);
        Line2D.Double double_ = new Line2D.Double(rectangle2D.getMinX(), d2, rectangle2D.getMaxX(), d2);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        graphics2D.draw(double_);
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        ValueAxis valueAxis;
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            double d = valueAxis2.translateJava2DtoValue(n, chartRenderingInfo.getDataArea());
            valueAxis2.setAnchorValue(d);
            this.setDomainCrosshairValue(d);
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            double d = valueAxis.translateJava2DtoValue(n2, chartRenderingInfo.getDataArea());
            valueAxis.setAnchorValue(d);
            this.setRangeCrosshairValue(d);
        }
    }

    public void zoom(double d) {
        if (d > 0.0) {
            ValueAxis valueAxis = this.getDomainAxis();
            double d2 = valueAxis.getMaximumAxisValue() - valueAxis.getMinimumAxisValue();
            double d3 = d2 * d;
            valueAxis.setAnchoredRange(d3);
            ValueAxis valueAxis2 = this.getRangeAxis();
            d2 = valueAxis2.getMaximumAxisValue() - valueAxis2.getMinimumAxisValue();
            d3 = d2 * d;
            valueAxis2.setAnchoredRange(d3);
        } else {
            this.getRangeAxis().setAutoRange(true);
            this.getDomainAxis().setAutoRange(true);
        }
    }

    public String getPlotType() {
        return "XY Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        Range range = null;
        Dataset dataset = this.getDataset();
        if (valueAxis.equals(this.getSecondaryRangeAxis())) {
            dataset = this.getSecondaryDataset();
        }
        if (dataset != null) {
            range = DatasetUtilities.getDomainExtent(dataset);
        }
        return range;
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        Dataset dataset = this.getDataset();
        if (valueAxis.equals(this.getSecondaryRangeAxis())) {
            dataset = this.getSecondaryDataset();
        }
        if (dataset != null) {
            range = DatasetUtilities.getRangeExtent(dataset);
        }
        return range;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        if (this.domainAxis != null) {
            this.domainAxis.configure();
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.configure();
        }
        if (this.secondaryRangeAxis != null) {
            this.secondaryRangeAxis.configure();
        }
        if (this.getParent() != null) {
            this.getParent().datasetChanged(datasetChangeEvent);
        } else {
            PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
            this.notifyListeners(plotChangeEvent);
        }
    }

    public HorizontalAxis getHorizontalAxis() {
        return (HorizontalAxis)((Object)this.getDomainAxis());
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public VerticalAxis getVerticalAxis() {
        return (VerticalAxis)((Object)this.getRangeAxis());
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    public boolean isDomainCrosshairVisible() {
        return this.domainCrosshairVisible;
    }

    public void setDomainCrosshairVisible(boolean bl) {
        if (this.domainCrosshairVisible != bl) {
            this.domainCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isDomainCrosshairLockedOnData() {
        return this.domainCrosshairLockedOnData;
    }

    public void setDomainCrosshairLockedOnData(boolean bl) {
        if (this.domainCrosshairLockedOnData != bl) {
            this.domainCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getDomainCrosshairValue() {
        return this.domainCrosshairValue;
    }

    public void setDomainCrosshairValue(double d) {
        this.setDomainCrosshairValue(d, true);
    }

    public void setDomainCrosshairValue(double d, boolean bl) {
        this.domainCrosshairValue = d;
        if (this.isDomainCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getDomainCrosshairStroke() {
        return this.domainCrosshairStroke;
    }

    public void setDomainCrosshairStroke(Stroke stroke) {
        this.domainCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getDomainCrosshairPaint() {
        return this.domainCrosshairPaint;
    }

    public void setDomainCrosshairPaint(Paint paint) {
        this.domainCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean isRangeCrosshairVisible() {
        return this.rangeCrosshairVisible;
    }

    public void setRangeCrosshairVisible(boolean bl) {
        if (this.rangeCrosshairVisible != bl) {
            this.rangeCrosshairVisible = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean isRangeCrosshairLockedOnData() {
        return this.rangeCrosshairLockedOnData;
    }

    public void setRangeCrosshairLockedOnData(boolean bl) {
        if (this.rangeCrosshairLockedOnData != bl) {
            this.rangeCrosshairLockedOnData = bl;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public double getRangeCrosshairValue() {
        return this.rangeCrosshairValue;
    }

    public void setRangeCrosshairValue(double d) {
        this.setRangeCrosshairValue(d, true);
    }

    public void setRangeCrosshairValue(double d, boolean bl) {
        this.rangeCrosshairValue = d;
        if (this.isRangeCrosshairVisible() && bl) {
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Stroke getRangeCrosshairStroke() {
        return this.rangeCrosshairStroke;
    }

    public void setRangeCrosshairStroke(Stroke stroke) {
        this.rangeCrosshairStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getRangeCrosshairPaint() {
        return this.rangeCrosshairPaint;
    }

    public void setRangeCrosshairPaint(Paint paint) {
        this.rangeCrosshairPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }
}

