/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.axis.Axis;
import com.jrefinery.chart.axis.AxisNotCompatibleException;
import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.PlotNotCompatibleException;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.data.DatasetChangeEvent;
import com.jrefinery.data.DefaultMeterDataset;
import com.jrefinery.data.MeterDataset;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;

public class ThermometerPlot
extends Plot
implements VerticalValuePlot {
    public static final int UNITS_NONE = 0;
    public static final int UNITS_FAHRENHEIT = 1;
    public static final int UNITS_CELCIUS = 2;
    public static final int UNITS_KELVIN = 3;
    public static final int NONE = 0;
    public static final int RIGHT = 1;
    public static final int BULB = 2;
    public static final int NORMAL = 0;
    public static final int WARNING = 1;
    public static final int CRITICAL = 2;
    protected static final int BULB_RADIUS = 40;
    protected static final int BULB_DIAMETER = 80;
    protected static final int COLUMN_RADIUS = 20;
    protected static final int COLUMN_DIAMETER = 40;
    protected static final int GAP_RADIUS = 5;
    protected static final int GAP_DIAMETER = 10;
    protected static final int AXIS_GAP = 10;
    protected static final String[] UNITS = new String[]{"", "\u00b0F", "\u00b0C", "\u00b0K"};
    protected static final int RANGE_LOW = 0;
    protected static final int RANGE_HIGH = 1;
    protected static final int DISPLAY_LOW = 2;
    protected static final int DISPLAY_HIGH = 3;
    protected static final double DEFAULT_LOWER_BOUND = 0.0;
    protected static final double DEFAULT_UPPER_BOUND = 100.0;
    private MeterDataset data;
    private ValueAxis rangeAxis;
    private double lowerBound = 0.0;
    private double upperBound = 100.0;
    private Spacer padding;
    private Stroke thermometerStroke = new BasicStroke(1.0f);
    private Paint thermometerPaint = Color.black;
    private int units = 2;
    private int valueLocation = 2;
    private Font valueFont = new Font("SansSerif", 1, 16);
    private Paint valuePaint = Color.white;
    private NumberFormat valueFormat = new DecimalFormat();
    private Paint mercuryPaint = Color.lightGray;
    private boolean showValueLines = false;
    private int subrange = -1;
    private double[][] subrangeInfo = new double[][]{{0.0, 50.0, 0.0, 50.0}, {50.0, 75.0, 50.0, 75.0}, {75.0, 100.0, 75.0, 100.0}};
    private boolean followDataInSubranges = false;
    private boolean useSubrangePaint = true;
    private Paint[] subrangePaint = new Paint[]{Color.green, Color.orange, Color.red};
    private boolean subrangeIndicatorsVisible = true;
    private Stroke subrangeIndicatorStroke = new BasicStroke(2.0f);
    private Stroke rangeIndicatorStroke = new BasicStroke(3.0f);

    public ThermometerPlot() {
        this(new DefaultMeterDataset(new Double(Double.MIN_VALUE), new Double(Double.MAX_VALUE), null, null));
    }

    public ThermometerPlot(MeterDataset meterDataset) {
        super(meterDataset);
        this.padding = new Spacer(0, 0.05, 0.05, 0.05, 0.05);
        this.data = meterDataset;
        if (meterDataset != null) {
            meterDataset.addChangeListener(this);
        }
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(null);
        verticalNumberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.setRangeAxis(verticalNumberAxis);
        this.setAxisRange();
    }

    public MeterDataset getData() {
        return this.data;
    }

    public void setData(MeterDataset meterDataset) {
        MeterDataset meterDataset2 = this.data;
        if (meterDataset2 != null) {
            meterDataset2.removeChangeListener(this);
        }
        this.data = meterDataset;
        if (this.data != null) {
            meterDataset.addChangeListener(this);
        }
        PlotChangeEvent plotChangeEvent = new PlotChangeEvent(this);
        this.notifyListeners(plotChangeEvent);
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void setRangeAxis(ValueAxis valueAxis) throws AxisNotCompatibleException {
        if (this.isCompatibleRangeAxis(valueAxis)) {
            if (valueAxis != null) {
                try {
                    valueAxis.setPlot(this);
                }
                catch (PlotNotCompatibleException plotNotCompatibleException) {
                    throw new AxisNotCompatibleException("Plot.setRangeAxis(...): plot not compatible with axis.");
                }
                valueAxis.addChangeListener(this);
            }
            if (this.rangeAxis != null) {
                this.rangeAxis.removeChangeListener(this);
            }
        } else {
            throw new AxisNotCompatibleException("Plot.setRangeAxis(...): axis not compatible with plot.");
        }
        this.rangeAxis = valueAxis;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public void setLowerBound(double d) {
        this.lowerBound = d;
        this.setAxisRange();
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public void setUpperBound(double d) {
        this.upperBound = d;
        this.setAxisRange();
    }

    public void setRange(double d, double d2) {
        this.lowerBound = d;
        this.upperBound = d2;
        this.setAxisRange();
    }

    public Spacer getPadding() {
        return this.padding;
    }

    public void setPadding(Spacer spacer) {
        this.padding = spacer;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getThermometerStroke() {
        return this.thermometerStroke;
    }

    public void setThermometerStroke(Stroke stroke) {
        if (stroke != null) {
            this.thermometerStroke = stroke;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getThermometerPaint() {
        return this.thermometerPaint;
    }

    public void setThermometerPaint(Paint paint) {
        if (paint != null) {
            this.thermometerPaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public int getUnits() {
        return this.units;
    }

    public void setUnits(int n) {
        if (n >= 0 && n < UNITS.length && this.units != n) {
            this.units = n;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setUnits(String string) {
        if (string == null) {
            return;
        }
        string = string.toUpperCase().trim();
        int n = 0;
        while (n < UNITS.length) {
            if (string.equals(UNITS[n].toUpperCase().trim())) {
                this.setUnits(n);
                n = UNITS.length;
            }
            ++n;
        }
    }

    public int getValueLocation() {
        return this.valueLocation;
    }

    public void setValueLocation(int n) {
        if (n < 0 || n >= 3) {
            throw new IllegalArgumentException("ThermometerPlot.setDisplayLocation: location not recognised.");
        }
        this.valueLocation = n;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getValueFont() {
        return this.valueFont;
    }

    public void setValueFont(Font font) {
        if (font != null && !this.valueFont.equals(font)) {
            this.valueFont = font;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getValuePaint() {
        return this.valuePaint;
    }

    public void setValuePaint(Paint paint) {
        if (paint != null && !this.valuePaint.equals(paint)) {
            this.valuePaint = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setValueFormat(NumberFormat numberFormat) {
        if (numberFormat != null) {
            this.valueFormat = numberFormat;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getMercuryPaint() {
        return this.mercuryPaint;
    }

    public void setMercuryPaint(Paint paint) {
        this.mercuryPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getShowValueLines() {
        return this.showValueLines;
    }

    public void setShowValueLines(boolean bl) {
        this.showValueLines = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void setSubrangeInfo(int n, double d, double d2) {
        this.setSubrangeInfo(n, d, d2, d, d2);
    }

    public void setSubrangeInfo(int n, double d, double d2, double d3, double d4) {
        if (n >= 0 && n < 3) {
            this.setSubrange(n, d, d2);
            this.setDisplayRange(n, d3, d4);
            this.setAxisRange();
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public void setSubrange(int n, double d, double d2) {
        if (n >= 0 && n < 3) {
            this.subrangeInfo[n][1] = d2;
            this.subrangeInfo[n][0] = d;
        }
    }

    public void setDisplayRange(int n, double d, double d2) {
        if (n >= 0 && n < this.subrangeInfo.length && ThermometerPlot.isValidNumber(d2) && ThermometerPlot.isValidNumber(d)) {
            if (d2 > d) {
                this.subrangeInfo[n][3] = d2;
                this.subrangeInfo[n][2] = d;
            } else {
                this.subrangeInfo[n][3] = d2;
                this.subrangeInfo[n][2] = d;
            }
        }
    }

    public Paint getSubrangePaint(int n) {
        if (n >= 0 && n < this.subrangePaint.length) {
            return this.subrangePaint[n];
        }
        return this.mercuryPaint;
    }

    public void setSubrangePaint(int n, Paint paint) {
        if (n >= 0 && n < this.subrangePaint.length && paint != null) {
            this.subrangePaint[n] = paint;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public boolean getFollowDataInSubranges() {
        return this.followDataInSubranges;
    }

    public void setFollowDataInSubranges(boolean bl) {
        this.followDataInSubranges = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public boolean getUseSubrangePaint() {
        return this.useSubrangePaint;
    }

    public void setUseSubrangePaint(boolean bl) {
        this.useSubrangePaint = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Insets insets;
        RoundRectangle2D.Double double_ = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_2 = new RoundRectangle2D.Double();
        RoundRectangle2D.Double double_3 = new RoundRectangle2D.Double();
        Ellipse2D.Double double_4 = new Ellipse2D.Double();
        Ellipse2D.Double double_5 = new Ellipse2D.Double();
        String string = null;
        FontMetrics fontMetrics = null;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        this.drawBackground(graphics2D, rectangle2D);
        int n = (int)(rectangle2D.getX() + rectangle2D.getWidth() / 2.0);
        int n2 = (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0);
        int n3 = (int)(rectangle2D.getMinY() + 40.0);
        int n4 = (int)(rectangle2D.getMaxY() - 80.0);
        Rectangle2D.Double double_6 = new Rectangle2D.Double(n - 20, n3, 20.0, n4 - n3);
        ((RectangularShape)double_4).setFrame(n - 40, n4, 80.0, 80.0);
        ((RoundRectangle2D)double_).setRoundRect(n - 20, rectangle2D.getMinY(), 40.0, n4 + 80 - n3, 40.0, 40.0);
        Area area = new Area(double_4);
        Area area2 = new Area(double_);
        area.add(area2);
        ((RectangularShape)double_5).setFrame(n - 40 + 5, n4 + 5, 70.0, 70.0);
        ((RoundRectangle2D)double_2).setRoundRect(n - 20 + 5, rectangle2D.getMinY() + 5.0, 30.0, n4 + 80 - 10 - n3, 30.0, 30.0);
        Area area3 = new Area(double_5);
        area2 = new Area(double_2);
        area3.add(area2);
        if (this.data != null && this.data.isValueValid()) {
            double d = this.data.getValue().doubleValue();
            double d2 = this.rangeAxis.translateValueToJava2D(d, double_6);
            int n5 = 30;
            int n6 = 15;
            int n7 = n5 / 2;
            int n8 = (int)Math.round(d2);
            if ((double)n8 < 5.0 + rectangle2D.getMinY()) {
                n8 = (int)(5.0 + rectangle2D.getMinY());
                n7 = 40;
            }
            Area area4 = new Area(double_5);
            if (n8 < n4 + 40) {
                ((RoundRectangle2D)double_3).setRoundRect(n - n6, n8, n5, n4 + 40 - n8, n7, n7);
                area2 = new Area(double_3);
                area4.add(area2);
            }
            graphics2D.setPaint(this.getCurrentPaint());
            graphics2D.fill(area4);
            int n9 = 10;
            if (this.showValueLines) {
                n9 += 40;
            }
            Rectangle2D.Double double_7 = new Rectangle2D.Double(n - 20 - 10, n3, n9, n4 - n3 + 1);
            this.rangeAxis.draw(graphics2D, rectangle2D, double_7, 3);
            if (this.subrangeIndicatorsVisible) {
                Line2D.Double double_8;
                double d3;
                double d4;
                graphics2D.setStroke(this.subrangeIndicatorStroke);
                Range range = this.rangeAxis.getRange();
                double d5 = this.subrangeInfo[0][0];
                if (range.contains(d5)) {
                    d4 = n + 20 + 2;
                    d3 = this.rangeAxis.translateValueToJava2D(d5, double_6);
                    double_8 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[0]);
                    graphics2D.draw(double_8);
                }
                if (range.contains(d5 = this.subrangeInfo[1][0])) {
                    d4 = n + 20 + 2;
                    d3 = this.rangeAxis.translateValueToJava2D(d5, double_6);
                    double_8 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[1]);
                    graphics2D.draw(double_8);
                }
                if (range.contains(d5 = this.subrangeInfo[2][0])) {
                    d4 = n + 20 + 2;
                    d3 = this.rangeAxis.translateValueToJava2D(d5, double_6);
                    double_8 = new Line2D.Double(d4, d3, d4 + 10.0, d3);
                    graphics2D.setPaint(this.subrangePaint[2]);
                    graphics2D.draw(double_8);
                }
            }
            graphics2D.setFont(this.valueFont);
            graphics2D.setPaint(this.valuePaint);
            fontMetrics = graphics2D.getFontMetrics();
            switch (this.valueLocation) {
                case 1: {
                    graphics2D.drawString(this.valueFormat.format(d), n + 20 + 5, n2);
                    break;
                }
                case 2: {
                    string = this.valueFormat.format(d);
                    n5 = fontMetrics.stringWidth(string) / 2;
                    graphics2D.drawString(string, n - n5, n4 + 40 + 5);
                    break;
                }
            }
        }
        graphics2D.setPaint(this.thermometerPaint);
        graphics2D.setFont(this.valueFont);
        fontMetrics = graphics2D.getFontMetrics();
        int n10 = n - 20 - 10 - fontMetrics.stringWidth(UNITS[this.units]);
        if ((double)n10 > rectangle2D.getMinX()) {
            graphics2D.drawString(UNITS[this.units], n10, (int)(rectangle2D.getMinY() + 20.0));
        }
        graphics2D.setStroke(this.thermometerStroke);
        graphics2D.draw(area);
        graphics2D.draw(area3);
        this.drawOutline(graphics2D, rectangle2D);
    }

    public void zoom(double d) {
    }

    public String getPlotType() {
        return "Thermometer Plot";
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        Number number = this.data.getValue();
        if (number != null) {
            double d = number.doubleValue();
            this.subrange = this.inSubrange(0, d) ? 0 : (this.inSubrange(1, d) ? 1 : (this.inSubrange(2, d) ? 2 : -1));
            this.setAxisRange();
        }
        super.datasetChanged(datasetChangeEvent);
    }

    public Number getMinimumVerticalDataValue() {
        return new Double(this.lowerBound);
    }

    public Number getMaximumVerticalDataValue() {
        return new Double(this.upperBound);
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        return new Range(this.lowerBound, this.upperBound);
    }

    public boolean isCompatibleHorizontalAxis(Axis axis) {
        return axis == null;
    }

    public boolean isCompatibleVerticalAxis(Axis axis) {
        return axis instanceof VerticalNumberAxis;
    }

    public void propertyChange() {
        this.notifyListeners(new PlotChangeEvent(this));
    }

    protected void setAxisRange() {
        if (this.subrange >= 0 && this.followDataInSubranges) {
            this.rangeAxis.setRange(new Range(this.subrangeInfo[this.subrange][2], this.subrangeInfo[this.subrange][3]));
        } else {
            this.rangeAxis.setRange(this.lowerBound, this.upperBound);
        }
    }

    public List getLegendItemLabels() {
        return null;
    }

    public LegendItemCollection getLegendItems() {
        return null;
    }

    public boolean isCompatibleRangeAxis(ValueAxis valueAxis) {
        if (valueAxis == null) {
            return true;
        }
        return valueAxis instanceof VerticalAxis;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.rangeAxis;
    }

    protected static boolean isValidNumber(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    private boolean inSubrange(int n, double d) {
        return d > this.subrangeInfo[n][0] && d <= this.subrangeInfo[n][1];
    }

    private Paint getCurrentPaint() {
        Paint paint = this.mercuryPaint;
        if (this.useSubrangePaint) {
            double d = this.data.getValue().doubleValue();
            if (this.inSubrange(0, d)) {
                paint = this.subrangePaint[0];
            } else if (this.inSubrange(1, d)) {
                paint = this.subrangePaint[1];
            } else if (this.inSubrange(2, d)) {
                paint = this.subrangePaint[2];
            }
        }
        return paint;
    }
}

