/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.entity.PieSectionEntity;
import com.jrefinery.chart.plot.PiePlot;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.data.DatasetUtilities;
import com.jrefinery.data.PieDataset;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Pie3DPlot
extends PiePlot {
    private double depthFactor = 0.2;

    public Pie3DPlot(PieDataset pieDataset) {
        super(pieDataset);
        this.setCircularAttribute(false);
    }

    public void setDepthFactor(double d) {
        this.depthFactor = d;
    }

    public double getDepthFactor() {
        return this.depthFactor;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Paint paint;
        Serializable serializable;
        Object object2;
        List list;
        Shape shape = graphics2D.getClip();
        Rectangle2D rectangle2D2 = shape != null ? shape.getBounds2D().createIntersection(rectangle2D) : rectangle2D;
        Insets insets = this.getInsets();
        if (insets != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
            chartRenderingInfo.setDataArea(rectangle2D);
        }
        double d = this.getInteriorGap();
        double d2 = rectangle2D.getWidth() * d;
        double d3 = rectangle2D.getHeight() * d;
        double d4 = rectangle2D.getX() + d2 / 2.0;
        double d5 = rectangle2D.getY() + d3 / 2.0;
        double d6 = rectangle2D.getWidth() - d2;
        double d7 = rectangle2D.getHeight() - d3;
        if (this.isCircular()) {
            double d8 = Math.min(d6, d7) / 2.0;
            d4 = (d4 + d4 + d6) / 2.0 - d8;
            d5 = (d5 + d5 + d7) / 2.0 - d8;
            d6 = 2.0 * d8;
            d7 = 2.0 * d8;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d5, d6, d7);
        double d9 = this.getRadius();
        double d10 = (1.0 - d9) * d6;
        double d11 = (1.0 - d9) * d7;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(d4 + d10 / 2.0, d5 + d11 / 2.0, d6 - d10, d7 - d11);
        this.drawBackground(graphics2D, rectangle2D);
        PieDataset pieDataset = this.getPieDataset();
        if (pieDataset == null) {
            return;
        }
        if ((double)pieDataset.getKeys().size() > rectangle2D.getWidth()) {
            String string = "Too many elements";
            Font font = new Font("dialog", 1, 10);
            graphics2D.setFont(font);
            int n = (int)font.getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
            graphics2D.drawString(string, (int)(rectangle2D.getX() + (rectangle2D.getWidth() - (double)n) / 2.0), (int)(rectangle2D.getY() + rectangle2D.getHeight() / 2.0));
            return;
        }
        if (this.isCircular()) {
            double d12 = Math.min(rectangle2D.getWidth(), rectangle2D.getHeight()) / 2.0;
            rectangle2D = new Rectangle2D.Double(rectangle2D.getCenterX() - d12, rectangle2D.getCenterY() - d12, 2.0 * d12, 2.0 * d12);
        }
        if ((list = pieDataset.getKeys()).size() == 0) {
            return;
        }
        double d13 = ((RectangularShape)double_2).getX();
        double d14 = ((RectangularShape)double_2).getY();
        graphics2D.clip(rectangle2D2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        double d15 = DatasetUtilities.getPieDatasetTotal(pieDataset);
        double d16 = 0.0;
        int n = (int)(((RectangularShape)double_2).getHeight() * this.depthFactor);
        if (n < 0) {
            return;
        }
        ArrayList<Arc2D.Double> arrayList = new ArrayList<Arc2D.Double>();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (Comparable)iterator.next();
            serializable = pieDataset.getValue((Comparable)object2);
            double d17 = ((Number)serializable).doubleValue();
            if (d17 <= 0.0) {
                arrayList.add(null);
                continue;
            }
            bl = true;
            double d18 = this.getStartAngle();
            int n2 = this.getDirection();
            double d19 = d18 + (double)n2 * (d16 * 360.0) / d15;
            double d20 = d18 + (double)n2 * (d16 + d17) * 360.0 / d15;
            arrayList.add(new Arc2D.Double(d13, d14 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, d19, d20 - d19, 2));
            d16 += d17;
        }
        object2 = graphics2D.getClip();
        serializable = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY(), ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n);
        Ellipse2D.Double double_3 = new Ellipse2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)double_2).getY() + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n);
        Rectangle2D.Double double_4 = new Rectangle2D.Double(((RectangularShape)((Object)serializable)).getX(), ((RectangularShape)((Object)serializable)).getCenterY(), ((RectangularShape)double_2).getWidth(), double_3.getMaxY() - ((RectangularShape)((Object)serializable)).getCenterY());
        Rectangle2D.Double double_5 = new Rectangle2D.Double(((RectangularShape)double_2).getX(), ((RectangularShape)((Object)serializable)).getY(), ((RectangularShape)double_2).getWidth(), double_3.getCenterY() - ((RectangularShape)((Object)serializable)).getY());
        Area area = new Area((Shape)((Object)serializable));
        area.add(new Area(double_4));
        Area area2 = new Area(double_3);
        area2.add(new Area(double_5));
        Area area3 = new Area(area);
        area3.intersect(area2);
        Area area4 = new Area(area3);
        area4.subtract(new Area((Shape)((Object)serializable)));
        Area area5 = new Area(area3);
        area5.subtract(new Area(double_3));
        Paint paint2 = this.getOutlinePaint(0);
        Arc2D.Double double_6 = new Arc2D.Double(d13, d14 + (double)n, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, 0.0, 360.0, 2);
        int n3 = arrayList.size();
        int n4 = 0;
        while (n4 < n3) {
            double_6 = (Arc2D.Double)arrayList.get(n4);
            if (double_6 != null) {
                paint = this.getPaint(n4);
                paint2 = this.getOutlinePaint(n4);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_6);
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_6);
                graphics2D.setPaint(paint);
                Point2D point2D = double_6.getStartPoint();
                double d21 = double_6.getCenterX();
                double d22 = double_6.getCenterY();
                int[] nArray = new int[]{(int)double_6.getCenterX(), (int)double_6.getCenterX(), (int)point2D.getX(), (int)point2D.getX()};
                int[] nArray2 = new int[]{(int)double_6.getCenterY(), (int)double_6.getCenterY() - n, (int)point2D.getY() - n, (int)point2D.getY()};
                object = new Polygon(nArray, nArray2, 4);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.fill((Shape)object);
                graphics2D.setPaint(paint2);
                graphics2D.draw((Shape)object);
                graphics2D.setPaint(paint);
            }
            ++n4;
        }
        graphics2D.setPaint(Color.gray);
        graphics2D.fill(area5);
        graphics2D.fill(area4);
        int n5 = 0;
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Arc2D arc2D = (Arc2D)iterator.next();
            if (arc2D != null) {
                paint = this.getPaint(n5);
                this.drawSide(graphics2D, double_2, arc2D, area4, area5, paint);
            }
            ++n5;
        }
        graphics2D.setClip((Shape)object2);
        int n6 = 0;
        while (n6 < n3) {
            double_6 = (Arc2D.Double)arrayList.get(n6);
            if (double_6 != null) {
                Arc2D.Double double_7 = new Arc2D.Double(d13, d14, ((RectangularShape)double_2).getWidth(), ((RectangularShape)double_2).getHeight() - (double)n, double_6.getAngleStart(), double_6.getAngleExtent(), 2);
                paint = this.getPaint(n6);
                paint2 = this.getOutlinePaint(n6);
                graphics2D.setPaint(paint);
                graphics2D.fill(double_7);
                graphics2D.setStroke(new BasicStroke());
                graphics2D.setPaint(paint2);
                graphics2D.draw(double_7);
                Comparable comparable = (Comparable)list.get(n6);
                if (chartRenderingInfo != null) {
                    if (this.getToolTipGenerator() == null) {
                        this.setToolTipGenerator(new StandardPieToolTipGenerator());
                    }
                    String string = this.getToolTipGenerator().generateToolTip(pieDataset, comparable);
                    object = null;
                    if (this.getURLGenerator() != null) {
                        object = this.getURLGenerator().generateURL(pieDataset, comparable);
                    }
                    PieSectionEntity pieSectionEntity = new PieSectionEntity(double_7, string, (String)object, comparable, n6);
                    chartRenderingInfo.getEntityCollection().addEntity(pieSectionEntity);
                }
                if (this.getSectionLabelType() != 0) {
                    this.drawLabel(graphics2D, double_2, double_, pieDataset, pieDataset.getValue(comparable).doubleValue(), n6, double_6.getAngleStart(), double_6.getAngleExtent());
                }
            }
            ++n6;
        }
        graphics2D.clip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    public void drawSide(Graphics2D graphics2D, Rectangle2D rectangle2D, Arc2D arc2D, Area area, Area area2, Paint paint) {
        double d = arc2D.getAngleStart();
        double d2 = arc2D.getAngleExtent();
        double d3 = d + d2;
        if (d2 < 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 > -180.0) {
                        Area area3 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area3.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area3);
                        graphics2D.setPaint(Color.lightGray);
                        graphics2D.draw(area3);
                    } else {
                        Area area4 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                        area4.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area4);
                        graphics2D.fill(area2);
                        Area area5 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                        area5.intersect(area);
                        graphics2D.fill(area5);
                        graphics2D.setPaint(Color.lightGray);
                        graphics2D.draw(area4);
                        graphics2D.draw(area2);
                        graphics2D.draw(area5);
                    }
                } else {
                    Area area6 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area6.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area6);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area6);
                    Area area7 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area7.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area7);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area7);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 > -180.0) {
                    Area area8 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area8.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area8);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area8);
                } else {
                    Area area9 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area9.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area9);
                    graphics2D.fill(area);
                    Area area10 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                    area10.intersect(area2);
                    graphics2D.fill(area10);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area9);
                    graphics2D.draw(area2);
                    graphics2D.draw(area10);
                }
            } else {
                Area area11 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                area11.intersect(area2);
                graphics2D.setPaint(paint);
                graphics2D.fill(area11);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.draw(area11);
                Area area12 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                area12.intersect(area);
                graphics2D.setPaint(paint);
                graphics2D.fill(area12);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.draw(area12);
            }
        } else if (d2 > 0.0) {
            if (this.isAngleAtFront(d)) {
                if (!this.isAngleAtBack(d3)) {
                    if (d2 < 180.0) {
                        Area area13 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area13.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area13);
                        graphics2D.setPaint(Color.lightGray);
                        graphics2D.draw(area13);
                    } else {
                        Area area14 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                        area14.intersect(area);
                        graphics2D.setPaint(paint);
                        graphics2D.fill(area14);
                        graphics2D.fill(area2);
                        Area area15 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getMaxX(), rectangle2D.getHeight()));
                        area15.intersect(area);
                        graphics2D.fill(area15);
                        graphics2D.setPaint(Color.lightGray);
                        graphics2D.draw(area14);
                        graphics2D.draw(area2);
                        graphics2D.draw(area15);
                    }
                } else {
                    Area area16 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area16.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area16);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area16);
                    Area area17 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area17.intersect(area);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area17);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area17);
                }
            } else if (!this.isAngleAtFront(d3)) {
                if (d2 < 180.0) {
                    Area area18 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area18.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area18);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area18);
                } else {
                    Area area19 = new Area(new Rectangle2D.Double(arc2D.getStartPoint().getX(), rectangle2D.getY(), rectangle2D.getX() - arc2D.getStartPoint().getX(), rectangle2D.getHeight()));
                    area19.intersect(area2);
                    graphics2D.setPaint(paint);
                    graphics2D.fill(area19);
                    graphics2D.fill(area);
                    Area area20 = new Area(new Rectangle2D.Double(arc2D.getEndPoint().getX(), rectangle2D.getY(), rectangle2D.getMaxX() - arc2D.getEndPoint().getX(), rectangle2D.getHeight()));
                    area20.intersect(area2);
                    graphics2D.fill(area20);
                    graphics2D.setPaint(Color.lightGray);
                    graphics2D.draw(area19);
                    graphics2D.draw(area2);
                    graphics2D.draw(area20);
                }
            } else {
                Area area21 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getStartPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                area21.intersect(area2);
                graphics2D.setPaint(paint);
                graphics2D.fill(area21);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.draw(area21);
                Area area22 = new Area(new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), arc2D.getEndPoint().getX() - rectangle2D.getX(), rectangle2D.getHeight()));
                area22.intersect(area);
                graphics2D.setPaint(paint);
                graphics2D.fill(area22);
                graphics2D.setPaint(Color.lightGray);
                graphics2D.draw(area22);
            }
        }
    }

    public String getPlotType() {
        return "Pie 3D Plot";
    }

    private boolean isAngleAtFront(double d) {
        return Math.sin(Math.toRadians(d)) < 0.0;
    }

    private boolean isAngleAtBack(double d) {
        return Math.sin(Math.toRadians(d)) > 0.0;
    }
}

