/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.axis.HorizontalNumberAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.data.DatasetGroup;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidXYPlot
extends XYPlot {
    private List subplots = new ArrayList();

    public OverlaidXYPlot(String string, String string2) {
        this(new HorizontalNumberAxis(string), new VerticalNumberAxis(string2));
    }

    public OverlaidXYPlot(ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(null, valueAxis, valueAxis2);
    }

    public void add(XYPlot xYPlot) {
        ValueAxis valueAxis;
        DatasetGroup datasetGroup = this.getDatasetGroup();
        if (datasetGroup != null) {
            xYPlot.setDatasetGroup(datasetGroup);
        } else {
            this.setDatasetGroup(xYPlot.getDatasetGroup());
        }
        xYPlot.setParent(this);
        xYPlot.setDomainAxis(null);
        xYPlot.setRangeAxis(null);
        this.subplots.add(xYPlot);
        this.indexSubplots(0, 16384);
        ValueAxis valueAxis2 = this.getDomainAxis();
        if (valueAxis2 != null) {
            valueAxis2.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = xYPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            XYPlot xYPlot = (XYPlot)iterator.next();
            xYPlot.render(graphics2D, rectangle2D, chartRenderingInfo, crosshairInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid XY Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getHorizontalDataRange(valueAxis));
            }
        }
        return range;
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                XYPlot xYPlot = (XYPlot)iterator.next();
                range = Range.combine(range, xYPlot.getVerticalDataRange(valueAxis));
            }
        }
        return range;
    }

    protected int[] indexSubplots(int n, int n2) {
        this.setIndex(n2);
        int[] nArray = new int[]{n, ++n2};
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            Plot plot = (Plot)iterator.next();
            nArray = plot.indexSubplots(nArray[0], nArray[1]);
        }
        return nArray;
    }
}

