/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.HorizontalCategoryAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.plot.VerticalCategoryPlot;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class OverlaidVerticalCategoryPlot
extends VerticalCategoryPlot {
    private List subplots = new ArrayList();

    public OverlaidVerticalCategoryPlot(String string, String string2) {
        this(new HorizontalCategoryAxis(string), new VerticalNumberAxis(string2));
    }

    public OverlaidVerticalCategoryPlot(CategoryAxis categoryAxis, ValueAxis valueAxis) {
        super(null, categoryAxis, valueAxis, null);
    }

    public void add(VerticalCategoryPlot verticalCategoryPlot) {
        ValueAxis valueAxis;
        verticalCategoryPlot.setParent(this);
        verticalCategoryPlot.setDomainAxis(null);
        verticalCategoryPlot.setRangeAxis(null);
        this.subplots.add(verticalCategoryPlot);
        CategoryAxis categoryAxis = this.getDomainAxis();
        if (categoryAxis != null) {
            categoryAxis.configure();
        }
        if ((valueAxis = this.getRangeAxis()) != null) {
            valueAxis.configure();
        }
    }

    public CategoryDataset getCategoryDataset() {
        CategoryDataset categoryDataset = null;
        if (this.subplots.size() > 0) {
            CategoryPlot categoryPlot = (CategoryPlot)this.subplots.get(0);
            categoryDataset = categoryPlot.getCategoryDataset();
        }
        return categoryDataset;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                CategoryPlot categoryPlot = (CategoryPlot)iterator.next();
                LegendItemCollection legendItemCollection2 = categoryPlot.getLegendItems();
                legendItemCollection.addAll(legendItemCollection2);
            }
        }
        return legendItemCollection;
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Iterator iterator = this.subplots.iterator();
        while (iterator.hasNext()) {
            VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
            verticalCategoryPlot.render(graphics2D, rectangle2D, chartRenderingInfo);
        }
    }

    public String getPlotType() {
        return "Overlaid Vertical Category Plot";
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        Range range = null;
        if (this.subplots != null) {
            Iterator iterator = this.subplots.iterator();
            while (iterator.hasNext()) {
                VerticalCategoryPlot verticalCategoryPlot = (VerticalCategoryPlot)iterator.next();
                range = Range.combine(range, verticalCategoryPlot.getVerticalDataRange(valueAxis));
            }
        }
        return range;
    }
}

