/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.plot;

import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.CrosshairInfo;
import com.jrefinery.chart.Marker;
import com.jrefinery.chart.annotations.Annotation;
import com.jrefinery.chart.annotations.XYAnnotation;
import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.plot.HorizontalValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public class FastScatterPlot
extends Plot
implements HorizontalValuePlot,
VerticalValuePlot {
    private float[][] data;
    private Range horizontalDataRange;
    private Range verticalDataRange;
    private ValueAxis domainAxis;
    private ValueAxis rangeAxis;
    private List domainMarkers;
    private List rangeMarkers;
    private List annotations;

    public FastScatterPlot(float[][] fArray, ValueAxis valueAxis, ValueAxis valueAxis2) {
        super(null);
        this.data = fArray;
        this.horizontalDataRange = this.calculateHorizontalDataRange(fArray);
        this.verticalDataRange = this.calculateVerticalDataRange(fArray);
        this.domainAxis = valueAxis;
        if (valueAxis != null) {
            valueAxis.setPlot(this);
            valueAxis.addChangeListener(this);
        }
        this.rangeAxis = valueAxis2;
        if (valueAxis2 != null) {
            valueAxis2.setPlot(this);
            valueAxis2.addChangeListener(this);
        }
    }

    public ValueAxis getDomainAxis() {
        return this.domainAxis;
    }

    public ValueAxis getRangeAxis() {
        return this.rangeAxis;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Iterator iterator;
        Object object2;
        Insets insets;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setPlotArea(rectangle2D);
        }
        if ((insets = this.getInsets()) != null) {
            rectangle2D.setRect(rectangle2D.getX() + (double)insets.left, rectangle2D.getY() + (double)insets.top, rectangle2D.getWidth() - (double)insets.left - (double)insets.right, rectangle2D.getHeight() - (double)insets.top - (double)insets.bottom);
        }
        double d = 0.0;
        if (this.domainAxis != null) {
            HorizontalAxis horizontalAxis = (HorizontalAxis)((Object)this.domainAxis);
            d = horizontalAxis.reserveHeight(graphics2D, this, rectangle2D, 1);
        }
        double d2 = 0.0;
        if (this.rangeAxis != null) {
            object2 = (VerticalAxis)((Object)this.rangeAxis);
            d2 = object2.reserveWidth(graphics2D, this, rectangle2D, 3, d, 1);
        }
        object2 = new Rectangle2D.Double(rectangle2D.getX() + d2, rectangle2D.getY(), rectangle2D.getWidth() - d2, rectangle2D.getHeight() - d);
        if (chartRenderingInfo != null) {
            chartRenderingInfo.setDataArea((Rectangle2D)object2);
        }
        this.drawBackground(graphics2D, (Rectangle2D)object2);
        if (this.domainAxis != null) {
            this.domainAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object2, 1);
        }
        if (this.rangeAxis != null) {
            this.rangeAxis.draw(graphics2D, rectangle2D, (Rectangle2D)object2, 3);
        }
        Shape shape = graphics2D.getClip();
        Composite composite = graphics2D.getComposite();
        graphics2D.clip((Shape)object2);
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (this.domainMarkers != null) {
            iterator = this.domainMarkers.iterator();
            while (iterator.hasNext()) {
                object = (Marker)iterator.next();
            }
        }
        if (this.rangeMarkers != null) {
            iterator = this.rangeMarkers.iterator();
            while (iterator.hasNext()) {
                object = (Marker)iterator.next();
            }
        }
        this.render(graphics2D, (Rectangle2D)object2, chartRenderingInfo, null);
        if (this.annotations != null) {
            iterator = this.annotations.iterator();
            while (iterator.hasNext()) {
                object = (Annotation)iterator.next();
                if (!(object instanceof XYAnnotation)) continue;
                XYAnnotation xYAnnotation = (XYAnnotation)object;
                xYAnnotation.draw(graphics2D, (Rectangle2D)object2, this.getDomainAxis(), this.getRangeAxis());
            }
        }
        graphics2D.setClip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, (Rectangle2D)object2);
    }

    public void render(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo, CrosshairInfo crosshairInfo) {
        graphics2D.setPaint(Color.red);
        if (this.data != null) {
            ValueAxis valueAxis = this.getDomainAxis();
            ValueAxis valueAxis2 = this.getRangeAxis();
            int n = 0;
            while (n < this.data[0].length) {
                float f = this.data[0][n];
                float f2 = this.data[1][n];
                int n2 = (int)valueAxis.translateValueToJava2D(f, rectangle2D);
                int n3 = (int)valueAxis2.translateValueToJava2D(f2, rectangle2D);
                graphics2D.fillRect(n2, n3, 1, 1);
                ++n;
            }
        }
    }

    public String getPlotType() {
        return "Fast Scatter Plot";
    }

    public Range getHorizontalDataRange(ValueAxis valueAxis) {
        return this.horizontalDataRange;
    }

    public ValueAxis getHorizontalValueAxis() {
        return this.getDomainAxis();
    }

    public Range getVerticalDataRange(ValueAxis valueAxis) {
        return this.verticalDataRange;
    }

    public ValueAxis getVerticalValueAxis() {
        return this.getRangeAxis();
    }

    private Range calculateHorizontalDataRange(float[][] fArray) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < fArray[0].length) {
            float f3 = fArray[0][n];
            if (f3 < f) {
                f = f3;
            }
            if (f3 > f2) {
                f2 = f3;
            }
            ++n;
        }
        return new Range(f, f2);
    }

    private Range calculateVerticalDataRange(float[][] fArray) {
        float f = Float.POSITIVE_INFINITY;
        float f2 = Float.NEGATIVE_INFINITY;
        int n = 0;
        while (n < fArray[0].length) {
            float f3 = fArray[1][n];
            if (f3 < f) {
                f = f3;
            }
            if (f3 > f2) {
                f2 = f3;
            }
            ++n;
        }
        return new Range(f, f2);
    }
}

