/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class VerticalSymbolicAxis
extends VerticalNumberAxis
implements VerticalAxis {
    public static final Paint DEFAULT_SYMBOLIC_GRID_LINE_PAINT = new Color(232, 234, 232);
    private List symbolicValue;
    private boolean ySymbolicZoomIsAccepted = false;
    private List symbolicGridLineList = null;
    private Paint symbolicGridPaint;
    private boolean symbolicGridLinesVisible;

    public VerticalSymbolicAxis(String string, String[] stringArray) {
        super(string);
        this.symbolicValue = Arrays.asList(stringArray);
        this.symbolicGridLinesVisible = true;
        this.symbolicGridPaint = DEFAULT_SYMBOLIC_GRID_LINE_PAINT;
        this.setAutoTickUnitSelection(false, false);
        this.setAutoRangeStickyZero(false);
    }

    public String[] getSymbolicValue() {
        String[] stringArray = new String[this.symbolicValue.size()];
        stringArray = this.symbolicValue.toArray(stringArray);
        return stringArray;
    }

    public Paint getSymbolicGridPaint() {
        return this.symbolicGridPaint;
    }

    public boolean isGridLinesVisible() {
        return this.symbolicGridLinesVisible;
    }

    public void setSymbolicGridLinesVisible(boolean bl) {
        if (this.symbolicGridLinesVisible != bl) {
            this.symbolicGridLinesVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String valueToString(double d) {
        String string;
        try {
            string = (String)this.symbolicValue.get((int)d);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            string = new String("");
        }
        return string;
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        double d = this.getTickUnit().getSize();
        int n2 = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            int n3 = 0;
            while (n3 < n2) {
                double d3 = d2 + (double)n3 * d;
                double d4 = this.translateValueToJava2D(d3, rectangle2D2);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.valueToString(d3);
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = n == 3 ? (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
                float f2 = (float)(d4 + (double)(lineMetrics.getAscent() / 2.0f));
                Tick tick = new Tick(new Double(d3), string, f, f2);
                this.getTicks().add(tick);
                ++n3;
            }
        }
    }

    public void setAnchoredRange(double d) {
        if (this.ySymbolicZoomIsAccepted) {
            double d2 = Math.rint(this.getAnchorValue());
            double d3 = Math.rint(d2 - d / 2.0) - 0.5;
            double d4 = Math.rint(d2 + d / 2.0) + 0.5;
            if (d3 < -0.5) {
                d3 = -0.5;
            }
            if (d4 > (double)this.symbolicValue.size() - 0.5) {
                d4 = (double)this.symbolicValue.size() - 0.5;
            }
            this.setRange(d3, d4);
        }
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        throw new UnsupportedOperationException();
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        super.draw(graphics2D, rectangle2D, rectangle2D2, n);
        if (this.symbolicGridLinesVisible) {
            this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2);
        }
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        this.drawSymbolicGridLines(graphics2D, rectangle2D, rectangle2D2, true);
    }

    public void drawSymbolicGridLines(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        this.symbolicGridLineList = new Vector(this.getTicks().size());
        boolean bl2 = bl;
        double d = rectangle2D2.getX();
        double d2 = this.getPlot().getOutlineStroke() != null ? (double)((BasicStroke)this.getPlot().getOutlineStroke()).getLineWidth() : 1.0;
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            double d3 = this.translateValueToJava2D(tick.getNumericalValue() + 0.5, rectangle2D2);
            double d4 = this.translateValueToJava2D(tick.getNumericalValue() - 0.5, rectangle2D2);
            if (bl2) {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode((Color)this.symbolicGridPaint);
            } else {
                graphics2D.setPaint(Color.white);
                graphics2D.setXORMode(Color.white);
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(d + d2, d3, rectangle2D2.getMaxX() - d - d2, d4 - d3);
            graphics2D.fill(double_);
            this.symbolicGridLineList.add(double_);
            boolean bl3 = bl2 = !bl2;
        }
        graphics2D.setPaintMode();
    }

    public Rectangle2D.Double getSymbolicGridLine(int n) {
        if (this.symbolicGridLineList != null) {
            return (Rectangle2D.Double)this.symbolicGridLineList.get(n);
        }
        return null;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof VerticalValuePlot) {
            double d;
            double d2;
            double d3 = this.symbolicValue.size() - 1;
            double d4 = d3 - (d2 = 0.0);
            if (d4 < (d = this.getAutoRangeMinimumSize())) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            double d5 = 0.5;
            double d6 = 0.5;
            if (this.autoRangeIncludesZero()) {
                if (this.autoRangeStickyZero()) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += d5);
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= d6);
                } else {
                    d3 = Math.max(0.0, d3 + d5);
                    d2 = Math.min(0.0, d2 - d6);
                }
            } else if (this.autoRangeStickyZero()) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + d5) : (d3 += d5);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - d6) : (d2 -= d6);
            } else {
                d3 += d5;
                d2 -= d6;
            }
            this.setRangeAttribute(new Range(d2, d3));
        }
    }
}

