/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.axis.NumberTickUnit;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.TickUnits;
import com.jrefinery.chart.axis.VerticalAxis;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.NumberFormat;
import java.util.Iterator;

public class VerticalNumberAxis
extends NumberAxis
implements VerticalAxis {
    public static final boolean DEFAULT_VERTICAL_LABEL = true;
    private boolean verticalLabel = true;

    public VerticalNumberAxis(String string) {
        super(string);
    }

    public boolean isVerticalLabel() {
        return this.verticalLabel;
    }

    public void setVerticalLabel(boolean bl) {
        if (this.verticalLabel != bl) {
            this.verticalLabel = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        if (this.isInverted()) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = range.getLowerBound();
        double d2 = range.getUpperBound();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.isInverted()) {
            return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof VerticalValuePlot) {
            double d;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)plot);
            Range range = verticalValuePlot.getVerticalDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            double d4 = d3 - d2;
            if (d4 < (d = this.getAutoRangeMinimumSize())) {
                double d5 = (d - d4) / 2.0;
                d3 += d5;
                d2 -= d5;
            }
            if (this.autoRangeIncludesZero()) {
                if (this.autoRangeStickyZero()) {
                    d3 = d3 <= 0.0 ? 0.0 : (d3 += this.getUpperMargin() * (d3 - Math.min(d2, 0.0)));
                    d2 = d2 >= 0.0 ? 0.0 : (d2 -= this.getLowerMargin() * (d3 - d2));
                } else {
                    d4 = Math.max(0.0, d3) - Math.min(0.0, d2);
                    d3 = Math.max(0.0, d3 + this.getUpperMargin() * d4);
                    d2 = Math.min(0.0, d2 - this.getLowerMargin() * d4);
                }
            } else if (this.autoRangeStickyZero()) {
                d3 = d3 <= 0.0 ? Math.min(0.0, d3 + this.getUpperMargin() * d4) : (d3 += this.getUpperMargin() * d4);
                d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d4) : (d2 -= this.getLowerMargin() * d4);
            } else {
                d3 += this.getUpperMargin() * d4;
                d2 -= this.getLowerMargin() * d4;
            }
            this.setRangeAttribute(new Range(d2, d3));
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        double d;
        double d2;
        double d3;
        if (!this.isVisible()) {
            return;
        }
        this.drawVerticalLabel(this.getLabel(), this.isVerticalLabel(), graphics2D, rectangle2D, rectangle2D2, n);
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
        if (n == 3) {
            d3 = rectangle2D2.getMinX();
            d2 = this.getTickMarkOutsideLength();
            d = this.getTickMarkInsideLength();
        } else {
            d3 = rectangle2D2.getMaxX();
            d2 = this.getTickMarkInsideLength();
            d = this.getTickMarkOutsideLength();
        }
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Double double_ = new Line2D.Double(d3 - d2, f, d3 + d, f);
            graphics2D.draw(double_);
        }
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        if (this.getFixedDimension() > 0.0) {
            return this.getFixedDimension();
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = insets.left + insets.right;
            d = this.verticalLabel ? (d += ((RectangularShape)cloneable).getHeight()) : (d += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d2 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d2 += this.getMaxTickLabelWidth(graphics2D, rectangle2D);
        }
        return d + d2;
    }

    public double reserveWidth(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        Cloneable cloneable;
        if (!this.isVisible()) {
            return 0.0;
        }
        if (this.getFixedDimension() > 0.0) {
            return this.getFixedDimension();
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            cloneable = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = insets.left + insets.right;
            d2 = this.verticalLabel ? (d2 += ((RectangularShape)cloneable).getHeight()) : (d2 += ((RectangularShape)cloneable).getWidth());
        }
        cloneable = this.getTickLabelInsets();
        double d3 = ((Insets)cloneable).left + ((Insets)cloneable).right;
        if (this.isTickLabelsVisible()) {
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight() - d);
            this.refreshTicks(graphics2D, rectangle2D, double_, n);
            d3 += this.getMaxTickLabelWidth(graphics2D, double_);
        }
        return d2 + d3;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Insets insets = this.getTickLabelInsets();
        double d = this.getTickLabelFont().getLineMetrics("123", fontRenderContext).getHeight() + (float)insets.top + (float)insets.bottom;
        double d2 = this.translateValueToJava2D(0.0, rectangle2D2);
        TickUnits tickUnits = this.getStandardTickUnits();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnits.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(numberTickUnit.getSize(), rectangle2D2);
        double d4 = Math.abs(d3 - d2);
        double d5 = d / d4 * numberTickUnit.getSize();
        NumberTickUnit numberTickUnit2 = new NumberTickUnit(d5, null);
        NumberTickUnit numberTickUnit3 = (NumberTickUnit)tickUnits.getCeilingTickUnit(numberTickUnit2);
        this.setTickUnit(numberTickUnit3, false, false);
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        double d = this.getTickUnit().getSize();
        int n2 = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            int n3 = 0;
            while (n3 < n2) {
                double d3 = d2 + (double)n3 * d;
                double d4 = this.translateValueToJava2D(d3, rectangle2D2);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.getTickUnit().valueToString(d3);
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = n == 3 ? (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
                float f2 = (float)(d4 + (double)(lineMetrics.getAscent() / 2.0f));
                Tick tick = new Tick(new Double(d3), string, f, f2);
                this.getTicks().add(tick);
                ++n3;
            }
        }
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalValuePlot;
    }
}

