/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.VerticalValuePlot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class VerticalLogarithmicAxis
extends VerticalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-100;
    private boolean log10TickLabelsFlag = true;
    private boolean allowNegativesFlag = false;
    private boolean smallLogFlag = false;
    private final DecimalFormat numberFormatterObj = new DecimalFormat("0.00000");

    public VerticalLogarithmicAxis(String string) {
        super(string);
    }

    public void setLog10TickLabelsFlag(boolean bl) {
        this.log10TickLabelsFlag = bl;
    }

    public boolean getLog10TickLabelsFlag() {
        return this.log10TickLabelsFlag;
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = rectangle2D.getMaxY();
        double d5 = rectangle2D.getMinY();
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = this.switchedLog10(range.getLowerBound());
        double d2 = this.switchedLog10(range.getUpperBound());
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getMaxY();
        if (this.isInverted()) {
            return Math.pow(10.0, d + ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return Math.pow(10.0, d2 - ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof VerticalValuePlot) {
            double d;
            VerticalValuePlot verticalValuePlot = (VerticalValuePlot)((Object)plot);
            Range range = verticalValuePlot.getVerticalDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = this.computeLogFloor(range.getLowerBound());
            if (!this.allowNegativesFlag && d2 >= 0.0 && d2 < 1.0E-100) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.allowNegativesFlag && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = this.computeLogCeil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.setRangeAttribute(new Range(d2, d3));
            this.setupSmallLogFlag();
        }
    }

    protected double computeLogCeil(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.ceil(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.ceil(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.ceil(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    protected double computeLogFloor(double d) {
        double d2;
        if (this.allowNegativesFlag) {
            if (d > 10.0) {
                d2 = Math.log(d) / LOG10_VALUE;
                d2 = Math.floor(d2);
                d2 = Math.pow(10.0, d2);
            } else if (d < -10.0) {
                d2 = Math.log(-d) / LOG10_VALUE;
                d2 = Math.floor(-d2);
                d2 = -Math.pow(10.0, -d2);
            } else {
                d2 = Math.floor(d);
            }
        } else if (d > 0.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        double d = this.getRange().getLowerBound();
        if (this.smallLogFlag && d < 1.0E-100) {
            d = 1.0E-100;
        }
        double d2 = this.getRange().getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        int n3 = (int)Math.rint(this.switchedLog10(d2));
        boolean bl = false;
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = 10;
            if (n4 == n3) {
                n5 = 1;
            }
            int n6 = 0;
            while (n6 < n5) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, n4) + Math.pow(10.0, n4) * (double)n6;
                    if (n6 == 0) {
                        if (this.log10TickLabelsFlag) {
                            string = "10^" + n4;
                        } else if (n4 >= 0) {
                            string = Long.toString((long)Math.rint(d3));
                        } else {
                            this.numberFormatterObj.setMaximumFractionDigits(-n4);
                            string = this.numberFormatterObj.format(d3);
                        }
                    } else {
                        string = "";
                    }
                } else {
                    if (bl) {
                        --n6;
                    }
                    double d4 = d3 = n4 >= 0 ? Math.pow(10.0, n4) + Math.pow(10.0, n4) * (double)n6 : -(Math.pow(10.0, -n4) - Math.pow(10.0, -n4 - 1) * (double)n6);
                    if (n6 == 0) {
                        if (!bl) {
                            if (n4 > n2 && n4 < n3 && Math.abs(d3 - 1.0) < 1.0E-4) {
                                d3 = 0.0;
                                bl = true;
                                string = "0";
                            } else {
                                string = this.log10TickLabelsFlag ? (n4 < 0 ? "-" : "") + "10^" + Math.abs(n4) : Long.toString((long)Math.rint(d3));
                            }
                        } else {
                            string = "";
                            bl = false;
                        }
                    } else {
                        string = "";
                        bl = false;
                    }
                }
                if (d3 > d2) {
                    return;
                }
                double d5 = this.translateValueToJava2D(d3, rectangle2D2);
                Rectangle2D rectangle2D3 = this.getTickLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
                Insets insets = this.getTickLabelInsets();
                float f = n == 3 ? (float)(rectangle2D2.getX() - rectangle2D3.getWidth() - (double)this.getTickLabelInsets().right) : (float)(rectangle2D2.getMaxX() + (double)this.getTickLabelInsets().left);
                float f2 = (float)(d5 + rectangle2D3.getHeight() / 3.0);
                this.getTicks().add(new Tick(new Double(d3), string, f, f2));
                ++n6;
            }
            ++n4;
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }
}

