/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.HorizontalMarkerAxisBand;
import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.axis.NumberTickUnit;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.TickUnit;
import com.jrefinery.chart.axis.TickUnits;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.plot.HorizontalValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import java.util.Iterator;

public class HorizontalNumberAxis
extends NumberAxis
implements HorizontalAxis {
    public static final boolean DEFAULT_VERTICAL_TICK_LABELS = false;
    private boolean verticalTickLabels = false;
    private HorizontalMarkerAxisBand markerBand = null;

    public HorizontalNumberAxis(String string) {
        super(string);
    }

    public boolean isVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        this.verticalTickLabels = bl;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public HorizontalMarkerAxisBand getMarkerBand() {
        return this.markerBand;
    }

    public void setMarkerBand(HorizontalMarkerAxisBand horizontalMarkerAxisBand) {
        this.markerBand = horizontalMarkerAxisBand;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        if (this.isInverted()) {
            return d5 - (d - d2) / (d3 - d2) * (d5 - d4);
        }
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = range.getLowerBound();
        double d2 = range.getUpperBound();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getMaxX();
        if (this.isInverted()) {
            return d2 - ((double)f - d3) / (d4 - d3) * (d2 - d);
        }
        return d + ((double)f - d3) / (d4 - d3) * (d2 - d);
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof HorizontalValuePlot) {
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)plot);
            Range range = horizontalValuePlot.getHorizontalDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d = range.getUpperBound();
            double d2 = range.getLowerBound();
            double d3 = d - d2;
            double d4 = this.getFixedAutoRange();
            if (d4 > 0.0) {
                d2 = d - d4;
            } else {
                double d5 = this.getAutoRangeMinimumSize();
                if (d3 < d5) {
                    double d6 = (d5 - d3) / 2.0;
                    d += d6;
                    d2 -= d6;
                }
                if (this.autoRangeIncludesZero()) {
                    if (this.autoRangeStickyZero()) {
                        d = d <= 0.0 ? 0.0 : (d += this.getUpperMargin() * d3);
                        d2 = d2 >= 0.0 ? 0.0 : (d2 -= this.getLowerMargin() * d3);
                    } else {
                        d = Math.max(0.0, d + this.getUpperMargin() * d3);
                        d2 = Math.min(0.0, d2 - this.getLowerMargin() * d3);
                    }
                } else if (this.autoRangeStickyZero()) {
                    d = d <= 0.0 ? Math.min(0.0, d + this.getUpperMargin() * d3) : (d += this.getUpperMargin() * d3);
                    d2 = d2 >= 0.0 ? Math.max(0.0, d2 - this.getLowerMargin() * d3) : (d2 -= this.getLowerMargin() * d3);
                } else {
                    d += this.getUpperMargin() * d3;
                    d2 -= this.getLowerMargin() * d3;
                }
            }
            this.setRangeAttribute(new Range(d2, d));
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        double d = this.getTickUnit().getSize();
        int n2 = this.calculateVisibleTickCount();
        double d2 = this.calculateLowestVisibleTickValue();
        if (n2 <= 500) {
            int n3 = 0;
            while (n3 < n2) {
                double d3 = d2 + (double)n3 * d;
                double d4 = this.translateValueToJava2D(d3, rectangle2D2);
                NumberFormat numberFormat = this.getNumberFormatOverride();
                String string = numberFormat != null ? numberFormat.format(d3) : this.getTickUnit().valueToString(d3);
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f = 0.0f;
                float f2 = 0.0f;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    f = (float)(d4 + rectangle2D3.getHeight() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getWidth());
                } else {
                    f = (float)(d4 - rectangle2D3.getWidth() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getHeight());
                }
                Tick tick = new Tick(new Double(d3), string, f, f2);
                this.getTicks().add(tick);
                ++n3;
            }
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        double d;
        double d2;
        double d3;
        if (!this.isVisible()) {
            return;
        }
        double d4 = 0.0;
        d4 = n == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
        d4 = this.drawHorizontalLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, n, d4);
        if (this.markerBand != null) {
            if (n == 1) {
                d4 -= this.markerBand.getHeight(graphics2D);
            }
            this.markerBand.draw(graphics2D, rectangle2D, rectangle2D2, 0.0, d4);
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
        if (n == 0) {
            d3 = rectangle2D2.getMinY();
            d2 = this.getTickMarkOutsideLength();
            d = this.getTickMarkInsideLength();
        } else {
            d3 = rectangle2D2.getMaxY();
            d2 = this.getTickMarkInsideLength();
            d = this.getTickMarkOutsideLength();
        }
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)graphics2D, (float)tick.getX(), (float)tick.getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Double double_ = new Line2D.Double(f, d3 - d2, f, d3 + d);
            graphics2D.draw(double_);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        if (!this.isVisible()) {
            return 0.0;
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            LineMetrics lineMetrics = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = (float)insets.top + lineMetrics.getHeight() + (float)insets.bottom;
        }
        double d2 = 0.0;
        if (this.markerBand != null) {
            d2 = this.markerBand.getHeight(graphics2D);
        }
        Insets insets = this.getTickLabelInsets();
        double d3 = insets.top + insets.bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d + d2 + d3;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            LineMetrics lineMetrics = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = (float)insets.top + lineMetrics.getHeight() + (float)insets.bottom;
        }
        double d3 = 0.0;
        if (this.markerBand != null) {
            d3 = this.markerBand.getHeight(graphics2D);
        }
        Insets insets = this.getTickLabelInsets();
        double d4 = insets.top + insets.bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d4 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d2 + d3 + d4;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = this.translateValueToJava2D(0.0, rectangle2D2);
        double d2 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnits tickUnits = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(tickUnit.getSize(), rectangle2D2);
        double d4 = Math.abs(d3 - d);
        double d5 = d2 / d4 * tickUnit.getSize();
        NumberTickUnit numberTickUnit = (NumberTickUnit)tickUnits.getCeilingTickUnit(d5);
        double d6 = this.translateValueToJava2D(numberTickUnit.getSize(), rectangle2D2);
        double d7 = Math.abs(d6 - d);
        d2 = this.estimateMaximumTickLabelWidth(graphics2D, numberTickUnit);
        if (d2 > d7) {
            numberTickUnit = (NumberTickUnit)tickUnits.getLargerTickUnit(numberTickUnit);
        }
        this.setTickUnit(numberTickUnit, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D graphics2D, TickUnit tickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.left + insets.right;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        if (this.verticalTickLabels) {
            d += font.getStringBounds("0", fontRenderContext).getHeight();
        } else {
            Range range = this.getRange();
            double d2 = range.getLowerBound();
            double d3 = range.getUpperBound();
            String string = tickUnit.valueToString(d2);
            String string2 = tickUnit.valueToString(d3);
            double d4 = font.getStringBounds(string, fontRenderContext).getWidth();
            double d5 = font.getStringBounds(string2, fontRenderContext).getWidth();
            d += Math.max(d4, d5);
        }
        return d;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

