/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.ColorBarAxis;
import com.jrefinery.chart.axis.HorizontalLogarithmicAxis;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.plot.ContourValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.data.Range;
import com.jrefinery.ui.ColorPalette;
import com.jrefinery.ui.RainbowPalette;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.Iterator;

public class HorizontalLogarithmicColorBarAxis
extends HorizontalLogarithmicAxis
implements ColorBarAxis {
    public static final ColorPalette DEFAULT_COLOR_PALETTE = new RainbowPalette();
    public static final int DEFAULT_COLORBAR_THICKNESS = 0;
    public static final double DEFAULT_COLORBAR_THICKNESS_PCT = 0.05;
    public static final int DEFAULT_OUTERGAP = 20;
    private ColorPalette colorPalette = null;
    private int colorBarLength = 0;
    private int colorBarThickness = 0;
    private double colorBarThicknessPercent = 0.05;
    private int outerGap;

    public HorizontalLogarithmicColorBarAxis(String string) {
        super(string);
        this.getColorPalette().setLogscale(true);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        Rectangle2D rectangle2D3;
        Object object;
        Serializable serializable;
        double d;
        Object object2;
        double d2 = rectangle2D2.getWidth();
        if (this.colorBarLength > 0) {
            d2 = this.colorBarLength;
        }
        double d3 = this.colorBarThicknessPercent * rectangle2D2.getHeight();
        if (this.colorBarThickness > 0) {
            d3 = this.colorBarThickness;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D2.getX(), rectangle2D2.getMaxY() + (double)this.outerGap, d2, d3);
        this.refreshTicks(graphics2D, rectangle2D, double_, 1);
        this.drawColorBar(graphics2D, double_);
        double d4 = double_.getMaxX();
        double d5 = (float)double_.getMaxY();
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            object2 = (Tick)iterator.next();
            d = this.translateValueToJava2D(((Tick)object2).getNumericalValue(), double_);
            if (this.isTickLabelsVisible()) {
                serializable = this.getLabelFont();
                graphics2D.setPaint(this.getTickLabelPaint());
                object = this.getLabel();
                rectangle2D3 = serializable.getStringBounds((String)object, graphics2D.getFontRenderContext());
                if (this.isVerticalTickLabels()) {
                    d = rectangle2D.getX() + (double)this.getLabelInsets().left + rectangle2D3.getHeight();
                    d4 = rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                    RefineryUtilities.drawRotatedString((String)object, (Graphics2D)graphics2D, (float)((float)d), (float)((float)d4), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(((Tick)object2).getText(), ((Tick)object2).getX(), ((Tick)object2).getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            serializable = new Line2D.Double(d, d5 - 2.0, d, d5 + 2.0);
            graphics2D.draw((Shape)((Object)serializable));
        }
        object2 = this.getLabel();
        if (object2 != null) {
            d = this.getMaxTickLabelHeight(graphics2D, double_, this.isVerticalTickLabels());
            serializable = this.getLabelFont();
            graphics2D.setFont((Font)serializable);
            graphics2D.setPaint(this.getLabelPaint());
            object = graphics2D.getFontRenderContext();
            rectangle2D3 = serializable.getStringBounds((String)object2, (FontRenderContext)object);
            LineMetrics lineMetrics = serializable.getLineMetrics((String)object2, (FontRenderContext)object);
            float f = (float)(((RectangularShape)double_).getX() + ((RectangularShape)double_).getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)(d + double_.getMaxY() + (double)this.getLabelInsets().bottom + 20.0 + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading());
            graphics2D.drawString((String)object2, f, f2);
        }
    }

    public void drawColorBar(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setStroke(new BasicStroke(1.0f));
        double d = rectangle2D.getY();
        double d2 = rectangle2D.getMaxY();
        double d3 = rectangle2D.getX();
        Line2D.Double double_ = new Line2D.Double();
        while (d3 <= rectangle2D.getMaxX()) {
            double d4 = this.translateJava2DtoValue((float)d3, rectangle2D);
            ((Line2D)double_).setLine(d3, d, d3, d2);
            graphics2D.setPaint(this.getPaint(d4));
            graphics2D.draw(double_);
            d3 += 1.0;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
        graphics2D.setStroke(stroke);
    }

    public ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    public Paint getPaint(double d) {
        return this.colorPalette.getPaint(d);
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof ContourValuePlot;
    }

    public void setColorPalette(ColorPalette colorPalette) {
        this.colorPalette = colorPalette;
    }

    public void setMaximumAxisValue(double d) {
        this.colorPalette.setMaxZ(d);
        super.setMaximumAxisValue(d);
    }

    public void setMinimumAxisValue(double d) {
        this.colorPalette.setMinZ(d);
        super.setMinimumAxisValue(d);
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot instanceof ContourValuePlot) {
            double d;
            ContourValuePlot contourValuePlot = (ContourValuePlot)((Object)plot);
            Range range = contourValuePlot.getContourDataRange();
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = this.computeLogFloor(range.getLowerBound());
            if (!this.getAllowNegativesFlag() && d2 >= 0.0 && d2 < 1.0E-25) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.getAllowNegativesFlag() && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / HorizontalLogarithmicAxis.LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = Math.ceil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.setRangeAttribute(new Range(d2, d3));
            this.setupSmallLogFlag();
            this.colorPalette.setMinZ(d2);
            this.colorPalette.setMaxZ(d3);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D) {
        double d = super.reserveHeight(graphics2D, plot, rectangle2D, 1);
        return d + rectangle2D.getHeight() * this.colorBarThicknessPercent + (double)this.outerGap;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        double d2 = super.reserveHeight(graphics2D, plot, rectangle2D, n, d, 3);
        d2 = d2 + rectangle2D.getHeight() * this.colorBarThicknessPercent + (double)this.outerGap;
        return d2;
    }
}

