/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.HorizontalNumberAxis;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.plot.HorizontalValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.data.Range;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class HorizontalLogarithmicAxis
extends HorizontalNumberAxis {
    public static final double LOG10_VALUE = Math.log(10.0);
    public static final double SMALL_LOG_VALUE = 1.0E-25;
    private boolean allowNegativesFlag = false;
    private boolean smallLogFlag = false;
    private final DecimalFormat numberFormatterObj = new DecimalFormat("0.00000");

    public HorizontalLogarithmicAxis(String string) {
        super(string);
    }

    public void setAllowNegativesFlag(boolean bl) {
        this.allowNegativesFlag = bl;
    }

    public boolean getAllowNegativesFlag() {
        return this.allowNegativesFlag;
    }

    public void setRange(Range range) {
        super.setRange(range);
        this.setupSmallLogFlag();
    }

    protected void setupSmallLogFlag() {
        double d = this.getRange().getLowerBound();
        this.smallLogFlag = !this.allowNegativesFlag && d < 10.0 && d > 0.0;
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = this.switchedLog10(range.getLowerBound());
        double d3 = this.switchedLog10(range.getUpperBound());
        double d4 = rectangle2D.getMaxX();
        double d5 = rectangle2D.getMinX();
        d = this.switchedLog10(d);
        if (this.isInverted()) {
            return d4 - (d - d2) / (d3 - d2) * (d4 - d5);
        }
        return d5 + (d - d2) / (d3 - d2) * (d4 - d5);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = this.switchedLog10(range.getLowerBound());
        double d2 = this.switchedLog10(range.getUpperBound());
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getMaxX();
        if (this.isInverted()) {
            return Math.pow(10.0, d2 - ((double)f - d3) / (d4 - d3) * (d2 - d));
        }
        return Math.pow(10.0, d + ((double)f - d3) / (d4 - d3) * (d2 - d));
    }

    public void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot instanceof HorizontalValuePlot) {
            double d;
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)plot);
            Range range = horizontalValuePlot.getHorizontalDataRange(this);
            if (range == null) {
                range = new Range(0.0, 1.0);
            }
            double d2 = this.computeLogFloor(range.getLowerBound());
            if (!this.allowNegativesFlag && d2 >= 0.0 && d2 < 1.0E-25) {
                d2 = range.getLowerBound();
            }
            double d3 = range.getUpperBound();
            if (!this.allowNegativesFlag && d3 < 1.0 && d3 > 0.0 && d2 > 0.0) {
                d = Math.log(d3) / LOG10_VALUE;
                d = Math.ceil(-d + 0.001);
                d3 = (d = Math.pow(10.0, d)) > 0.0 ? Math.ceil(d3 * d) / d : Math.ceil(d3);
            } else {
                d3 = Math.ceil(d3);
            }
            d = this.getAutoRangeMinimumSize();
            if (d3 - d2 < d) {
                d3 = (d3 + d2 + d) / 2.0;
                d2 = (d3 + d2 - d) / 2.0;
            }
            this.setRangeAttribute(new Range(d2, d3));
            this.setupSmallLogFlag();
        }
    }

    protected double computeLogCeil(double d) {
        double d2;
        if (d > 10.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.ceil(d2);
            d2 = Math.pow(10.0, d2);
        } else if (d < -10.0) {
            d2 = Math.log(-d) / LOG10_VALUE;
            d2 = Math.ceil(-d2);
            d2 = -Math.pow(10.0, -d2);
        } else {
            d2 = Math.ceil(d);
        }
        return d2;
    }

    protected double computeLogFloor(double d) {
        double d2;
        if (d > 10.0) {
            d2 = Math.log(d) / LOG10_VALUE;
            d2 = Math.floor(d2);
            d2 = Math.pow(10.0, d2);
        } else if (d < -10.0) {
            d2 = Math.log(-d) / LOG10_VALUE;
            d2 = Math.floor(-d2);
            d2 = -Math.pow(10.0, -d2);
        } else {
            d2 = Math.floor(d);
        }
        return d2;
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Range range = this.getRange();
        double d = range.getLowerBound();
        if (this.smallLogFlag && d < 1.0E-25) {
            d = 1.0E-25;
        }
        double d2 = range.getUpperBound();
        int n2 = (int)Math.rint(this.switchedLog10(d));
        int n3 = (int)Math.rint(this.switchedLog10(d2));
        boolean bl = false;
        int n4 = n2;
        while (n4 <= n3) {
            int n5 = 0;
            while (n5 < 10) {
                String string;
                double d3;
                if (this.smallLogFlag) {
                    d3 = Math.pow(10.0, n4) + Math.pow(10.0, n4) * (double)n5;
                    if (n4 < 0 && d3 > 0.0 && d3 < 1.0) {
                        if (n5 == 0 || n4 > -4 && n5 < 2 || d3 >= d2) {
                            this.numberFormatterObj.setMaximumFractionDigits(-n4);
                            string = this.numberFormatterObj.format(d3);
                        } else {
                            string = "";
                        }
                    } else {
                        string = n5 < 5 || d3 >= d2 ? this.getTickUnit().valueToString(d3) : "";
                    }
                } else {
                    if (bl) {
                        --n5;
                    }
                    double d4 = d3 = n4 >= 0 ? Math.pow(10.0, n4) + Math.pow(10.0, n4) * (double)n5 : -(Math.pow(10.0, -n4) - Math.pow(10.0, -n4 - 1) * (double)n5);
                    if (!bl) {
                        if (Math.abs(d3 - 1.0) < 1.0E-4 && d <= 0.0 && d2 >= 0.0) {
                            d3 = 0.0;
                            bl = true;
                        }
                    } else {
                        bl = false;
                    }
                    string = this.getTickUnit().valueToString(d3);
                }
                if (d3 > d2) {
                    return;
                }
                double d5 = this.translateValueToJava2D(d3, rectangle2D2);
                Rectangle2D rectangle2D3 = this.getTickLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
                float f = 0.0f;
                float f2 = 0.0f;
                Insets insets = this.getTickLabelInsets();
                if (this.isVerticalTickLabels()) {
                    f = (float)(d5 + rectangle2D3.getHeight() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getWidth());
                } else {
                    f = (float)(d5 - rectangle2D3.getWidth() / 2.0);
                    f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getHeight());
                }
                Tick tick = new Tick(new Double(d3), string, f, f2);
                this.getTicks().add(tick);
                if (n4 >= n3) {
                    return;
                }
                ++n5;
            }
            ++n4;
        }
    }

    protected double switchedLog10(double d) {
        return this.smallLogFlag ? Math.log(d) / LOG10_VALUE : this.adjustedLog10(d);
    }

    public double adjustedLog10(double d) {
        boolean bl = d < 0.0;
        if (bl) {
            d = -d;
        }
        if (d < 10.0) {
            d += (10.0 - d) / 10.0;
        }
        return bl ? -(Math.log(d) / LOG10_VALUE) : Math.log(d) / LOG10_VALUE;
    }
}

