/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.DateAxis;
import com.jrefinery.chart.axis.DateTickUnit;
import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.axis.TickUnit;
import com.jrefinery.chart.axis.TickUnits;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.plot.HorizontalValuePlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.data.DateRange;
import com.jrefinery.data.Range;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.text.DateFormat;
import java.util.Date;
import java.util.Iterator;

public class HorizontalDateAxis
extends DateAxis
implements HorizontalAxis {
    private boolean verticalTickLabels = false;

    public HorizontalDateAxis(String string) {
        super(string);
    }

    public boolean getVerticalTickLabels() {
        return this.verticalTickLabels;
    }

    public void setVerticalTickLabels(boolean bl) {
        if (this.verticalTickLabels != bl) {
            this.verticalTickLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void configure() {
        if (this.isAutoRange()) {
            this.autoAdjustRange();
        }
    }

    public double translateDateToJava2D(Date date, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = date.getTime();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateValueToJava2D(double d, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d2 = range.getLowerBound();
        double d3 = range.getUpperBound();
        double d4 = rectangle2D.getX();
        double d5 = rectangle2D.getMaxX();
        return d4 + (d - d2) / (d3 - d2) * (d5 - d4);
    }

    public double translateJava2DtoValue(float f, Rectangle2D rectangle2D) {
        Range range = this.getRange();
        double d = range.getLowerBound();
        double d2 = range.getUpperBound();
        double d3 = rectangle2D.getX();
        double d4 = rectangle2D.getMaxX();
        double d5 = d + ((double)f - d3) / (d4 - d3) * (d2 - d);
        return d5;
    }

    protected void autoAdjustRange() {
        Plot plot = this.getPlot();
        if (plot == null) {
            return;
        }
        if (plot instanceof HorizontalValuePlot) {
            long l;
            HorizontalValuePlot horizontalValuePlot = (HorizontalValuePlot)((Object)plot);
            Range range = horizontalValuePlot.getHorizontalDataRange(this);
            if (range == null) {
                range = new DateRange();
            }
            long l2 = (long)range.getUpperBound();
            long l3 = (long)this.getFixedAutoRange();
            if ((double)l3 > 0.0) {
                l = l2 - l3;
            } else {
                long l4;
                l = (long)range.getLowerBound();
                double d = l2 - l;
                if (d < (double)(l4 = (long)this.getAutoRangeMinimumSize())) {
                    long l5 = (long)((double)l4 - d) / 2L;
                    l2 += l5;
                    l -= l5;
                }
                l2 += (long)(d * this.getUpperMargin());
                l -= (long)(d * this.getLowerMargin());
            }
            this.setRangeAttribute(new DateRange(new Date(l), new Date(l2)));
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.getTicks().clear();
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        if (this.isAutoTickUnitSelection()) {
            this.selectAutoTickUnit(graphics2D, rectangle2D, rectangle2D2);
        }
        Object var6_6 = null;
        DateTickUnit dateTickUnit = this.getTickUnit();
        Date date = this.calculateLowestVisibleTickValue(dateTickUnit);
        Date date2 = this.getMaximumDate();
        while (date.before(date2)) {
            double d = this.translateDateToJava2D(date, rectangle2D2);
            DateFormat dateFormat = this.getDateFormatOverride();
            String string = dateFormat != null ? dateFormat.format(date) : dateTickUnit.dateToString(date);
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            float f = 0.0f;
            float f2 = 0.0f;
            Insets insets = this.getTickLabelInsets();
            if (this.verticalTickLabels) {
                f = (float)(d + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getWidth());
            } else {
                f = (float)(d - rectangle2D3.getWidth() / 2.0);
                f2 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)insets.bottom) : (float)(rectangle2D2.getMaxY() + (double)insets.top + rectangle2D3.getHeight());
            }
            Tick tick = new Tick(date, string, f, f2);
            this.getTicks().add(tick);
            date = dateTickUnit.addToDate(date);
        }
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        double d;
        double d2;
        double d3;
        if (!this.isVisible()) {
            return;
        }
        double d4 = 0.0;
        d4 = n == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
        String string = this.getLabel();
        if (string != null) {
            Font font = this.getLabelFont();
            Insets insets = this.getLabelInsets();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getLabelPaint());
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            d4 = n == 0 ? d4 + (double)insets.top + (double)lineMetrics.getAscent() : d4 - (double)insets.bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            float f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)d4;
            graphics2D.drawString(string, f, f2);
            d4 = n == 0 ? d4 + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading() + (double)insets.bottom : d4 - (double)insets.bottom - (double)insets.top - (double)lineMetrics.getHeight();
        }
        this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
        if (n == 0) {
            d3 = rectangle2D2.getMinY();
            d2 = this.getTickMarkOutsideLength();
            d = this.getTickMarkInsideLength();
        } else {
            d3 = rectangle2D2.getMaxY();
            d2 = this.getTickMarkInsideLength();
            d = this.getTickMarkOutsideLength();
        }
        graphics2D.setFont(this.getTickLabelFont());
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            float f = (float)this.translateValueToJava2D(tick.getNumericalValue(), rectangle2D2);
            if (this.isTickLabelsVisible()) {
                graphics2D.setPaint(this.getTickLabelPaint());
                if (this.verticalTickLabels) {
                    RefineryUtilities.drawRotatedString((String)tick.getText(), (Graphics2D)graphics2D, (float)tick.getX(), (float)tick.getY(), (double)-1.5707963267948966);
                } else {
                    graphics2D.drawString(tick.getText(), tick.getX(), tick.getY());
                }
            }
            if (!this.isTickMarksVisible()) continue;
            graphics2D.setStroke(this.getTickMarkStroke());
            graphics2D.setPaint(this.getTickMarkPaint());
            Line2D.Double double_ = new Line2D.Double(f, d3 - d2, f, d3 + d);
            graphics2D.draw(double_);
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        Object object;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            object = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = (float)insets.top + ((LineMetrics)object).getHeight() + (float)insets.bottom;
        }
        object = this.getTickLabelInsets();
        double d2 = ((Insets)object).top + ((Insets)object).bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d2 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d + d2;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        Object object;
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            object = this.getLabelFont().getLineMetrics(string, graphics2D.getFontRenderContext());
            d2 = ((LineMetrics)object).getHeight();
            Insets insets = this.getLabelInsets();
            if (insets != null) {
                d2 += (double)(insets.top + insets.bottom);
            }
        }
        object = this.getTickLabelInsets();
        double d3 = ((Insets)object).top + ((Insets)object).bottom;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            d3 += this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalTickLabels);
        }
        return d2 + d3;
    }

    protected void selectAutoTickUnit(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        double d = this.translateValueToJava2D(0.0, rectangle2D2);
        double d2 = this.estimateMaximumTickLabelWidth(graphics2D, this.getTickUnit());
        TickUnits tickUnits = this.getStandardTickUnits();
        TickUnit tickUnit = tickUnits.getCeilingTickUnit(this.getTickUnit());
        double d3 = this.translateValueToJava2D(tickUnit.getSize(), rectangle2D2);
        double d4 = Math.abs(d3 - d);
        double d5 = d2 / d4 * tickUnit.getSize();
        DateTickUnit dateTickUnit = (DateTickUnit)tickUnits.getCeilingTickUnit(d5);
        double d6 = this.translateValueToJava2D(dateTickUnit.getSize(), rectangle2D2);
        double d7 = Math.abs(d6 - d);
        d2 = this.estimateMaximumTickLabelWidth(graphics2D, dateTickUnit);
        if (d2 > d7) {
            dateTickUnit = (DateTickUnit)tickUnits.getLargerTickUnit(dateTickUnit);
        }
        this.setTickUnit(dateTickUnit, false, false);
    }

    private double estimateMaximumTickLabelWidth(Graphics2D graphics2D, DateTickUnit dateTickUnit) {
        Insets insets = this.getTickLabelInsets();
        double d = insets.left + insets.right;
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = this.getTickLabelFont();
        if (this.verticalTickLabels) {
            d += font.getStringBounds("1-Jan-2002", fontRenderContext).getHeight();
        } else {
            DateRange dateRange = (DateRange)this.getRange();
            Date date = dateRange.getLowerDate();
            Date date2 = dateRange.getUpperDate();
            String string = dateTickUnit.dateToString(date);
            String string2 = dateTickUnit.dateToString(date2);
            double d2 = font.getStringBounds(string, fontRenderContext).getWidth();
            double d3 = font.getStringBounds(string2, fontRenderContext).getWidth();
            d += Math.max(d2, d3);
        }
        return d;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight();
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof HorizontalValuePlot;
    }
}

