/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.CategoryAxis;
import com.jrefinery.chart.axis.HorizontalAxis;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.VerticalCategoryPlot;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Iterator;

public class HorizontalCategoryAxis
extends CategoryAxis
implements HorizontalAxis {
    public static final boolean DEFAULT_VERTICAL_CATEGORY_LABELS = false;
    private boolean verticalCategoryLabels = false;
    private boolean skipCategoryLabelsToFit;
    private int tickHeight;

    public HorizontalCategoryAxis(String string) {
        super(string);
    }

    public boolean getVerticalCategoryLabels() {
        return this.verticalCategoryLabels;
    }

    public void setVerticalCategoryLabels(boolean bl) {
        if (this.verticalCategoryLabels != bl) {
            this.verticalCategoryLabels = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public void setVerticalTickLabels(boolean bl) {
        this.setVerticalCategoryLabels(bl);
    }

    public boolean getSkipCategoryLabelsToFit() {
        return this.skipCategoryLabelsToFit;
    }

    public void setSkipCategoryLabelsToFit(boolean bl) {
        if (this.skipCategoryLabelsToFit != bl) {
            this.skipCategoryLabelsToFit = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public double getCategoryStart(int n, int n2, Rectangle2D rectangle2D) {
        double d = rectangle2D.getX() + rectangle2D.getWidth() * this.getLowerMargin();
        double d2 = this.calculateCategoryWidth(n2, rectangle2D);
        double d3 = this.calculateCategoryGapWidth(n2, rectangle2D);
        return d += (double)n * (d2 + d3);
    }

    public double getCategoryMiddle(int n, int n2, Rectangle2D rectangle2D) {
        return this.getCategoryStart(n, n2, rectangle2D) + this.calculateCategoryWidth(n2, rectangle2D) / 2.0;
    }

    public double getCategoryEnd(int n, int n2, Rectangle2D rectangle2D) {
        return this.getCategoryStart(n, n2, rectangle2D) + this.calculateCategoryWidth(n2, rectangle2D);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (!this.isVisible()) {
            return;
        }
        double d = 0.0;
        d = n == 0 ? rectangle2D.getMinY() : rectangle2D.getMaxY();
        d = this.drawHorizontalLabel(this.getLabel(), graphics2D, rectangle2D, rectangle2D2, n, d);
        if (this.isTickLabelsVisible()) {
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getTickLabelPaint());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D2, n);
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick[] tickArray;
                Object e = iterator.next();
                if (e instanceof Tick) {
                    tickArray = (Tick[])e;
                    if (this.verticalCategoryLabels) {
                        RefineryUtilities.drawRotatedString((String)tickArray.getText(), (Graphics2D)graphics2D, (float)tickArray.getX(), (float)tickArray.getY(), (double)-1.5707963267948966);
                        continue;
                    }
                    graphics2D.drawString(tickArray.getText(), tickArray.getX(), tickArray.getY());
                    continue;
                }
                tickArray = (Tick[])e;
                int n2 = 0;
                while (n2 < tickArray.length) {
                    graphics2D.drawString(tickArray[n2].getText(), tickArray[n2].getX(), tickArray[n2].getY());
                    ++n2;
                }
            }
        }
    }

    public void refreshTicks(Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        this.tickHeight = 1;
        this.getTicks().clear();
        CategoryPlot categoryPlot = (CategoryPlot)this.getPlot();
        CategoryDataset categoryDataset = categoryPlot.getCategoryDataset();
        if (categoryDataset != null) {
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Font font = this.getTickLabelFont();
            graphics2D.setFont(font);
            int n2 = 0;
            int n3 = 0;
            float f = (float)((rectangle2D2.getWidth() + rectangle2D2.getX()) / (double)categoryDataset.getColumnCount()) * 0.9f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            Iterator iterator = categoryDataset.getColumnKeys().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (n2 != 0) {
                    ++n3;
                    --n2;
                    continue;
                }
                String string = e.toString();
                Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
                LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
                float f4 = (float)this.getCategoryMiddle(n3, categoryDataset.getColumnCount(), rectangle2D2);
                if (this.verticalCategoryLabels) {
                    f2 = (float)((double)f4 + rectangle2D3.getHeight() / 2.0 - (double)lineMetrics.getDescent());
                    f3 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - rectangle2D3.getWidth()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + rectangle2D3.getWidth());
                    this.getTicks().add(new Tick(e, string, f2, f3));
                    if (this.skipCategoryLabelsToFit) {
                        n2 = (int)((rectangle2D3.getHeight() - (double)(f / 2.0f)) / (double)f) + 1;
                    }
                } else if (rectangle2D3.getWidth() > (double)f) {
                    if (this.skipCategoryLabelsToFit) {
                        f2 = f4 - f / 2.0f;
                        f3 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                        this.getTicks().add(new Tick(e, string, f2, f3));
                        n2 = (int)((rectangle2D3.getWidth() - (double)(f / 2.0f)) / (double)f) + 1;
                    } else {
                        String[] stringArray = this.breakLine(string, (int)f, fontRenderContext);
                        Tick[] tickArray = new Tick[stringArray.length];
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            rectangle2D3 = font.getStringBounds(stringArray[n4], fontRenderContext);
                            f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                            f3 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)((float)(n4 + 1) * (lineMetrics.getHeight() - lineMetrics.getDescent())));
                            tickArray[n4] = new Tick(e, stringArray[n4], f2, f3);
                            ++n4;
                        }
                        if (stringArray.length > this.tickHeight) {
                            this.tickHeight = stringArray.length;
                        }
                        this.getTicks().add(tickArray);
                    }
                } else {
                    f2 = (float)((double)f4 - rectangle2D3.getWidth() / 2.0);
                    f3 = n == 0 ? (float)(rectangle2D2.getMinY() - (double)this.getTickLabelInsets().bottom - (double)lineMetrics.getLeading() - (double)lineMetrics.getDescent()) : (float)(rectangle2D2.getMaxY() + (double)this.getTickLabelInsets().top + (double)lineMetrics.getHeight() - (double)lineMetrics.getDescent());
                    this.getTicks().add(new Tick(e, string, f2, f3));
                }
                ++n3;
            }
        }
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n) {
        if (!this.isVisible()) {
            return 0.0;
        }
        double d = 0.0;
        String string = this.getLabel();
        if (string != null) {
            Rectangle2D rectangle2D2 = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d = (double)(insets.top + insets.bottom) + rectangle2D2.getHeight();
        }
        double d2 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            Insets insets = this.getTickLabelInsets();
            d2 = (double)(insets.top + insets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return d + d2;
    }

    public double reserveHeight(Graphics2D graphics2D, Plot plot, Rectangle2D rectangle2D, int n, double d, int n2) {
        if (!this.isVisible()) {
            return 0.0;
        }
        double d2 = 0.0;
        String string = this.getLabel();
        if (string != null) {
            Rectangle2D rectangle2D2 = this.getLabelFont().getStringBounds(string, graphics2D.getFontRenderContext());
            Insets insets = this.getLabelInsets();
            d2 = (double)(insets.top + insets.bottom) + rectangle2D2.getHeight();
        }
        double d3 = 0.0;
        if (this.isTickLabelsVisible()) {
            graphics2D.setFont(this.getTickLabelFont());
            this.refreshTicks(graphics2D, rectangle2D, rectangle2D, n);
            Insets insets = this.getTickLabelInsets();
            d3 = (double)(insets.top + insets.bottom) + this.getMaxTickLabelHeight(graphics2D, rectangle2D, this.verticalCategoryLabels);
        }
        return d2 + d3;
    }

    private double getMaxTickLabelHeight(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl) {
        Font font = this.getTickLabelFont();
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d = 0.0;
        if (bl) {
            Iterator iterator = this.getTicks().iterator();
            while (iterator.hasNext()) {
                Tick tick = (Tick)iterator.next();
                Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
            }
        } else {
            LineMetrics lineMetrics = font.getLineMetrics("Sample", fontRenderContext);
            d = lineMetrics.getHeight() * (float)this.tickHeight - lineMetrics.getDescent() * (float)(this.tickHeight - 1);
        }
        return d;
    }

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.getTicks().iterator();
        while (iterator.hasNext()) {
            Tick[] tickArray;
            Object e = iterator.next();
            if (e instanceof Tick) {
                tickArray = (Tick[])e;
                Rectangle2D rectangle2D2 = font.getStringBounds(tickArray.getText(), fontRenderContext);
                if (!(rectangle2D2.getWidth() > d)) continue;
                d = rectangle2D2.getWidth();
                continue;
            }
            tickArray = (Tick[])e;
            int n = 0;
            while (n < tickArray.length) {
                Rectangle2D rectangle2D3 = font.getStringBounds(tickArray[n].getText(), fontRenderContext);
                if (rectangle2D3.getWidth() > d) {
                    d = rectangle2D3.getWidth();
                }
                ++n;
            }
        }
        return d;
    }

    protected boolean isCompatiblePlot(Plot plot) {
        return plot instanceof VerticalCategoryPlot;
    }

    public void configure() {
    }

    private String[] breakLine(String string, int n, FontRenderContext fontRenderContext) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>(5);
        int n2 = n;
        AttributedString attributedString = new AttributedString(string, this.getTickLabelFont().getAttributes());
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        AffineTransform affineTransform = new AffineTransform();
        while (true) {
            stringArray = new LineBreakMeasurer(attributedCharacterIterator, fontRenderContext);
            int n3 = 0;
            int n4 = 0;
            TextLayout textLayout = stringArray.nextLayout(n2);
            while (textLayout != null) {
                arrayList.add(string.substring(n4, n4 + textLayout.getCharacterCount()));
                int n5 = textLayout.getOutline((AffineTransform)affineTransform).getBounds().width;
                if (n3 < n5) {
                    n3 = n5;
                }
                n4 += textLayout.getCharacterCount();
                textLayout = stringArray.nextLayout(n2);
            }
            if (n3 <= n || (n2 -= n3 - n2) <= 0) break;
            arrayList.clear();
        }
        stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private double calculateCategoryWidth(int n, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (n > 1) {
            d = rectangle2D.getWidth() * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            d /= (double)n;
        } else {
            d = rectangle2D.getWidth() * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return d;
    }

    private double calculateCategoryGapWidth(int n, Rectangle2D rectangle2D) {
        double d = 0.0;
        if (n > 1) {
            d = rectangle2D.getWidth() * this.getCategoryMargin() / (double)(n - 1);
        }
        return d;
    }
}

