/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart.axis;

import com.jrefinery.chart.axis.AxisConstants;
import com.jrefinery.chart.axis.Tick;
import com.jrefinery.chart.event.AxisChangeEvent;
import com.jrefinery.chart.event.AxisChangeListener;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.PlotNotCompatibleException;
import com.jrefinery.ui.RefineryUtilities;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class Axis
implements AxisConstants {
    private boolean visible;
    private String label;
    private Font labelFont;
    private Paint labelPaint;
    private Insets labelInsets;
    private boolean tickLabelsVisible;
    private Font tickLabelFont;
    private Paint tickLabelPaint;
    private Insets tickLabelInsets;
    private boolean tickMarksVisible;
    private float tickMarkInsideLength;
    private float tickMarkOutsideLength;
    private Stroke tickMarkStroke;
    private Paint tickMarkPaint;
    private List ticks;
    private Plot plot;
    private double fixedDimension;
    private EventListenerList listenerList;
    static /* synthetic */ Class class$com$jrefinery$chart$event$AxisChangeListener;

    protected Axis(String string) {
        this.label = string;
        this.visible = true;
        this.labelFont = AxisConstants.DEFAULT_AXIS_LABEL_FONT;
        this.labelPaint = AxisConstants.DEFAULT_AXIS_LABEL_PAINT;
        this.labelInsets = AxisConstants.DEFAULT_AXIS_LABEL_INSETS;
        this.tickLabelsVisible = true;
        this.tickLabelFont = AxisConstants.DEFAULT_TICK_LABEL_FONT;
        this.tickLabelPaint = AxisConstants.DEFAULT_TICK_LABEL_PAINT;
        this.tickLabelInsets = AxisConstants.DEFAULT_TICK_LABEL_INSETS;
        this.tickMarksVisible = true;
        this.tickMarkStroke = AxisConstants.DEFAULT_TICK_MARK_STROKE;
        this.tickMarkPaint = AxisConstants.DEFAULT_TICK_MARK_PAINT;
        this.tickMarkInsideLength = 0.0f;
        this.tickMarkOutsideLength = 2.0f;
        this.plot = null;
        this.ticks = new ArrayList();
        this.listenerList = new EventListenerList();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible) {
            this.visible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        String string2 = this.label;
        if (string2 != null) {
            if (!string2.equals(string)) {
                this.label = string;
                this.notifyListeners(new AxisChangeEvent(this));
            }
        } else if (string != null) {
            this.label = string;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setLabelFont(...): null not permitted.");
        }
        if (!this.labelFont.equals(font)) {
            this.labelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setLabelPaint(...): null not permitted.");
        }
        if (!this.labelPaint.equals(paint)) {
            this.labelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getLabelInsets() {
        return this.labelInsets;
    }

    public void setLabelInsets(Insets insets) {
        if (!insets.equals(this.labelInsets)) {
            this.labelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickLabelsVisible() {
        return this.tickLabelsVisible;
    }

    public void setTickLabelsVisible(boolean bl) {
        if (bl != this.tickLabelsVisible) {
            this.tickLabelsVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Font getTickLabelFont() {
        return this.tickLabelFont;
    }

    public void setTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Axis.setTickLabelFont(...): null not permitted.");
        }
        if (!this.tickLabelFont.equals(font)) {
            this.tickLabelFont = font;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickLabelPaint() {
        return this.tickLabelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickLabelPaint(...): null not permitted.");
        }
        if (!this.tickLabelPaint.equals(paint)) {
            this.tickLabelPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Insets getTickLabelInsets() {
        return this.tickLabelInsets;
    }

    public void setTickLabelInsets(Insets insets) {
        if (insets == null) {
            throw new IllegalArgumentException("Axis.setTickLabelInsets(...): null not permitted.");
        }
        if (!this.tickLabelInsets.equals(insets)) {
            this.tickLabelInsets = insets;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public boolean isTickMarksVisible() {
        return this.tickMarksVisible;
    }

    public void setTickMarksVisible(boolean bl) {
        if (bl != this.tickMarksVisible) {
            this.tickMarksVisible = bl;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public float getTickMarkInsideLength() {
        return this.tickMarkInsideLength;
    }

    public void setTickMarkInsideLength(float f) {
        this.tickMarkInsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getTickMarkOutsideLength() {
        return this.tickMarkOutsideLength;
    }

    public void setTickMarkOutsideLength(float f) {
        this.tickMarkOutsideLength = f;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public Stroke getTickMarkStroke() {
        return this.tickMarkStroke;
    }

    public void setTickMarkStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Axis.setTickMarkStroke(...): null not permitted.");
        }
        if (!this.tickMarkStroke.equals(stroke)) {
            this.tickMarkStroke = stroke;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public Paint getTickMarkPaint() {
        return this.tickMarkPaint;
    }

    public void setTickMarkPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Axis.setTickMarkPaint(...): null not permitted.");
        }
        if (!this.tickMarkPaint.equals(paint)) {
            this.tickMarkPaint = paint;
            this.notifyListeners(new AxisChangeEvent(this));
        }
    }

    public List getTicks() {
        return this.ticks;
    }

    public Plot getPlot() {
        return this.plot;
    }

    public void setPlot(Plot plot) throws PlotNotCompatibleException {
        if (!this.isCompatiblePlot(plot) && plot != null) {
            throw new PlotNotCompatibleException("Axis.setPlot(...): plot not compatible with axis.");
        }
        this.plot = plot;
        this.configure();
    }

    public double getFixedDimension() {
        return this.fixedDimension;
    }

    public void setFixedDimension(double d) {
        this.fixedDimension = d;
    }

    public abstract void draw(Graphics2D var1, Rectangle2D var2, Rectangle2D var3, int var4);

    public abstract void refreshTicks(Graphics2D var1, Rectangle2D var2, Rectangle2D var3, int var4);

    public abstract void configure();

    protected double getMaxTickLabelWidth(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        Font font = this.getTickLabelFont();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Iterator iterator = this.ticks.iterator();
        while (iterator.hasNext()) {
            Tick tick = (Tick)iterator.next();
            Rectangle2D rectangle2D2 = font.getStringBounds(tick.getText(), fontRenderContext);
            if (!(rectangle2D2.getWidth() > d)) continue;
            d = rectangle2D2.getWidth();
        }
        return d;
    }

    protected abstract boolean isCompatiblePlot(Plot var1);

    public void addChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.add(class$com$jrefinery$chart$event$AxisChangeListener == null ? (class$com$jrefinery$chart$event$AxisChangeListener = Axis.class$("com.jrefinery.chart.event.AxisChangeListener")) : class$com$jrefinery$chart$event$AxisChangeListener, axisChangeListener);
    }

    public void removeChangeListener(AxisChangeListener axisChangeListener) {
        this.listenerList.remove(class$com$jrefinery$chart$event$AxisChangeListener == null ? (class$com$jrefinery$chart$event$AxisChangeListener = Axis.class$("com.jrefinery.chart.event.AxisChangeListener")) : class$com$jrefinery$chart$event$AxisChangeListener, axisChangeListener);
    }

    protected void notifyListeners(AxisChangeEvent axisChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$jrefinery$chart$event$AxisChangeListener == null ? Axis.class$("com.jrefinery.chart.event.AxisChangeListener") : class$com$jrefinery$chart$event$AxisChangeListener)) {
                ((AxisChangeListener)objectArray[n + 1]).axisChanged(axisChangeEvent);
            }
            n -= 2;
        }
    }

    protected double drawHorizontalLabel(String string, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n, double d) {
        if (string != null) {
            Font font = this.getLabelFont();
            Insets insets = this.getLabelInsets();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getLabelPaint());
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            Rectangle2D rectangle2D3 = font.getStringBounds(string, fontRenderContext);
            LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
            d = n == 0 ? d + (double)insets.top + (double)lineMetrics.getAscent() : d - (double)insets.bottom - (double)lineMetrics.getDescent() - (double)lineMetrics.getLeading();
            float f = (float)(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - rectangle2D3.getWidth() / 2.0);
            float f2 = (float)d;
            graphics2D.drawString(string, f, f2);
            d = n == 0 ? d + (double)lineMetrics.getDescent() + (double)lineMetrics.getLeading() + (double)insets.bottom : d - (double)insets.top - (double)lineMetrics.getAscent();
        }
        return d;
    }

    protected void drawVerticalLabel(String string, boolean bl, Graphics2D graphics2D, Rectangle2D rectangle2D, Rectangle2D rectangle2D2, int n) {
        if (string != null && !string.equals("")) {
            Font font = this.getLabelFont();
            Insets insets = this.getLabelInsets();
            graphics2D.setFont(font);
            graphics2D.setPaint(this.getLabelPaint());
            Rectangle2D rectangle2D3 = font.getStringBounds(string, graphics2D.getFontRenderContext());
            if (n == 3) {
                if (bl) {
                    double d = rectangle2D.getX() + (double)insets.left + rectangle2D3.getHeight();
                    double d2 = rectangle2D.getY() + rectangle2D2.getHeight() / 2.0 + rectangle2D3.getWidth() / 2.0;
                    RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d), (float)((float)d2), (double)-1.5707963267948966);
                } else {
                    double d = rectangle2D.getX() + (double)insets.left;
                    double d3 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - rectangle2D3.getHeight() / 2.0;
                    graphics2D.drawString(string, (float)d, (float)d3);
                }
            } else if (bl) {
                double d = rectangle2D.getMaxX() - (double)insets.right - rectangle2D3.getHeight();
                double d4 = rectangle2D.getMinY() + rectangle2D2.getHeight() / 2.0 - rectangle2D3.getWidth() / 2.0;
                RefineryUtilities.drawRotatedString((String)string, (Graphics2D)graphics2D, (float)((float)d), (float)((float)d4), (double)1.5707963267948966);
            } else {
                double d = rectangle2D.getMaxX() - (double)insets.right - rectangle2D3.getWidth();
                double d5 = rectangle2D.getMinY() + rectangle2D.getHeight() / 2.0 + rectangle2D3.getHeight() / 2.0;
                graphics2D.drawString(string, (float)d, (float)d5);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

