/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.DrawableLegendItem;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.LegendItem;
import com.jrefinery.chart.LegendItemCollection;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.LegendChangeEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class StandardLegend
extends Legend {
    public static final Spacer DEFAULT_OUTER_GAP = new Spacer(1, 3.0, 3.0, 3.0, 3.0);
    public static final Spacer DEFAULT_INNER_GAP = new Spacer(1, 2.0, 2.0, 2.0, 2.0);
    public static final Stroke DEFAULT_OUTLINE_STROKE = new BasicStroke();
    public static final Paint DEFAULT_OUTLINE_PAINT = Color.gray;
    public static final Paint DEFAULT_BACKGROUND_PAINT = Color.white;
    public static final Font DEFAULT_TITLE_FONT = new Font("SansSerif", 1, 11);
    public static final Font DEFAULT_ITEM_FONT = new Font("SansSerif", 0, 10);
    private Spacer outerGap;
    private Stroke outlineStroke;
    private Paint outlinePaint;
    private Paint backgroundPaint;
    private Spacer innerGap;
    private String title = null;
    private Font titleFont;
    private Font itemFont;
    private Paint itemPaint;
    private boolean outlineShapes;
    private Stroke shapeOutlineStroke = new BasicStroke(0.5f);
    private Paint shapeOutlinePaint = Color.lightGray;
    private boolean displaySeriesShapes = false;

    public StandardLegend(JFreeChart jFreeChart) {
        super(jFreeChart);
        this.outerGap = DEFAULT_OUTER_GAP;
        this.innerGap = DEFAULT_INNER_GAP;
        this.backgroundPaint = DEFAULT_BACKGROUND_PAINT;
        this.outlineStroke = DEFAULT_OUTLINE_STROKE;
        this.outlinePaint = DEFAULT_OUTLINE_PAINT;
        this.titleFont = DEFAULT_TITLE_FONT;
        this.itemFont = DEFAULT_ITEM_FONT;
        this.itemPaint = Color.black;
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        this.backgroundPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Spacer getOuterGap() {
        return this.outerGap;
    }

    public boolean getOutlineShapes() {
        return this.outlineShapes;
    }

    public void setOutlineShapes(boolean bl) {
        this.outlineShapes = bl;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getOutlineStroke() {
        return this.outlineStroke;
    }

    public void setOutlineStroke(Stroke stroke) {
        this.outlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getOutlinePaint() {
        return this.outlinePaint;
    }

    public void setOutlinePaint(Paint paint) {
        this.outlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Font getItemFont() {
        return this.itemFont;
    }

    public void setItemFont(Font font) {
        this.itemFont = font;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getItemPaint() {
        return this.itemPaint;
    }

    public void setItemPaint(Paint paint) {
        this.itemPaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Stroke getShapeOutlineStroke() {
        return this.shapeOutlineStroke;
    }

    public void setShapeOutlineStroke(Stroke stroke) {
        this.shapeOutlineStroke = stroke;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Paint getShapeOutlinePaint() {
        return this.shapeOutlinePaint;
    }

    public void setShapeOutlinePaint(Paint paint) {
        this.shapeOutlinePaint = paint;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public void setDisplaySeriesShapes(boolean bl) {
        this.displaySeriesShapes = bl;
        this.notifyListeners(new LegendChangeEvent(this));
    }

    public Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        return this.draw(graphics2D, rectangle2D, (this.getAnchor() & 1) != 0, (this.getAnchor() & 2) != 0);
    }

    protected Rectangle2D draw(Graphics2D graphics2D, Rectangle2D rectangle2D, boolean bl, boolean bl2) {
        LegendItemCollection legendItemCollection = this.getChart().getPlot().getLegendItems();
        if (legendItemCollection != null && legendItemCollection.getItemCount() > 0) {
            double d;
            double d2;
            DrawableLegendItem drawableLegendItem = null;
            Rectangle2D rectangle2D2 = new Rectangle2D.Double();
            double d3 = rectangle2D.getWidth();
            double d4 = rectangle2D.getHeight();
            Point2D.Double double_ = new Point2D.Double();
            DrawableLegendItem[] drawableLegendItemArray = new DrawableLegendItem[legendItemCollection.getItemCount()];
            if (bl) {
                d2 = rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                d = rectangle2D.getMaxX() + this.getOuterGap().getRightSpace(d3) - 1.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                double d8 = 0.0;
                boolean bl3 = true;
                if (this.title != null && !this.title.equals("")) {
                    graphics2D.setFont(this.getTitleFont());
                    LegendItem legendItem = new LegendItem(this.title, this.title, null, Color.black, DEFAULT_OUTLINE_PAINT, DEFAULT_OUTLINE_STROKE);
                    drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, d6, d8);
                    d7 = Math.max(d7, drawableLegendItem.getHeight());
                    d6 += drawableLegendItem.getWidth();
                }
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < legendItemCollection.getItemCount()) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), d6, d8);
                    if (!bl3 && drawableLegendItemArray[n].getX() + drawableLegendItemArray[n].getWidth() + d2 > d) {
                        d5 = Math.max(d5, d6);
                        d6 = 0.0;
                        d8 += d7;
                        --n;
                        bl3 = true;
                    } else {
                        d7 = Math.max(d7, drawableLegendItemArray[n].getHeight());
                        d6 += drawableLegendItemArray[n].getWidth();
                        bl3 = false;
                    }
                    ++n;
                }
                d5 = Math.max(d5, d6);
                rectangle2D2 = new Rectangle2D.Double(0.0, 0.0, d5, d8 += d7);
                double d9 = bl2 ? rectangle2D.getMaxY() - d8 - this.getOuterGap().getBottomSpace(d4) : rectangle2D.getY() + this.getOuterGap().getTopSpace(d4);
                double d10 = rectangle2D.getX() + rectangle2D.getWidth() / 2.0 - d5 / 2.0;
                double_ = new Point2D.Double(d10, d9);
            } else {
                d2 = 0.0;
                d = 0.0;
                if (this.title != null && !this.title.equals("")) {
                    graphics2D.setFont(this.getTitleFont());
                    LegendItem legendItem = new LegendItem(this.title, this.title, null, Color.black, DEFAULT_OUTLINE_PAINT, DEFAULT_OUTLINE_STROKE);
                    drawableLegendItem = this.createDrawableLegendItem(graphics2D, legendItem, 0.0, d2);
                    d2 += drawableLegendItem.getHeight();
                    d = Math.max(d, drawableLegendItem.getWidth());
                }
                graphics2D.setFont(this.itemFont);
                int n = 0;
                while (n < drawableLegendItemArray.length) {
                    drawableLegendItemArray[n] = this.createDrawableLegendItem(graphics2D, legendItemCollection.get(n), 0.0, d2);
                    d2 += drawableLegendItemArray[n].getHeight();
                    d = Math.max(d, drawableLegendItemArray[n].getWidth());
                    ++n;
                }
                rectangle2D2 = new Rectangle2D.Float(0.0f, 0.0f, (float)d, (float)d2);
                double d11 = bl2 ? rectangle2D.getMaxX() - d - this.getOuterGap().getRightSpace(d3) : rectangle2D.getX() + this.getOuterGap().getLeftSpace(d3);
                double d12 = rectangle2D.getY() + rectangle2D.getHeight() / 2.0 - d2 / 2.0;
                double_ = new Point2D.Double(d11, d12);
            }
            graphics2D.translate(((Point2D)double_).getX(), ((Point2D)double_).getY());
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D2);
            graphics2D.setPaint(this.outlinePaint);
            graphics2D.setStroke(this.outlineStroke);
            graphics2D.draw(rectangle2D2);
            if (drawableLegendItem != null) {
                graphics2D.setPaint(drawableLegendItem.getItem().getPaint());
                graphics2D.setPaint(this.itemPaint);
                graphics2D.setFont(this.getTitleFont());
                graphics2D.drawString(drawableLegendItem.getItem().getLabel(), (float)drawableLegendItem.getLabelPosition().getX(), (float)drawableLegendItem.getLabelPosition().getY());
            }
            int n = 0;
            while (n < drawableLegendItemArray.length) {
                graphics2D.setPaint(drawableLegendItemArray[n].getItem().getPaint());
                Shape shape = drawableLegendItemArray[n].getMarker();
                graphics2D.fill(shape);
                if (this.getOutlineShapes()) {
                    graphics2D.setPaint(this.shapeOutlinePaint);
                    graphics2D.setStroke(this.shapeOutlineStroke);
                    graphics2D.draw(shape);
                }
                graphics2D.setPaint(this.itemPaint);
                graphics2D.setFont(this.itemFont);
                graphics2D.drawString(drawableLegendItemArray[n].getItem().getLabel(), (float)drawableLegendItemArray[n].getLabelPosition().getX(), (float)drawableLegendItemArray[n].getLabelPosition().getY());
                ++n;
            }
            graphics2D.translate(-((Point2D)double_).getX(), -((Point2D)double_).getY());
            if (bl) {
                double d13 = rectangle2D.getY();
                double d14 = bl2 ? d13 : d13 + rectangle2D2.getHeight() + this.getOuterGap().getBottomSpace(d4);
                return new Rectangle2D.Double(rectangle2D.getX(), d14, d3, d4 - rectangle2D2.getHeight() - this.getOuterGap().getTopSpace(d4) - this.getOuterGap().getBottomSpace(d4));
            }
            double d15 = bl2 ? rectangle2D.getX() : rectangle2D.getX() + rectangle2D2.getWidth() + this.getOuterGap().getLeftSpace(d3) + this.getOuterGap().getRightSpace(d3);
            return new Rectangle2D.Double(d15, rectangle2D.getY(), d3 - rectangle2D2.getWidth() - this.getOuterGap().getLeftSpace(d3) - this.getOuterGap().getRightSpace(d3), d4);
        }
        return rectangle2D;
    }

    private Rectangle2D getLegendBox(int n, int n2, float f, Rectangle2D rectangle2D) {
        int n3 = 2;
        float f2 = f * 0.7f;
        float f3 = (float)rectangle2D.getX() + (float)n3 + 0.15f * f;
        float f4 = (float)rectangle2D.getY() + (float)n3 + ((float)n + 0.15f) * f;
        return new Rectangle2D.Float(f3, f4, f2, f2);
    }

    private DrawableLegendItem createDrawableLegendItem(Graphics2D graphics2D, LegendItem legendItem, double d, double d2) {
        int n = 2;
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        LineMetrics lineMetrics = fontMetrics.getLineMetrics(legendItem.getLabel(), graphics2D);
        float f = lineMetrics.getAscent();
        float f2 = f + lineMetrics.getDescent() + lineMetrics.getLeading();
        DrawableLegendItem drawableLegendItem = new DrawableLegendItem(legendItem);
        float f3 = (float)(d + (double)n + (double)(1.15f * f2));
        float f4 = (float)(d2 + (double)n + (double)(0.15f * f2) + (double)f);
        drawableLegendItem.setLabelPosition(new Point2D.Float(f3, f4));
        float f5 = f2 * 0.7f;
        f3 = (float)(d + (double)n + (double)(0.15f * f2));
        f4 = (float)(d2 + (double)n + (double)(0.15f * f2));
        if (this.displaySeriesShapes) {
            Shape shape = legendItem.getShape();
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(f3 + f5 / 2.0f, f4 + f5 / 2.0f);
            shape = affineTransform.createTransformedShape(shape);
            drawableLegendItem.setMarker(shape);
        } else {
            drawableLegendItem.setMarker(new Rectangle2D.Float(f3, f4, f5, f5));
        }
        float f6 = (float)(drawableLegendItem.getLabelPosition().getX() - d + fontMetrics.getStringBounds(legendItem.getLabel(), graphics2D).getWidth() + 0.5 * (double)f);
        float f7 = (float)(2 * n) + f2;
        drawableLegendItem.setBounds(d, d2, f6, f7);
        return drawableLegendItem;
    }
}

