/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.StandardLegend;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import javax.swing.event.EventListenerList;

public abstract class Legend {
    public static final int WEST = 0;
    public static final int NORTH = 1;
    public static final int EAST = 2;
    public static final int SOUTH = 3;
    protected static final int INVERTED = 2;
    protected static final int HORIZONTAL = 1;
    private int anchor = 3;
    private JFreeChart chart;
    private EventListenerList listenerList;
    static /* synthetic */ Class class$com$jrefinery$chart$event$LegendChangeListener;

    public static Legend createInstance(JFreeChart jFreeChart) {
        return new StandardLegend(jFreeChart);
    }

    protected Legend(JFreeChart jFreeChart) {
        this.chart = jFreeChart;
        this.listenerList = new EventListenerList();
    }

    public JFreeChart getChart() {
        return this.chart;
    }

    public abstract Rectangle2D draw(Graphics2D var1, Rectangle2D var2);

    public void addChangeListener(LegendChangeListener legendChangeListener) {
        this.listenerList.add(class$com$jrefinery$chart$event$LegendChangeListener == null ? (class$com$jrefinery$chart$event$LegendChangeListener = Legend.class$("com.jrefinery.chart.event.LegendChangeListener")) : class$com$jrefinery$chart$event$LegendChangeListener, legendChangeListener);
    }

    public void removeChangeListener(LegendChangeListener legendChangeListener) {
        this.listenerList.remove(class$com$jrefinery$chart$event$LegendChangeListener == null ? (class$com$jrefinery$chart$event$LegendChangeListener = Legend.class$("com.jrefinery.chart.event.LegendChangeListener")) : class$com$jrefinery$chart$event$LegendChangeListener, legendChangeListener);
    }

    protected void notifyListeners(LegendChangeEvent legendChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$jrefinery$chart$event$LegendChangeListener == null ? Legend.class$("com.jrefinery.chart.event.LegendChangeListener") : class$com$jrefinery$chart$event$LegendChangeListener)) {
                ((LegendChangeListener)objectArray[n + 1]).legendChanged(legendChangeEvent);
            }
            n -= 2;
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void setAnchor(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.anchor = n;
                this.notifyListeners(new LegendChangeEvent(this));
                break;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

