/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.ChartRenderingInfo;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.JFreeChartInfo;
import com.jrefinery.chart.Legend;
import com.jrefinery.chart.TextTitle;
import com.jrefinery.chart.event.ChartChangeEvent;
import com.jrefinery.chart.event.ChartChangeListener;
import com.jrefinery.chart.event.ChartProgressEvent;
import com.jrefinery.chart.event.ChartProgressListener;
import com.jrefinery.chart.event.LegendChangeEvent;
import com.jrefinery.chart.event.LegendChangeListener;
import com.jrefinery.chart.event.PlotChangeEvent;
import com.jrefinery.chart.event.PlotChangeListener;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.chart.event.TitleChangeListener;
import com.jrefinery.chart.plot.CategoryPlot;
import com.jrefinery.chart.plot.Plot;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.ui.Align;
import com.jrefinery.ui.Drawable;
import com.jrefinery.ui.about.ProjectInfo;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.EventListenerList;

public class JFreeChart
implements JFreeChartConstants,
Drawable,
TitleChangeListener,
LegendChangeListener,
PlotChangeListener {
    public static final ProjectInfo INFO = new JFreeChartInfo();
    private TextTitle title;
    private List subtitles;
    private Legend legend;
    private Plot plot;
    private boolean antialias;
    private Paint backgroundPaint;
    private Image backgroundImage;
    private int backgroundImageAlignment = 15;
    private float backgroundImageAlpha = 0.5f;
    private EventListenerList listenerList = new EventListenerList();
    private boolean suppressChartChangeEvents = false;
    static /* synthetic */ Class class$com$jrefinery$chart$event$ChartChangeListener;
    static /* synthetic */ Class class$com$jrefinery$chart$event$ChartProgressListener;

    public JFreeChart(Plot plot) {
        this(null, null, plot, false);
    }

    public JFreeChart(String string, Plot plot) {
        this(string, JFreeChartConstants.DEFAULT_TITLE_FONT, plot, true);
    }

    public JFreeChart(String string, Font font, Plot plot, boolean bl) {
        this.plot = plot;
        plot.addChangeListener(this);
        this.subtitles = new ArrayList();
        if (bl) {
            this.legend = Legend.createInstance(this);
            this.legend.addChangeListener(this);
        }
        if (string != null) {
            if (font == null) {
                font = JFreeChartConstants.DEFAULT_TITLE_FONT;
            }
            this.title = new TextTitle(string, font);
            this.title.addChangeListener(this);
        }
        this.antialias = true;
        this.backgroundPaint = JFreeChartConstants.DEFAULT_BACKGROUND_PAINT;
        this.backgroundImage = JFreeChartConstants.DEFAULT_BACKGROUND_IMAGE;
        this.backgroundImageAlignment = 15;
        this.backgroundImageAlpha = 0.5f;
    }

    public TextTitle getTitle() {
        return this.title;
    }

    public void setTitle(TextTitle textTitle) {
        this.title = textTitle;
        this.fireChartChanged();
    }

    public void setTitle(String string) {
        if (string != null) {
            if (this.title == null) {
                this.setTitle(new TextTitle(string, JFreeChartConstants.DEFAULT_TITLE_FONT));
            } else {
                this.title.setText(string);
            }
        } else {
            this.setTitle((TextTitle)null);
        }
    }

    public List getSubtitles() {
        return this.subtitles;
    }

    public void setSubtitles(List list) {
        this.subtitles = list;
        this.fireChartChanged();
    }

    public int getSubtitleCount() {
        return this.subtitles.size();
    }

    public AbstractTitle getSubtitle(int n) {
        if (n < 0 || n == this.getSubtitleCount()) {
            throw new IllegalArgumentException("JFreeChart.getSubtitle(...): index out of range.");
        }
        return (AbstractTitle)this.subtitles.get(n);
    }

    public void addSubtitle(AbstractTitle abstractTitle) {
        if (abstractTitle != null) {
            this.subtitles.add(abstractTitle);
            abstractTitle.addChangeListener(this);
            this.fireChartChanged();
        }
    }

    public Legend getLegend() {
        return this.legend;
    }

    public void setLegend(Legend legend) {
        Legend legend2 = this.legend;
        if (legend2 != null) {
            legend2.removeChangeListener(this);
        }
        this.legend = legend;
        if (legend != null) {
            legend.addChangeListener(this);
        }
        this.fireChartChanged();
    }

    public Plot getPlot() {
        return this.plot;
    }

    public CategoryPlot getCategoryPlot() {
        return (CategoryPlot)this.plot;
    }

    public XYPlot getXYPlot() {
        return (XYPlot)this.plot;
    }

    public boolean getAntiAlias() {
        return this.antialias;
    }

    public void setAntiAlias(boolean bl) {
        if (this.antialias != bl) {
            this.antialias = bl;
            this.fireChartChanged();
        }
    }

    public Paint getBackgroundPaint() {
        return this.backgroundPaint;
    }

    public void setBackgroundPaint(Paint paint) {
        if (this.backgroundPaint != null) {
            if (!this.backgroundPaint.equals(paint)) {
                this.backgroundPaint = paint;
                this.fireChartChanged();
            }
        } else if (paint != null) {
            this.backgroundPaint = paint;
            this.fireChartChanged();
        }
    }

    public Image getBackgroundImage() {
        return this.backgroundImage;
    }

    public void setBackgroundImage(Image image) {
        if (this.backgroundImage != null) {
            if (!this.backgroundImage.equals(image)) {
                this.backgroundImage = image;
                this.fireChartChanged();
            }
        } else if (image != null) {
            this.backgroundImage = image;
            this.fireChartChanged();
        }
    }

    public int getBackgroundImageAlignment() {
        return this.backgroundImageAlignment;
    }

    public void setBackgroundImageAlignment(int n) {
        if (this.backgroundImageAlignment != n) {
            this.backgroundImageAlignment = n;
            this.fireChartChanged();
        }
    }

    public float getBackgroundImageAlpha() {
        return this.backgroundImageAlpha;
    }

    public void setBackgroundImageAlpha(float f) {
        if (this.backgroundImageAlpha != f) {
            this.backgroundImageAlpha = f;
            this.fireChartChanged();
        }
    }

    public boolean getSuppressChartChangeEvents() {
        return this.suppressChartChangeEvents;
    }

    public void setSuppressChartChangeEvents(boolean bl) {
        this.suppressChartChangeEvents = bl;
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        this.draw(graphics2D, rectangle2D, null);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, ChartRenderingInfo chartRenderingInfo) {
        Object object;
        Object object2;
        Object object3;
        if (chartRenderingInfo != null) {
            chartRenderingInfo.clear();
            chartRenderingInfo.setChartArea(rectangle2D);
        }
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        if (this.backgroundPaint != null) {
            graphics2D.setPaint(this.backgroundPaint);
            graphics2D.fill(rectangle2D);
        }
        if (this.backgroundImage != null) {
            object3 = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.backgroundImageAlpha));
            object2 = new Rectangle2D.Double(0.0, 0.0, this.backgroundImage.getWidth(null), this.backgroundImage.getHeight(null));
            Align.align((Rectangle2D)object2, (Rectangle2D)rectangle2D, (int)this.backgroundImageAlignment);
            graphics2D.drawImage(this.backgroundImage, (int)((RectangularShape)object2).getX(), (int)((RectangularShape)object2).getY(), (int)((RectangularShape)object2).getWidth(), (int)((RectangularShape)object2).getHeight(), null);
            graphics2D.setComposite((Composite)object3);
        }
        object3 = new Rectangle2D.Double();
        ((Rectangle2D)object3).setRect(rectangle2D);
        if (this.title != null) {
            this.drawTitle(this.title, graphics2D, (Rectangle2D)object3);
        }
        object2 = this.subtitles.iterator();
        while (object2.hasNext()) {
            object = (AbstractTitle)object2.next();
            this.drawTitle((AbstractTitle)object, graphics2D, (Rectangle2D)object3);
        }
        object = object3;
        if (this.legend != null) {
            ((Rectangle2D)object).setRect(this.legend.draw(graphics2D, (Rectangle2D)object3));
        }
        this.plot.draw(graphics2D, (Rectangle2D)object, chartRenderingInfo);
        graphics2D.setClip(shape);
    }

    public void drawTitle(AbstractTitle abstractTitle, Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        switch (abstractTitle.getPosition()) {
            case 0: {
                double d = Math.min(abstractTitle.getPreferredHeight(graphics2D), rectangle2D.getHeight());
                double d2 = rectangle2D.getWidth();
                ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getY(), d2, d);
                abstractTitle.draw(graphics2D, double_);
                rectangle2D.setRect(rectangle2D.getX(), Math.min(rectangle2D.getY() + d, rectangle2D.getMaxY()), d2, Math.max(rectangle2D.getHeight() - d, 0.0));
                break;
            }
            case 1: {
                double d = Math.min(abstractTitle.getPreferredHeight(graphics2D), rectangle2D.getHeight());
                double d3 = rectangle2D.getWidth();
                ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getMaxY() - d, d3, d);
                abstractTitle.draw(graphics2D, double_);
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), d3, rectangle2D.getHeight() - d);
                break;
            }
            case 2: {
                double d = rectangle2D.getHeight();
                double d4 = Math.min(abstractTitle.getPreferredWidth(graphics2D), rectangle2D.getWidth());
                ((Rectangle2D)double_).setRect(rectangle2D.getMaxX() - d4, rectangle2D.getY(), d4, d);
                abstractTitle.draw(graphics2D, double_);
                rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() - d4, d);
                break;
            }
            case 3: {
                double d = rectangle2D.getHeight();
                double d5 = Math.min(abstractTitle.getPreferredWidth(graphics2D), rectangle2D.getWidth());
                ((Rectangle2D)double_).setRect(rectangle2D.getX(), rectangle2D.getY(), d5, d);
                abstractTitle.draw(graphics2D, double_);
                rectangle2D.setRect(rectangle2D.getX() + d5, rectangle2D.getY(), rectangle2D.getWidth() - d5, d);
                break;
            }
            default: {
                throw new RuntimeException("JFreeChart.draw(...): unknown title position.");
            }
        }
    }

    public BufferedImage createBufferedImage(int n, int n2) {
        return this.createBufferedImage(n, n2, null);
    }

    public BufferedImage createBufferedImage(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        this.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, n, n2), chartRenderingInfo);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void handleClick(int n, int n2, ChartRenderingInfo chartRenderingInfo) {
        this.plot.handleClick(n, n2, chartRenderingInfo);
    }

    public void addChangeListener(ChartChangeListener chartChangeListener) {
        this.listenerList.add(class$com$jrefinery$chart$event$ChartChangeListener == null ? (class$com$jrefinery$chart$event$ChartChangeListener = JFreeChart.class$("com.jrefinery.chart.event.ChartChangeListener")) : class$com$jrefinery$chart$event$ChartChangeListener, chartChangeListener);
    }

    public void removeChangeListener(ChartChangeListener chartChangeListener) {
        this.listenerList.remove(class$com$jrefinery$chart$event$ChartChangeListener == null ? (class$com$jrefinery$chart$event$ChartChangeListener = JFreeChart.class$("com.jrefinery.chart.event.ChartChangeListener")) : class$com$jrefinery$chart$event$ChartChangeListener, chartChangeListener);
    }

    protected void fireChartChanged() {
        ChartChangeEvent chartChangeEvent = new ChartChangeEvent(this);
        this.notifyListeners(chartChangeEvent);
    }

    protected void notifyListeners(ChartChangeEvent chartChangeEvent) {
        if (!this.suppressChartChangeEvents) {
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$com$jrefinery$chart$event$ChartChangeListener == null ? JFreeChart.class$("com.jrefinery.chart.event.ChartChangeListener") : class$com$jrefinery$chart$event$ChartChangeListener)) {
                    ((ChartChangeListener)objectArray[n + 1]).chartChanged(chartChangeEvent);
                }
                n -= 2;
            }
        }
    }

    public void addProgressListener(ChartProgressListener chartProgressListener) {
        this.listenerList.add(class$com$jrefinery$chart$event$ChartProgressListener == null ? (class$com$jrefinery$chart$event$ChartProgressListener = JFreeChart.class$("com.jrefinery.chart.event.ChartProgressListener")) : class$com$jrefinery$chart$event$ChartProgressListener, chartProgressListener);
    }

    public void removeProgressListener(ChartProgressListener chartProgressListener) {
        this.listenerList.remove(class$com$jrefinery$chart$event$ChartProgressListener == null ? (class$com$jrefinery$chart$event$ChartProgressListener = JFreeChart.class$("com.jrefinery.chart.event.ChartProgressListener")) : class$com$jrefinery$chart$event$ChartProgressListener, chartProgressListener);
    }

    protected void notifyListeners(ChartProgressEvent chartProgressEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = objectArray.length - 2;
        while (n >= 0) {
            if (objectArray[n] == (class$com$jrefinery$chart$event$ChartProgressListener == null ? JFreeChart.class$("com.jrefinery.chart.event.ChartProgressListener") : class$com$jrefinery$chart$event$ChartProgressListener)) {
                ((ChartProgressListener)objectArray[n + 1]).chartProgress(chartProgressEvent);
            }
            n -= 2;
        }
    }

    public void titleChanged(TitleChangeEvent titleChangeEvent) {
        titleChangeEvent.setChart(this);
        this.notifyListeners(titleChangeEvent);
    }

    public void legendChanged(LegendChangeEvent legendChangeEvent) {
        legendChangeEvent.setChart(this);
        this.notifyListeners(legendChangeEvent);
    }

    public void plotChanged(PlotChangeEvent plotChangeEvent) {
        plotChangeEvent.setChart(this);
        this.notifyListeners(plotChangeEvent);
    }

    public static void main(String[] stringArray) {
        System.out.println(INFO.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

