/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.AbstractTitle;
import com.jrefinery.chart.Spacer;
import com.jrefinery.chart.event.TitleChangeEvent;
import com.jrefinery.ui.Size2D;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;

public class ImageTitle
extends AbstractTitle {
    private Image image;
    private int height;
    private int width;

    public ImageTitle(Image image) {
        this(image, image.getHeight(null), image.getWidth(null), 0, 4, 4, AbstractTitle.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, int n, int n2, int n3) {
        this(image, image.getHeight(null), image.getWidth(null), n, n2, n3, AbstractTitle.DEFAULT_SPACER);
    }

    public ImageTitle(Image image, int n, int n2, int n3, int n4, int n5, Spacer spacer) {
        super(n3, n4, n5, spacer);
        this.image = image;
        this.height = n;
        this.width = n2;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        int n = this.getPosition();
        if (n == 0 || n == 1) {
            this.drawHorizontal(graphics2D, rectangle2D);
        } else if (n == 3 || n == 2) {
            this.drawVertical(graphics2D, rectangle2D);
        } else {
            throw new RuntimeException("ImageTitle.draw(...) - invalid title position.");
        }
    }

    public boolean isValidPosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public double getPreferredWidth(Graphics2D graphics2D) {
        double d = this.width;
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d = spacer.getAdjustedWidth(d);
        }
        return d;
    }

    public double getPreferredHeight(Graphics2D graphics2D) {
        double d = this.height;
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d = spacer.getAdjustedHeight(d);
        }
        return d;
    }

    protected Size2D drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d2 = spacer.getTopSpace(this.height);
            d3 = spacer.getBottomSpace(this.height);
            d4 = spacer.getLeftSpace(this.width);
            d5 = spacer.getRightSpace(this.width);
        }
        d = this.getPosition() == 0 ? rectangle2D.getY() + d2 : rectangle2D.getY() + rectangle2D.getHeight() - d3 - (double)this.height;
        int n = this.getHorizontalAlignment();
        double d6 = 0.0;
        if (n == 4) {
            d6 = rectangle2D.getX() + d4 + rectangle2D.getWidth() / 2.0 - (double)(this.width / 2);
        } else if (n == 3) {
            d6 = rectangle2D.getX() + d4;
        } else if (n == 2) {
            d6 = rectangle2D.getX() + rectangle2D.getWidth() - d5 - (double)this.width;
        }
        graphics2D.drawImage(this.image, (int)d6, (int)d, this.width, this.height, null);
        return new Size2D(rectangle2D.getWidth() + d4 + d5, (double)this.height + d2 + d3);
    }

    protected Size2D drawVertical(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        Spacer spacer = this.getSpacer();
        if (spacer != null) {
            d2 = spacer.getTopSpace(this.height);
            d3 = spacer.getBottomSpace(this.height);
            d4 = spacer.getLeftSpace(this.width);
            d5 = spacer.getRightSpace(this.width);
        }
        d = this.getPosition() == 3 ? rectangle2D.getX() + d4 : rectangle2D.getMaxX() - d5 - (double)this.width;
        int n = this.getVerticalAlignment();
        double d6 = 0.0;
        if (n == 4) {
            d6 = rectangle2D.getMinY() + d2 + rectangle2D.getHeight() / 2.0 - (double)(this.height / 2);
        } else if (n == 0) {
            d6 = rectangle2D.getMinY() + d2;
        } else if (n == 1) {
            d6 = rectangle2D.getMaxY() - d3 - (double)this.height;
        }
        graphics2D.drawImage(this.image, (int)d, (int)d6, this.width, this.height, null);
        return new Size2D(rectangle2D.getWidth() + d4 + d5, (double)this.height + d2 + d3);
    }
}

