/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.chart;

import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.JFreeChartConstants;
import com.jrefinery.chart.axis.HorizontalCategoryAxis;
import com.jrefinery.chart.axis.HorizontalDateAxis;
import com.jrefinery.chart.axis.HorizontalNumberAxis;
import com.jrefinery.chart.axis.HorizontalNumberAxis3D;
import com.jrefinery.chart.axis.NumberAxis;
import com.jrefinery.chart.axis.VerticalCategoryAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis;
import com.jrefinery.chart.axis.VerticalNumberAxis3D;
import com.jrefinery.chart.plot.HorizontalCategoryPlot;
import com.jrefinery.chart.plot.Pie3DPlot;
import com.jrefinery.chart.plot.PiePlot;
import com.jrefinery.chart.plot.VerticalCategoryPlot;
import com.jrefinery.chart.plot.XYPlot;
import com.jrefinery.chart.renderer.AreaRenderer;
import com.jrefinery.chart.renderer.AreaXYRenderer;
import com.jrefinery.chart.renderer.CandlestickRenderer;
import com.jrefinery.chart.renderer.HighLowRenderer;
import com.jrefinery.chart.renderer.HorizontalBarRenderer;
import com.jrefinery.chart.renderer.HorizontalBarRenderer3D;
import com.jrefinery.chart.renderer.HorizontalIntervalBarRenderer;
import com.jrefinery.chart.renderer.LineAndShapeRenderer;
import com.jrefinery.chart.renderer.SignalRenderer;
import com.jrefinery.chart.renderer.StackedAreaRenderer;
import com.jrefinery.chart.renderer.StackedHorizontalBarRenderer;
import com.jrefinery.chart.renderer.StackedVerticalBarRenderer;
import com.jrefinery.chart.renderer.StackedVerticalBarRenderer3D;
import com.jrefinery.chart.renderer.StandardXYItemRenderer;
import com.jrefinery.chart.renderer.VerticalBarRenderer;
import com.jrefinery.chart.renderer.VerticalBarRenderer3D;
import com.jrefinery.chart.renderer.VerticalXYBarRenderer;
import com.jrefinery.chart.renderer.WindItemRenderer;
import com.jrefinery.chart.renderer.XYBubbleRenderer;
import com.jrefinery.chart.renderer.XYStepRenderer;
import com.jrefinery.chart.tooltips.HighLowToolTipGenerator;
import com.jrefinery.chart.tooltips.IntervalCategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardCategoryToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardPieToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardXYToolTipGenerator;
import com.jrefinery.chart.tooltips.StandardXYZToolTipGenerator;
import com.jrefinery.chart.tooltips.TimeSeriesToolTipGenerator;
import com.jrefinery.chart.urls.StandardCategoryURLGenerator;
import com.jrefinery.chart.urls.StandardPieURLGenerator;
import com.jrefinery.chart.urls.StandardXYURLGenerator;
import com.jrefinery.chart.urls.StandardXYZURLGenerator;
import com.jrefinery.data.CategoryDataset;
import com.jrefinery.data.HighLowDataset;
import com.jrefinery.data.IntervalCategoryDataset;
import com.jrefinery.data.IntervalXYDataset;
import com.jrefinery.data.PieDataset;
import com.jrefinery.data.SignalsDataset;
import com.jrefinery.data.WindDataset;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYZDataset;
import java.awt.Insets;
import java.text.DateFormat;

public class ChartFactory {
    public static JFreeChart createPieChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(pieDataset);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieToolTipGenerator standardPieToolTipGenerator = null;
        if (bl2) {
            standardPieToolTipGenerator = new StandardPieToolTipGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setToolTipGenerator(standardPieToolTipGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPieChart(String string, CategoryDataset categoryDataset, int n, boolean bl, boolean bl2, boolean bl3) {
        PiePlot piePlot = new PiePlot(categoryDataset, n);
        piePlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieToolTipGenerator standardPieToolTipGenerator = null;
        if (bl2) {
            standardPieToolTipGenerator = new StandardPieToolTipGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        piePlot.setToolTipGenerator(standardPieToolTipGenerator);
        piePlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, piePlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createPie3DChart(String string, PieDataset pieDataset, boolean bl, boolean bl2, boolean bl3) {
        Pie3DPlot pie3DPlot = new Pie3DPlot(pieDataset);
        pie3DPlot.setInsets(new Insets(0, 5, 5, 5));
        StandardPieToolTipGenerator standardPieToolTipGenerator = null;
        if (bl2) {
            standardPieToolTipGenerator = new StandardPieToolTipGenerator();
        }
        StandardPieURLGenerator standardPieURLGenerator = null;
        if (bl3) {
            standardPieURLGenerator = new StandardPieURLGenerator();
        }
        pie3DPlot.setToolTipGenerator(standardPieToolTipGenerator);
        pie3DPlot.setURLGenerator(standardPieURLGenerator);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, pie3DPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        VerticalBarRenderer verticalBarRenderer = new VerticalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, verticalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis3D verticalNumberAxis3D = new VerticalNumberAxis3D(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        VerticalBarRenderer3D verticalBarRenderer3D = new VerticalBarRenderer3D(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis3D, verticalBarRenderer3D);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedVerticalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        StackedVerticalBarRenderer stackedVerticalBarRenderer = new StackedVerticalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, stackedVerticalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedVerticalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis3D verticalNumberAxis3D = new VerticalNumberAxis3D(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        StackedVerticalBarRenderer3D stackedVerticalBarRenderer3D = new StackedVerticalBarRenderer3D(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis3D, stackedVerticalBarRenderer3D);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHorizontalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalBarRenderer horizontalBarRenderer = new HorizontalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis, horizontalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHorizontalBarChart3D(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis3D horizontalNumberAxis3D = new HorizontalNumberAxis3D(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalBarRenderer3D horizontalBarRenderer3D = new HorizontalBarRenderer3D(10.0, 10.0, standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis3D, horizontalBarRenderer3D);
        horizontalCategoryPlot.setForegroundAlpha(0.75f);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedHorizontalBarChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        StackedHorizontalBarRenderer stackedHorizontalBarRenderer = new StackedHorizontalBarRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(categoryDataset, verticalCategoryAxis, horizontalNumberAxis, stackedHorizontalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer(2, 1, standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, lineAndShapeRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        horizontalCategoryAxis.setCategoryMargin(0.0);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        AreaRenderer areaRenderer = new AreaRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, areaRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createStackedAreaChart(String string, String string2, String string3, CategoryDataset categoryDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalCategoryAxis horizontalCategoryAxis = new HorizontalCategoryAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = null;
        if (bl2) {
            standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        StackedAreaRenderer stackedAreaRenderer = new StackedAreaRenderer(standardCategoryToolTipGenerator, standardCategoryURLGenerator);
        VerticalCategoryPlot verticalCategoryPlot = new VerticalCategoryPlot(categoryDataset, horizontalCategoryAxis, verticalNumberAxis, stackedAreaRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, verticalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createGanttChart(String string, String string2, String string3, IntervalCategoryDataset intervalCategoryDataset, boolean bl, boolean bl2, boolean bl3) {
        VerticalCategoryAxis verticalCategoryAxis = new VerticalCategoryAxis(string2);
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string3);
        IntervalCategoryToolTipGenerator intervalCategoryToolTipGenerator = null;
        if (bl2) {
            intervalCategoryToolTipGenerator = new IntervalCategoryToolTipGenerator(DateFormat.getDateInstance());
        }
        StandardCategoryURLGenerator standardCategoryURLGenerator = null;
        if (bl3) {
            standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        }
        HorizontalIntervalBarRenderer horizontalIntervalBarRenderer = new HorizontalIntervalBarRenderer(intervalCategoryToolTipGenerator, standardCategoryURLGenerator);
        HorizontalCategoryPlot horizontalCategoryPlot = new HorizontalCategoryPlot(intervalCategoryDataset, verticalCategoryAxis, horizontalDateAxis, horizontalIntervalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, horizontalCategoryPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createLineXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new StandardXYItemRenderer(2, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createAreaXYChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new AreaXYRenderer(4, standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createScatterPlot(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer(1, standardXYToolTipGenerator, standardXYURLGenerator);
        standardXYItemRenderer.setDefaultShapeFilled(true);
        xYPlot.setRenderer(standardXYItemRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createBubbleChart(String string, String string2, String string3, XYZDataset xYZDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalNumberAxis horizontalNumberAxis = new HorizontalNumberAxis(string2);
        horizontalNumberAxis.setAutoRangeIncludesZero(false);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYZDataset, horizontalNumberAxis, verticalNumberAxis);
        StandardXYZToolTipGenerator standardXYZToolTipGenerator = null;
        if (bl2) {
            standardXYZToolTipGenerator = new StandardXYZToolTipGenerator();
        }
        StandardXYZURLGenerator standardXYZURLGenerator = null;
        if (bl3) {
            standardXYZURLGenerator = new StandardXYZURLGenerator();
        }
        XYBubbleRenderer xYBubbleRenderer = new XYBubbleRenderer(2, standardXYZToolTipGenerator, standardXYZURLGenerator);
        xYPlot.setRenderer(xYBubbleRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createWindPlot(String string, String string2, String string3, WindDataset windDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setMaximumAxisValue(12.0);
        verticalNumberAxis.setMinimumAxisValue(-12.0);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYPlot xYPlot = new XYPlot(windDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new WindItemRenderer(standardXYToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createTimeSeriesChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        horizontalDateAxis.setLowerMargin(0.02);
        horizontalDateAxis.setUpperMargin(0.02);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setAutoRangeIncludesZero(false);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalDateAxis, verticalNumberAxis);
        TimeSeriesToolTipGenerator timeSeriesToolTipGenerator = null;
        if (bl2) {
            timeSeriesToolTipGenerator = new TimeSeriesToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        xYPlot.setRenderer(new StandardXYItemRenderer(2, timeSeriesToolTipGenerator, standardXYURLGenerator));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createVerticalXYBarChart(String string, String string2, String string3, IntervalXYDataset intervalXYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        VerticalXYBarRenderer verticalXYBarRenderer = new VerticalXYBarRenderer(0.0, standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(intervalXYDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(verticalXYBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createHighLowChart(String string, String string2, String string3, HighLowDataset highLowDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(highLowDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new HighLowRenderer(new HighLowToolTipGenerator()));
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createCandlestickChart(String string, String string2, String string3, HighLowDataset highLowDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(highLowDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new CandlestickRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createSignalChart(String string, String string2, String string3, SignalsDataset signalsDataset, boolean bl) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        XYPlot xYPlot = new XYPlot(signalsDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(new SignalRenderer());
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }

    public static JFreeChart createXYStepChart(String string, String string2, String string3, XYDataset xYDataset, boolean bl, boolean bl2, boolean bl3) {
        HorizontalDateAxis horizontalDateAxis = new HorizontalDateAxis(string2);
        VerticalNumberAxis verticalNumberAxis = new VerticalNumberAxis(string3);
        verticalNumberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        StandardXYToolTipGenerator standardXYToolTipGenerator = null;
        if (bl2) {
            standardXYToolTipGenerator = new StandardXYToolTipGenerator();
        }
        StandardXYURLGenerator standardXYURLGenerator = null;
        if (bl3) {
            standardXYURLGenerator = new StandardXYURLGenerator();
        }
        XYStepRenderer xYStepRenderer = new XYStepRenderer(standardXYToolTipGenerator, standardXYURLGenerator);
        XYPlot xYPlot = new XYPlot(xYDataset, horizontalDateAxis, verticalNumberAxis);
        xYPlot.setRenderer(xYStepRenderer);
        xYPlot.setDomainCrosshairVisible(false);
        xYPlot.setRangeCrosshairVisible(false);
        JFreeChart jFreeChart = new JFreeChart(string, JFreeChartConstants.DEFAULT_TITLE_FONT, xYPlot, bl);
        return jFreeChart;
    }
}

