/*
 * Decompiled with CFR 0.152.
 */
import com.jrefinery.chart.ChartFactory;
import com.jrefinery.chart.ChartFrame;
import com.jrefinery.chart.ChartPanel;
import com.jrefinery.chart.JFreeChart;
import com.jrefinery.chart.axis.ValueAxis;
import com.jrefinery.data.XYDataset;
import com.jrefinery.data.XYSeries;
import com.jrefinery.data.XYSeriesCollection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Paint;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class JperfGUI
implements ActionListener,
ItemListener {
    private JFrame frame;
    private JFrame aboutFrame;
    private JMenuBar menuBar;
    private JMenu menu;
    private JMenuItem menuItem;
    private JPanel connectionInfo;
    private JSplitPane mainPanel;
    private JTabbedPane tabbedPane;
    private ImageIcon icon;
    private static JScrollPane outputPane;
    private JTextArea output;
    private JTextField dest;
    private JTextField port;
    private static JRadioButton server;
    private static JRadioButton client;
    private JFormattedTextField buflen;
    private JFormattedTextField winsize;
    private JFormattedTextField mss;
    private JFormattedTextField udp_bw;
    private JFormattedTextField TTL;
    private JCheckBox noDelay;
    private JTextField bindhost;
    private JCheckBox printMSS;
    private JTextField numConn;
    private JTextField transFile;
    private static JTextField trans;
    private JComboBox formatList;
    private static JTextField interval;
    private JComboBox tos;
    private ButtonGroup type;
    private ButtonGroup protocol;
    private static JRadioButton tcpButton;
    private static JRadioButton udpButton;
    private static JButton run;
    private static JButton stop;
    private static JRadioButton numbuff;
    private static JRadioButton transTime;
    private JCheckBox v6;
    private IperfThread iperf;
    private static JCheckBox clear;
    private static JCheckBox bw_graph;
    private static JCheckBox jitter_graph;
    private JButton jitterB;
    private JButton bwB;
    private JButton clearB;
    private JButton saveB;
    private JCheckBox compMode;
    private JTextField numClients;
    private JTextField LP;
    private JRadioButton dualMode;
    private JRadioButton tradeMode;
    private JButton browse;
    private JPanel settings;
    private float iperfV;
    private boolean pthreads;
    private JLabel lb_mss;
    private JLabel lb_udpbw;
    private JLabel lb_dest;
    private JLabel lb_limit;
    private JLabel lb_trans;
    private JLabel lb_winsize;
    private JLabel lb_numConn;
    private JLabel lb_tos;
    private JLabel lb_TTL;
    private JLabel lb_transFile;
    private JLabel lb_bufflen;
    private JLabel lb_udplen;
    private JLabel lb_mode;
    private JLabel lb_compMode;
    private JLabel lb_LP;
    private JLabel lb_numClients;
    private JLabel lb_servConn;
    private JLabel lb_udpsize;
    private String[] outputFormat = new String[]{"Adaptive Bits", "Adaptive Bytes", "Bits", "Bytes", "Gbits", "GBytes", "Kbits", "KBytes", "Mbits", "MBytes"};
    private String[] tos_options = new String[]{"", "Low Cost", "Low Delay", "Reliability", "Throughput"};
    private Insets labelInsets = new Insets(0, 0, 5, 0);
    private Insets compInsets = new Insets(0, 0, 5, 10);
    String options;
    String version;

    public JperfGUI(String string) {
        MetalLookAndFeel.setCurrentTheme(new JperfTheme());
        UIManager.installLookAndFeel("Jperf", "JperfLooknFeel");
        try {
            UIManager.setLookAndFeel("JperfLooknFeel");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
            // empty catch block
        }
        this.version = string;
        String[] stringArray = string.split(" ");
        String string2 = stringArray[2].replace('.', '-');
        String[] stringArray2 = string2.split("-");
        this.iperfV = new Float(stringArray2[1]).floatValue();
        this.iperfV = (float)((double)this.iperfV / 10.0);
        this.iperfV += new Float(stringArray2[0]).floatValue();
        this.frame = new JFrame("Jperf Measurement Tool");
        this.menuBar = new JMenuBar();
        this.menu = new JMenu("Help");
        this.menu.setMnemonic(72);
        this.menuItem = new JMenuItem("About...");
        this.menuItem.setActionCommand("About");
        this.menuItem.addActionListener(this);
        this.menu.add(this.menuItem);
        this.menuBar.add(this.menu);
        this.frame.setJMenuBar(this.menuBar);
        this.createConnectionPanel();
        this.tabbedPane = new JTabbedPane();
        this.settings = new JPanel();
        this.settings.setLayout(new BoxLayout(this.settings, 1));
        this.mainPanel = new JSplitPane(0, this.connectionInfo, this.tabbedPane);
        this.mainPanel.setOneTouchExpandable(true);
        this.mainPanel.setDividerLocation(115);
        this.mainPanel.setDividerSize(0);
        this.icon = new ImageIcon("images/middle.gif");
        this.tabbedPane.addTab("Settings", this.icon, this.settings, "Jperf Settings");
        this.createOutputPanel();
        this.createSettingsPanel();
        this.frame.addWindowListener(new JperfWindowListen());
        this.frame.setSize(650, 550);
        this.frame.getContentPane().add(this.mainPanel);
        this.frame.setVisible(true);
    }

    public void createConnectionPanel() {
        this.connectionInfo = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.connectionInfo.setLayout(gridBagLayout);
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel("Type:"));
        client = new JRadioButton("Client");
        client.setSelected(true);
        client.setActionCommand("client");
        client.addActionListener(this);
        client.setToolTipText("Run Iperf as a client   (command line: -c)");
        jPanel.add(client);
        server = new JRadioButton("Server");
        server.setActionCommand("server");
        server.addActionListener(this);
        server.setToolTipText("Run Iperf as a server   (command line: -s)");
        jPanel.add(server);
        this.type = new ButtonGroup();
        this.type.add(client);
        this.type.add(server);
        this.setGrid(gridBagConstraints, 0, 0, 2, 1);
        this.addComponent(jPanel, this.connectionInfo, gridBagLayout, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.add(new JLabel("Protocol:"));
        tcpButton = new JRadioButton("TCP");
        tcpButton.setSelected(true);
        tcpButton.setActionCommand("TCP");
        tcpButton.addActionListener(this);
        tcpButton.setToolTipText("Use TCP Protocol   (command line: default)");
        jPanel2.add(tcpButton);
        udpButton = new JRadioButton("UDP");
        udpButton.setActionCommand("UDP");
        udpButton.addActionListener(this);
        udpButton.setToolTipText("Use UDP Protocol   (command line: -u)");
        jPanel2.add(udpButton);
        this.protocol = new ButtonGroup();
        this.protocol.add(tcpButton);
        this.protocol.add(udpButton);
        this.setGrid(gridBagConstraints, 3, 0, 2, 1);
        this.addComponent(jPanel2, this.connectionInfo, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        this.lb_dest = new JLabel("Server: ");
        this.lb_dest.setToolTipText("Specify what server the Iperf client should connect to   (command line: -c)");
        this.lb_limit = new JLabel("Client Limit: ");
        this.lb_limit.setToolTipText("Specify a host for Iperf server to only accept connections from");
        this.addComponent(this.lb_dest, this.connectionInfo, gridBagLayout, gridBagConstraints);
        this.addComponent(this.lb_limit, this.connectionInfo, gridBagLayout, gridBagConstraints);
        this.lb_limit.setVisible(false);
        this.dest = new JTextField(30);
        this.setGrid(gridBagConstraints, 1, 1, 3, 1);
        gridBagConstraints.insets = this.compInsets;
        this.addComponent(this.dest, this.connectionInfo, gridBagLayout, gridBagConstraints);
        JPanel jPanel3 = new JPanel();
        this.setGrid(gridBagConstraints, 3, 1, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        JLabel jLabel = new JLabel("Port: ");
        jPanel3.add(jLabel);
        jLabel.setToolTipText("Specify port   (command line: -p)");
        this.port = new JTextField("5001", 5);
        jPanel3.add(this.port);
        gridBagConstraints.anchor = 17;
        this.setGrid(gridBagConstraints, 4, 1, 1, 1);
        gridBagConstraints.insets = this.compInsets;
        this.addComponent(jPanel3, this.connectionInfo, gridBagLayout, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        this.setGrid(gridBagConstraints, 4, 2, 2, 1);
        run = new JButton("Run");
        run.setToolTipText("Run Iperf!");
        run.setActionCommand("Run");
        run.addActionListener(this);
        jPanel4.add(run);
        stop = new JButton("Stop");
        stop.setToolTipText("Stop Iperf");
        stop.setActionCommand("Stop");
        stop.addActionListener(this);
        stop.setEnabled(false);
        jPanel4.add(stop);
        this.addComponent(jPanel4, this.connectionInfo, gridBagLayout, gridBagConstraints);
    }

    public void createSettingsPanel() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        TitledBorder titledBorder = new TitledBorder("General Options");
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(600, 175));
        jPanel.setLayout(gridBagLayout);
        this.settings.add(jPanel);
        this.setGrid(gridBagConstraints, 0, 0, 2, 1);
        gridBagConstraints.insets = this.compInsets;
        this.compMode = new JCheckBox("Compatibility Mode");
        this.compMode.setToolTipText("Compatibility mode allows for use with older version of iperf   (command line: -C)");
        this.compMode.setSelected(false);
        if ((double)this.iperfV < 1.7) {
            this.compMode.setEnabled(false);
        }
        this.compMode.addItemListener(this);
        this.addComponent(this.compMode, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 3, 0, 3, 1);
        gridBagConstraints.insets = this.labelInsets;
        JPanel jPanel2 = new JPanel();
        this.lb_mode = new JLabel("Testing Mode: ");
        this.dualMode = new JRadioButton("Dual");
        this.dualMode.setToolTipText("Cause the server to connect back to the client immediately and run tests simultaneously   (command line: -d)");
        this.tradeMode = new JRadioButton("Trade");
        this.tradeMode.setToolTipText("Cause the server to connect back to the client following termination of the client   (command line: -r)");
        jPanel2.add(this.lb_mode);
        jPanel2.add(this.dualMode);
        jPanel2.add(this.tradeMode);
        if ((double)this.iperfV < 1.7) {
            this.lb_mode.setEnabled(false);
            this.dualMode.setEnabled(false);
            this.tradeMode.setEnabled(false);
        }
        this.lb_LP = new JLabel("Port: ");
        this.lb_LP.setToolTipText("This specifies the port that the server will connect back to the client on   (command line: -L)");
        gridBagConstraints.insets = this.compInsets;
        this.LP = new JTextField("5001", 4);
        jPanel2.add(this.lb_LP);
        jPanel2.add(this.LP);
        this.addComponent(jPanel2, jPanel, gridBagLayout, gridBagConstraints);
        if ((double)this.iperfV < 1.7) {
            this.lb_LP.setEnabled(false);
            this.LP.setEnabled(false);
        }
        this.setGrid(gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = this.labelInsets;
        this.lb_winsize = new JLabel("TCP Window Size: ");
        this.lb_winsize.setToolTipText("Set TCP window size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
        this.addComponent(this.lb_winsize, jPanel, gridBagLayout, gridBagConstraints);
        this.lb_udpsize = new JLabel("UDP Buffer Size: ");
        this.lb_udpsize.setToolTipText("Set UDP buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -w)");
        this.addComponent(this.lb_udpsize, jPanel, gridBagLayout, gridBagConstraints);
        this.lb_udpsize.setVisible(false);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.winsize = new JFormattedTextField();
        this.winsize.setColumns(4);
        this.setGrid(gridBagConstraints, 1, 1, 1, 1);
        this.addComponent(this.winsize, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 2, 1, 1, 1);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = this.labelInsets;
        this.lb_bufflen = new JLabel("Buffer Length: ");
        this.lb_bufflen.setToolTipText("Read/Write buffer length. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -l)");
        this.addComponent(this.lb_bufflen, jPanel, gridBagLayout, gridBagConstraints);
        this.lb_udplen = new JLabel("UDP Packet Size: ");
        this.lb_udplen.setToolTipText("Set UDP datagram buffer size. Use 'K' or 'M' for kilo/mega bytes. (i.e 1470)   (command line: -l)");
        this.lb_udplen.setVisible(false);
        this.addComponent(this.lb_udplen, jPanel, gridBagLayout, gridBagConstraints);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.buflen = new JFormattedTextField((Object)"8K");
        this.buflen.setColumns(4);
        this.setGrid(gridBagConstraints, 3, 1, 1, 1);
        this.addComponent(this.buflen, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 4, 2, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        this.lb_udpbw = new JLabel("UDP Bandwidth: ");
        this.lb_udpbw.setEnabled(false);
        this.lb_udpbw.setToolTipText("Set bandwidth to send in bits/sec. Use 'K' or 'M' for kilo/mega bits. (i.e 8K)   (command line: -b)");
        this.addComponent(this.lb_udpbw, jPanel, gridBagLayout, gridBagConstraints);
        this.udp_bw = new JFormattedTextField((Object)"1M");
        this.udp_bw.setEnabled(false);
        this.udp_bw.setColumns(4);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.setGrid(gridBagConstraints, 5, 2, 1, 1);
        this.addComponent(this.udp_bw, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 0, 2, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        this.numConn = new JTextField("1", 4);
        this.lb_numConn = new JLabel("Parallel Streams: ");
        this.lb_servConn = new JLabel("Num Connections: ");
        this.lb_servConn.setToolTipText("The number of connections to handle by the server before closing. Default is 0 (handle forever)   (command line: -P)");
        this.lb_numConn.setToolTipText("The number of simultaneous connections to make to the server. Default is 1.   (command line: -P)");
        gridBagConstraints.anchor = 13;
        this.addComponent(this.lb_numConn, jPanel, gridBagLayout, gridBagConstraints);
        this.addComponent(this.lb_servConn, jPanel, gridBagLayout, gridBagConstraints);
        this.lb_servConn.setVisible(false);
        this.setGrid(gridBagConstraints, 1, 2, 1, 1);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.compInsets;
        this.addComponent(this.numConn, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 4, 1, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        this.lb_mss = new JLabel("Max Segment Size: ");
        this.lb_mss.setToolTipText("Attempt to set max segment size. Use 'K' or 'M' for kilo/mega bytes. (i.e 8K)   (command line: -M)");
        this.addComponent(this.lb_mss, jPanel, gridBagLayout, gridBagConstraints);
        this.mss = new JFormattedTextField();
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.mss.setColumns(4);
        this.setGrid(gridBagConstraints, 5, 1, 1, 1);
        this.addComponent(this.mss, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 2, 5, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        this.TTL = new JFormattedTextField((Object)"1");
        this.TTL.setColumns(4);
        this.lb_TTL = new JLabel("TTL: ");
        this.lb_TTL.setToolTipText("Set time to live (number of hops). Default is 1.   (command line: -T)");
        gridBagConstraints.anchor = 13;
        this.addComponent(this.lb_TTL, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 3, 5, 1, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(this.TTL, jPanel, gridBagLayout, gridBagConstraints);
        this.lb_TTL.setEnabled(false);
        this.TTL.setEnabled(false);
        this.noDelay = new JCheckBox("TCP No Delay");
        this.noDelay.setSelected(false);
        this.noDelay.setToolTipText("Disable Nagle's algorithm   (command line: -N)");
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 13;
        this.setGrid(gridBagConstraints, 3, 5, 2, 1);
        this.addComponent(this.noDelay, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 0, 3, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        this.bindhost = new JTextField(18);
        JLabel jLabel = new JLabel("Bind to Host: ");
        jLabel.setToolTipText("Bind to host, one of this machine's addresses. For multihomed hosts.   (command line: -B)");
        this.addComponent(jLabel, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 1, 3, 3, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(this.bindhost, jPanel, gridBagLayout, gridBagConstraints);
        this.setGrid(gridBagConstraints, 4, 3, 1, 1);
        this.v6 = new JCheckBox("IPv6");
        this.v6.setToolTipText("Bind to an IPv6 address   (command line: -V)");
        this.v6.setSelected(false);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.compInsets;
        this.addComponent(this.v6, jPanel, gridBagLayout, gridBagConstraints);
        if ((double)this.iperfV < 1.6) {
            this.v6.setEnabled(false);
        }
        this.v6.addItemListener(this);
        this.setGrid(gridBagConstraints, 0, 4, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        this.lb_transFile = new JLabel("Representative File: ");
        this.lb_transFile.setToolTipText("Use a representative stream to measure bandwidth   (command line: -F)");
        gridBagConstraints.anchor = 13;
        this.addComponent(this.lb_transFile, jPanel, gridBagLayout, gridBagConstraints);
        this.transFile = new JTextField(18);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = this.compInsets;
        this.setGrid(gridBagConstraints, 1, 4, 3, 1);
        this.addComponent(this.transFile, jPanel, gridBagLayout, gridBagConstraints);
        this.browse = new JButton("Browse");
        this.browse.setActionCommand("Browse");
        this.browse.addActionListener(this);
        this.setGrid(gridBagConstraints, 4, 4, 2, 1);
        this.addComponent(this.browse, jPanel, gridBagLayout, gridBagConstraints);
        if ((double)this.iperfV < 1.2) {
            this.transFile.setEnabled(false);
            this.lb_transFile.setEnabled(false);
            this.browse.setEnabled(false);
        }
        this.setGrid(gridBagConstraints, 0, 5, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        this.lb_tos = new JLabel("Type of Service: ");
        this.lb_tos.setToolTipText("The type-of-service for outgoing packets. (Many routers ignore the TOS field)   (command line: -S)");
        this.addComponent(this.lb_tos, jPanel, gridBagLayout, gridBagConstraints);
        this.tos = new JComboBox<String>(this.tos_options);
        this.tos.setSelectedIndex(0);
        this.setGrid(gridBagConstraints, 1, 5, 2, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(this.tos, jPanel, gridBagLayout, gridBagConstraints);
        TitledBorder titledBorder2 = new TitledBorder("Reporting Format");
        JPanel jPanel3 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        jPanel3.setBorder(titledBorder2);
        jPanel3.setLayout(gridBagLayout2);
        jPanel3.setPreferredSize(new Dimension(600, 150));
        this.settings.add(jPanel3);
        this.setGrid(gridBagConstraints, 0, 0, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        this.lb_trans = new JLabel("Transmit: ");
        this.lb_trans.setToolTipText("Time to transmit, or number of buffers to transmit. Default is 10secs   (command line: -t, -n)");
        this.addComponent(this.lb_trans, jPanel3, gridBagLayout2, gridBagConstraints);
        trans = new JTextField("10", 5);
        this.setGrid(gridBagConstraints, 1, 0, 1, 1);
        gridBagConstraints.anchor = 17;
        this.addComponent(trans, jPanel3, gridBagLayout2, gridBagConstraints);
        JPanel jPanel4 = new JPanel();
        numbuff = new JRadioButton("Number of Bytes");
        transTime = new JRadioButton("Time in Seconds");
        ButtonGroup buttonGroup = new ButtonGroup();
        transTime.setSelected(true);
        buttonGroup.add(transTime);
        buttonGroup.add(numbuff);
        jPanel4.add(transTime);
        jPanel4.add(numbuff);
        this.setGrid(gridBagConstraints, 2, 0, 4, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(jPanel4, jPanel3, gridBagLayout2, gridBagConstraints);
        this.setGrid(gridBagConstraints, 0, 1, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        JLabel jLabel2 = new JLabel("Output Format: ");
        jLabel2.setToolTipText("Format to print bandwidth numbers in. Adaptive formats choose between kilo- and mega-   (command line: -f)");
        this.addComponent(jLabel2, jPanel3, gridBagLayout2, gridBagConstraints);
        this.formatList = new JComboBox<String>(this.outputFormat);
        this.formatList.setSelectedIndex(6);
        this.setGrid(gridBagConstraints, 1, 1, 2, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(this.formatList, jPanel3, gridBagLayout2, gridBagConstraints);
        this.setGrid(gridBagConstraints, 3, 1, 1, 1);
        gridBagConstraints.insets = this.labelInsets;
        gridBagConstraints.anchor = 13;
        JLabel jLabel3 = new JLabel("Report Interval: ");
        jLabel3.setToolTipText("Sets the interval time (secs) between periodic bandwidth, jitter, and loss reports   (command line: -i)");
        this.addComponent(jLabel3, jPanel3, gridBagLayout2, gridBagConstraints);
        interval = new JTextField("1", 4);
        this.setGrid(gridBagConstraints, 4, 1, 1, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 17;
        this.addComponent(interval, jPanel3, gridBagLayout2, gridBagConstraints);
        this.printMSS = new JCheckBox("Print MSS");
        this.printMSS.setToolTipText("Print out TCP maximum segment size   (command line: -m)");
        this.printMSS.setSelected(false);
        this.setGrid(gridBagConstraints, 5, 1, 1, 1);
        gridBagConstraints.insets = this.compInsets;
        gridBagConstraints.anchor = 13;
        this.addComponent(this.printMSS, jPanel3, gridBagLayout2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        clear = new JCheckBox("Clear Output for new Iperf Run");
        clear.setToolTipText("Always clear Iperf output between runs.");
        clear.setSelected(false);
        this.setGrid(gridBagConstraints, 0, 2, 3, 1);
        gridBagConstraints.insets = this.compInsets;
        this.addComponent(clear, jPanel3, gridBagLayout2, gridBagConstraints);
        bw_graph = new JCheckBox("Bandwidth Graph PopUp");
        bw_graph.setSelected(true);
        bw_graph.setToolTipText("Always pop up bandwidth graph.");
        this.setGrid(gridBagConstraints, 3, 2, 3, 1);
        this.addComponent(bw_graph, jPanel3, gridBagLayout2, gridBagConstraints);
        jitter_graph = new JCheckBox("Jitter Graph PopUp");
        jitter_graph.setToolTipText("Always pop up jitter graph.");
        jitter_graph.setSelected(false);
        jitter_graph.setEnabled(false);
        this.setGrid(gridBagConstraints, 0, 3, 3, 1);
        this.addComponent(jitter_graph, jPanel3, gridBagLayout2, gridBagConstraints);
        this.createAbout();
    }

    public void createOutputPanel() {
        this.output = new JTextArea(50, 50);
        outputPane = new JScrollPane(this.output);
        JPanel jPanel = new JPanel();
        JSplitPane jSplitPane = new JSplitPane(0, outputPane, jPanel);
        jSplitPane.setDividerLocation(300);
        jSplitPane.setDividerSize(0);
        this.tabbedPane.addTab("Output", this.icon, jSplitPane, "Iperf Output");
        this.tabbedPane.setSelectedIndex(0);
        this.clearB = new JButton("Clear");
        this.clearB.setActionCommand("Clear");
        this.clearB.addActionListener(this);
        this.clearB.setToolTipText("Clears output from Iperf run");
        this.saveB = new JButton("Save");
        this.saveB.setActionCommand("Save");
        this.saveB.addActionListener(this);
        this.saveB.setToolTipText("Save output to a file");
        this.bwB = new JButton("Bandwidth");
        this.bwB.setActionCommand("Bandwidth");
        this.bwB.addActionListener(this);
        this.bwB.setToolTipText("Pops up Bandwidth Graph");
        this.jitterB = new JButton("Jitter");
        this.jitterB.setEnabled(false);
        this.jitterB.setActionCommand("Jitter");
        this.jitterB.addActionListener(this);
        this.jitterB.setToolTipText("Pops up Jitter Graph");
        jPanel.add(this.clearB);
        jPanel.add(this.bwB);
        jPanel.add(this.jitterB);
        jPanel.add(this.saveB);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.compMode) {
            if (this.compMode.isSelected()) {
                this.lb_mode.setEnabled(false);
                this.dualMode.setEnabled(false);
                this.tradeMode.setEnabled(false);
                this.LP.setEnabled(false);
                this.lb_LP.setEnabled(false);
            } else if (!server.isSelected()) {
                this.lb_mode.setEnabled(true);
                this.dualMode.setEnabled(true);
                this.tradeMode.setEnabled(true);
                this.LP.setEnabled(true);
                this.lb_LP.setEnabled(true);
            }
        }
        if (itemSelectable == this.v6) {
            if (this.v6.isSelected()) {
                if (udpButton.isSelected()) {
                    this.buflen.setText("1450");
                }
            } else if (udpButton.isSelected()) {
                this.buflen.setText("1470");
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block15: {
            JFileChooser jFileChooser;
            int n;
            String string;
            block23: {
                block22: {
                    block21: {
                        block20: {
                            block19: {
                                block18: {
                                    block17: {
                                        block16: {
                                            block14: {
                                                string = actionEvent.getActionCommand();
                                                if (string != "TCP") break block14;
                                                this.lb_winsize.setVisible(true);
                                                this.lb_udpsize.setVisible(false);
                                                this.printMSS.setEnabled(true);
                                                this.mss.setEnabled(true);
                                                this.lb_mss.setEnabled(true);
                                                this.noDelay.setEnabled(true);
                                                this.udp_bw.setEnabled(false);
                                                this.lb_udpbw.setEnabled(false);
                                                this.lb_udplen.setVisible(false);
                                                this.lb_bufflen.setVisible(true);
                                                jitter_graph.setEnabled(false);
                                                this.jitterB.setEnabled(false);
                                                this.lb_TTL.setEnabled(false);
                                                this.TTL.setEnabled(false);
                                                this.buflen.setText("8K");
                                                break block15;
                                            }
                                            if (string != "UDP") break block16;
                                            if (this.v6.isSelected()) {
                                                this.buflen.setText("1450");
                                            } else {
                                                this.buflen.setText("1470");
                                            }
                                            this.printMSS.setEnabled(false);
                                            this.mss.setEnabled(false);
                                            this.lb_mss.setEnabled(false);
                                            this.noDelay.setEnabled(false);
                                            if (!server.isSelected()) {
                                                this.udp_bw.setEnabled(true);
                                                this.lb_udpbw.setEnabled(true);
                                                this.lb_TTL.setEnabled(true);
                                                this.TTL.setEnabled(true);
                                            } else {
                                                jitter_graph.setEnabled(true);
                                                this.jitterB.setEnabled(true);
                                            }
                                            this.lb_udplen.setVisible(true);
                                            this.lb_bufflen.setVisible(false);
                                            this.lb_winsize.setVisible(false);
                                            this.lb_udpsize.setVisible(true);
                                            break block15;
                                        }
                                        if (string != "Run") break block17;
                                        stop.setEnabled(true);
                                        run.setEnabled(false);
                                        boolean bl = this.formOptions();
                                        if (bl) {
                                            this.tabbedPane.setSelectedIndex(1);
                                            if (clear.isSelected()) {
                                                this.output.setText("");
                                            }
                                            this.iperf = new IperfThread(this.options, this.frame, this.output);
                                            this.iperf.start();
                                        } else {
                                            stop.setEnabled(false);
                                            run.setEnabled(true);
                                        }
                                        break block15;
                                    }
                                    if (string != "Stop") break block18;
                                    this.iperf.quit();
                                    break block15;
                                }
                                if (string != "Clear") break block19;
                                this.iperf.quit();
                                this.output.setText("");
                                break block15;
                            }
                            if (string != "server") break block20;
                            if (udpButton.isSelected()) {
                                jitter_graph.setEnabled(true);
                                this.jitterB.setEnabled(true);
                            }
                            this.dest.setEnabled(false);
                            this.lb_dest.setEnabled(false);
                            this.lb_udpbw.setEnabled(false);
                            this.udp_bw.setEnabled(false);
                            numbuff.setEnabled(false);
                            this.lb_trans.setEnabled(false);
                            transTime.setEnabled(false);
                            this.lb_tos.setEnabled(false);
                            this.tos.setEnabled(false);
                            this.lb_TTL.setEnabled(false);
                            this.TTL.setEnabled(false);
                            this.lb_transFile.setEnabled(false);
                            this.transFile.setEnabled(false);
                            this.browse.setEnabled(false);
                            this.lb_mode.setEnabled(false);
                            this.dualMode.setEnabled(false);
                            this.tradeMode.setEnabled(false);
                            this.LP.setEnabled(false);
                            this.lb_LP.setEnabled(false);
                            if ((double)this.iperfV >= 1.7) {
                                this.lb_dest.setVisible(false);
                                this.lb_limit.setVisible(true);
                                this.dest.setEnabled(true);
                                this.lb_numConn.setVisible(false);
                                this.lb_servConn.setVisible(true);
                                this.numConn.setText("0");
                            } else {
                                this.lb_numConn.setEnabled(false);
                                this.numConn.setEnabled(false);
                            }
                            break block15;
                        }
                        if (string != "client") break block21;
                        this.dest.setEnabled(true);
                        this.lb_limit.setVisible(false);
                        this.lb_dest.setVisible(true);
                        this.lb_dest.setEnabled(true);
                        jitter_graph.setEnabled(false);
                        this.jitterB.setEnabled(false);
                        if (udpButton.isSelected()) {
                            this.lb_udpbw.setEnabled(true);
                            this.udp_bw.setEnabled(true);
                            this.lb_TTL.setEnabled(true);
                            this.TTL.setEnabled(true);
                        }
                        transTime.setEnabled(true);
                        numbuff.setEnabled(true);
                        this.lb_trans.setEnabled(true);
                        trans.setEnabled(true);
                        this.lb_tos.setEnabled(true);
                        this.tos.setEnabled(true);
                        this.lb_numConn.setVisible(true);
                        this.lb_numConn.setEnabled(true);
                        this.lb_servConn.setVisible(false);
                        this.numConn.setEnabled(true);
                        this.numConn.setText("1");
                        if ((double)this.iperfV >= 1.2) {
                            this.lb_transFile.setEnabled(true);
                            this.transFile.setEnabled(true);
                            this.browse.setEnabled(true);
                        }
                        if (this.compMode.isSelected() || !((double)this.iperfV >= 1.7)) break block15;
                        this.lb_mode.setEnabled(true);
                        this.dualMode.setEnabled(true);
                        this.tradeMode.setEnabled(true);
                        this.LP.setEnabled(true);
                        this.lb_LP.setEnabled(true);
                        break block15;
                    }
                    if (string != "About") break block22;
                    this.aboutFrame.setVisible(true);
                    break block15;
                }
                if (string != "Browse") break block23;
                JFileChooser jFileChooser2 = new JFileChooser();
                int n2 = jFileChooser2.showDialog(this.frame, "Select");
                if (n2 != 0) break block15;
                File file = jFileChooser2.getSelectedFile();
                this.transFile.setText(file.getAbsolutePath());
                break block15;
            }
            if (string != "Save" || (n = (jFileChooser = new JFileChooser()).showDialog(this.frame, "Save")) != 0) break block15;
            File file = jFileChooser.getSelectedFile();
            String string2 = new String(this.output.getText());
            try {
                FileWriter fileWriter = new FileWriter(file);
                fileWriter.write(string2);
                fileWriter.close();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(this.frame, "Error Saving Output: " + iOException.getMessage());
            }
        }
    }

    void addComponent(Component component, JPanel jPanel, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints) {
        gridBagLayout.setConstraints(component, gridBagConstraints);
        jPanel.add(component);
    }

    void setInset(Insets insets, int n, int n2, int n3, int n4) {
        insets.top = n;
        insets.bottom = n2;
        insets.right = n3;
        insets.left = n4;
    }

    void setGrid(GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
    }

    boolean formOptions() {
        int n;
        Comparable<Integer> comparable;
        if (bw_graph.isSelected()) {
            comparable = interval.getText().length() > 0 ? new Integer(interval.getText()) : new Integer(0);
            if ((Integer)comparable < 1) {
                JOptionPane.showMessageDialog(this.frame, "For interesting Bandwidth graphs, please enter an interval to be 1 or greater.");
                return false;
            }
            n = this.formatList.getSelectedIndex();
            if (n == 0 || n == 1) {
                JOptionPane.showMessageDialog(this.frame, "For Bandwidth graphs, adaptive format can not be selected");
                return false;
            }
        }
        if (jitter_graph.isSelected() && jitter_graph.isEnabled()) {
            comparable = interval.getText().length() > 0 ? new Integer(interval.getText()) : new Integer(0);
            if ((Integer)comparable < 1) {
                JOptionPane.showMessageDialog(this.frame, "For interesting Jitter graphs, please enter an interval to be 1 or greater.");
                return false;
            }
            n = this.formatList.getSelectedIndex();
            if (n == 0 || n == 1) {
                JOptionPane.showMessageDialog(this.frame, "For Bandwidth graphs, adaptive format can not be selected");
                return false;
            }
        }
        this.options = "iperf";
        if (server.isSelected()) {
            this.options = this.options + " -s";
            if (this.dest.getText().length() > 0 && this.dest.isEnabled()) {
                this.options = this.options + " -c " + this.dest.getText();
            }
        } else if (this.dest.getText().length() > 0) {
            this.options = this.options + " -c " + this.dest.getText();
        } else {
            JOptionPane.showMessageDialog(this.frame, "Error: Please enter host to connect to.");
            return false;
        }
        if (udpButton.isSelected()) {
            this.options = this.options + " -u";
        }
        if (this.numConn.getText().length() > 0 && this.numConn.isEnabled()) {
            this.options = this.options + " -P " + this.numConn.getText();
        }
        if (interval.getText().length() > 0) {
            this.options = this.options + " -i " + interval.getText();
        }
        if (this.printMSS.isSelected() && this.printMSS.isEnabled()) {
            this.options = this.options + " -m";
        }
        if (this.port.getText().length() > 0) {
            this.options = this.options + " -p " + this.port.getText();
        }
        if (this.winsize.getText().length() > 0 && this.winsize.isEnabled()) {
            this.options = this.options + " -w " + this.winsize.getText();
        }
        if (this.bindhost.getText().length() > 0) {
            this.options = this.options + " -B " + this.bindhost.getText();
        }
        if (this.mss.getText().length() > 0 && this.mss.isEnabled()) {
            this.options = this.options + " -M " + this.mss.getText();
        }
        if (this.noDelay.isSelected() && this.noDelay.isEnabled()) {
            this.options = this.options + " -N";
        }
        if (this.v6.isSelected() && this.v6.isEnabled()) {
            this.options = this.options + " -V";
        }
        if (this.buflen.getText().length() > 0) {
            this.options = this.options + " -l " + this.buflen.getText();
        }
        if (this.compMode.isSelected() && this.compMode.isEnabled()) {
            this.options = this.options + " -C";
        }
        this.options = this.options + " -f ";
        switch (this.formatList.getSelectedIndex()) {
            case 0: {
                this.options = this.options + "a";
                break;
            }
            case 1: {
                this.options = this.options + "A";
                break;
            }
            case 2: {
                this.options = this.options + "b";
                break;
            }
            case 3: {
                this.options = this.options + "B";
                break;
            }
            case 4: {
                this.options = this.options + "g";
                break;
            }
            case 5: {
                this.options = this.options + "G";
                break;
            }
            case 6: {
                this.options = this.options + "k";
                break;
            }
            case 7: {
                this.options = this.options + "K";
                break;
            }
            case 8: {
                this.options = this.options + "m";
                break;
            }
            case 9: {
                this.options = this.options + "M";
                break;
            }
            default: {
                this.options = this.options + "A";
            }
        }
        if (this.udp_bw.getText().length() > 0 && this.udp_bw.isEnabled()) {
            this.options = this.options + " -b " + this.udp_bw.getText();
        }
        if (trans.getText().length() > 0 && trans.isEnabled()) {
            if (numbuff.isSelected()) {
                this.options = this.options + " -n " + trans.getText();
            } else if (transTime.isSelected()) {
                this.options = this.options + " -t " + trans.getText();
            }
        }
        if (this.dualMode.isSelected() && this.dualMode.isEnabled()) {
            this.options = this.options + " -d";
        }
        if (this.tradeMode.isSelected() && this.tradeMode.isEnabled()) {
            this.options = this.options + " -r";
        }
        if (this.LP.getText().length() > 0 && this.LP.isEnabled()) {
            this.options = this.options + " -L " + this.LP.getText();
        }
        if (this.TTL.getText().length() > 0 && this.TTL.isEnabled()) {
            this.options = this.options + " -T " + this.TTL.getText();
        }
        if (this.tos.getSelectedIndex() != 0) {
            this.options = this.options + " -S ";
            this.options = this.tos.getSelectedIndex() == 1 ? this.options + "0x02" : (this.tos.getSelectedIndex() == 2 ? this.options + "0x10" : (this.tos.getSelectedIndex() == 3 ? this.options + "0x04" : this.options + "0x08"));
        }
        if (this.transFile.getText().length() > 0 && this.transFile.isEnabled()) {
            comparable = new File(this.transFile.getText());
            if (!((File)comparable).exists()) {
                JOptionPane.showMessageDialog(this.frame, "Error: The file you selected does not exist.");
                return false;
            }
            this.options = this.options + " -F " + this.transFile.getText();
        }
        return true;
    }

    void createAbout() {
        this.aboutFrame = new JFrame("About Iperf");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0));
        JTabbedPane jTabbedPane = new JTabbedPane();
        JSplitPane jSplitPane = new JSplitPane(0, jPanel, jTabbedPane);
        jSplitPane.setDividerLocation(105);
        jSplitPane.setDividerSize(0);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/buttons/Iperf-words.jpg"));
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JLabel jLabel2 = new JLabel("Iperf");
        jLabel2.setAlignmentX(0.5f);
        jPanel2.add(jLabel2);
        JLabel jLabel3 = new JLabel(this.version);
        jLabel3.setAlignmentX(0.5f);
        jPanel2.add(jLabel3);
        JLabel jLabel4 = new JLabel("NLANR Distributed Applications Support Team");
        jLabel4.setAlignmentX(0.5f);
        jPanel2.add(jLabel4);
        JLabel jLabel5 = new JLabel("http://dast.nlanr.net/Projects/Iperf");
        jLabel5.setAlignmentX(0.5f);
        jPanel2.add(jLabel5);
        jPanel.add(jPanel2);
        ImageIcon imageIcon2 = new ImageIcon("test");
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(new Dimension(300, 200));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        JLabel jLabel6 = new JLabel("Mark Gates");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Ajay Tirumala");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Jim Ferguson");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Jon Dugan");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Feng Qin");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Kevin Gibbs");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("Tanya Brethour");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("National Laboratory for Applied Network Research (NLANR)");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("National Center for Supercomputing Applications (NCSA)");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("University of Illinois at Urbana-Champaign (UIUC)");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jLabel6 = new JLabel("http://www.ncsa.uiuc.edu");
        jLabel6.setAlignmentX(0.5f);
        jPanel3.add(jLabel6);
        jTabbedPane.addTab("Developers", imageIcon2, jPanel3);
        JPanel jPanel4 = new JPanel();
        JTextArea jTextArea = new JTextArea("Thanks to Mark Gates (NLANR), Alex Warshavsky (NLANR) and Justin Pietsch (University of Washington) who were responsible for the 1.1.x releases of Iperf. For this release, we would like to thank Bill Cerveny (Internet2), Micheal Lambert (PSC), Dale Finkelson (UNL) and Matthew Zekauskas (Internet2) for help in getting access to IPv6 networks / machines. Special thanks to Matthew Zekauskas (Internet2) for helping out in the FreeBSD implementation. Also, thanks to Kraemer Oliver (Sony) for providing an independent implementation of IPv6 version of Iperf, which provided a useful comparison for testing our features. ");
        jTextArea.setColumns(35);
        jTextArea.setBackground(new Color(220, 239, 206));
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jPanel4.add(jTextArea);
        jTabbedPane.addTab("Acknowledgements", imageIcon2, jPanel4);
        JTextArea jTextArea2 = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane(jTextArea2);
        jTabbedPane.addTab("License", imageIcon2, jScrollPane);
        jTextArea2.setEditable(false);
        try {
            InputStream inputStream = this.getClass().getResourceAsStream("/license.txt");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            String string = bufferedReader.readLine();
            while (string != null) {
                jTextArea2.append(string);
                jTextArea2.append("\n");
                string = bufferedReader.readLine();
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            jTextArea2.append("Error: " + fileNotFoundException.getMessage());
        }
        catch (IOException iOException) {
            jTextArea2.append("Error: " + iOException.getMessage());
        }
        this.aboutFrame.getContentPane().add(jSplitPane);
        this.aboutFrame.setSize(450, 350);
    }

    public static void createBWGraph(Vector vector) {
        Measurement measurement;
        Vector vector2;
        XYSeries xYSeries;
        String string;
        JperfStreamResult jperfStreamResult;
        if (!bw_graph.isSelected()) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        String string2 = "Kbytes";
        int n = 0;
        while (n < vector.size()) {
            jperfStreamResult = (JperfStreamResult)vector.get(n);
            string = new String(Integer.toString(jperfStreamResult.getID()));
            xYSeries = new XYSeries("Stream" + string, true);
            vector2 = jperfStreamResult.getBW();
            int n2 = 0;
            while (n2 < vector2.size()) {
                measurement = (Measurement)vector2.get(n2);
                Integer n3 = new Integer((int)measurement.startTime());
                Integer n4 = new Integer((int)measurement.endTime());
                Double d = new Double(measurement.getValue());
                if (n3 == 0) {
                    xYSeries.add((Number)n3, (Number)new Double(0.0));
                    string2 = measurement.getUnits();
                }
                xYSeries.add((Number)n4, (Number)d);
                ++n2;
            }
            xYSeriesCollection.addSeries(xYSeries);
            ++n;
        }
        jperfStreamResult = ChartFactory.createAreaXYChart((String)"Bandwidth", (String)"Time", (String)("Value (" + string2 + ")"), (XYDataset)xYSeriesCollection, (boolean)true, (boolean)false, (boolean)false);
        string = jperfStreamResult.getXYPlot();
        string.setOutlinePaint((Paint)Color.black);
        string.setForegroundAlpha(0.65f);
        xYSeries = string.getDomainAxis();
        xYSeries.setTickMarkPaint((Paint)Color.black);
        xYSeries.setLowerMargin(0.0);
        xYSeries.setUpperMargin(0.0);
        vector2 = string.getRangeAxis();
        vector2.setTickMarkPaint(Color.black);
        ChartPanel chartPanel = new ChartPanel((JFreeChart)jperfStreamResult);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        measurement = new ChartFrame("First", (JFreeChart)jperfStreamResult);
        measurement.setTitle("Bandwidth");
        ChartFrame.setDefaultLookAndFeelDecorated((boolean)true);
        measurement.pack();
        measurement.setContentPane((Container)chartPanel);
        measurement.setVisible(true);
    }

    public static void createJitterGraph(Vector vector) {
        Measurement measurement;
        Vector vector2;
        ValueAxis valueAxis;
        Object object;
        JperfStreamResult jperfStreamResult;
        if (!jitter_graph.isSelected()) {
            return;
        }
        if (vector.isEmpty()) {
            return;
        }
        if (!udpButton.isSelected() || !server.isSelected()) {
            return;
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        int n = 0;
        while (n < vector.size()) {
            jperfStreamResult = (JperfStreamResult)vector.get(n);
            object = new String(Integer.toString(jperfStreamResult.getID()));
            valueAxis = new XYSeries("Stream" + (String)object, true);
            vector2 = jperfStreamResult.getJitter();
            int n2 = 0;
            while (n2 < vector2.size()) {
                measurement = (Measurement)vector2.get(n2);
                Integer n3 = new Integer((int)measurement.startTime());
                Integer n4 = new Integer((int)measurement.endTime());
                Double d = new Double(measurement.getValue());
                if (n3 == 0) {
                    valueAxis.add((Number)n3, (Number)new Double(0.0));
                }
                valueAxis.add((Number)n4, (Number)d);
                ++n2;
            }
            xYSeriesCollection.addSeries((XYSeries)valueAxis);
            ++n;
        }
        jperfStreamResult = ChartFactory.createAreaXYChart((String)"Jitter", (String)"Time (sec)", (String)"Value (ms)", (XYDataset)xYSeriesCollection, (boolean)true, (boolean)false, (boolean)false);
        object = jperfStreamResult.getXYPlot();
        object.setOutlinePaint((Paint)Color.black);
        object.setForegroundAlpha(0.65f);
        valueAxis = object.getDomainAxis();
        valueAxis.setTickMarkPaint((Paint)Color.black);
        valueAxis.setLowerMargin(0.0);
        valueAxis.setUpperMargin(0.0);
        vector2 = object.getRangeAxis();
        vector2.setTickMarkPaint(Color.black);
        ChartPanel chartPanel = new ChartPanel((JFreeChart)jperfStreamResult);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        measurement = new ChartFrame("First", (JFreeChart)jperfStreamResult);
        measurement.setTitle("Jitter");
        measurement.pack();
        measurement.setContentPane((Container)chartPanel);
        measurement.setVisible(true);
    }

    public static void changeState(boolean bl, boolean bl2) {
        run.setEnabled(bl);
        stop.setEnabled(bl2);
        outputPane.revalidate();
    }
}

