/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class IperfThread
extends Thread {
    String command;
    String output;
    Process process;
    JFrame frame;
    JTextArea text;
    Vector FinalResults;
    int streamId;

    public IperfThread(String string, JFrame jFrame, JTextArea jTextArea) {
        this.command = string;
        this.frame = jFrame;
        this.text = jTextArea;
        this.FinalResults = new Vector();
        this.text.append(string);
        this.text.append("\n");
    }

    public void run() {
        try {
            this.process = Runtime.getRuntime().exec(this.command);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.frame, iOException.getMessage());
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                this.parseLine(string);
                this.text.append(string);
                this.text.append("\n");
                string = bufferedReader.readLine();
            }
            String string2 = bufferedReader2.readLine();
            while (string2 != null) {
                this.text.append(string2);
                this.text.append("\n");
                string2 = bufferedReader2.readLine();
            }
            this.process = null;
            JperfGUI.changeState(true, false);
            JperfGUI.createBWGraph(this.FinalResults);
            JperfGUI.createJitterGraph(this.FinalResults);
            this.text.append("Done.\n");
        }
        catch (IOException iOException) {
            this.text.append("\nError in Iperf thread.\n");
        }
    }

    public void quit() {
        if (this.process != null) {
            this.process.destroy();
        }
        JperfGUI.changeState(true, false);
    }

    public void parseLine(String string) {
        if (string.matches("\\[[ \\d]+\\]  [\\d]+.*")) {
            Pattern pattern = Pattern.compile("[-\\[\\]\\s]+");
            String[] stringArray = pattern.split(string);
            Integer n = new Integer(stringArray[1].trim());
            int n2 = n;
            boolean bl = false;
            JperfStreamResult jperfStreamResult = new JperfStreamResult(n2);
            int n3 = 0;
            while (n3 < this.FinalResults.size()) {
                if (((JperfStreamResult)this.FinalResults.elementAt(n3)).getID() == n2) {
                    jperfStreamResult = (JperfStreamResult)this.FinalResults.elementAt(n3);
                    bl = true;
                    break;
                }
                ++n3;
            }
            if (!bl) {
                this.FinalResults.add(jperfStreamResult);
            }
            if (stringArray.length == 9) {
                Double d = new Double(stringArray[2].trim());
                Double d2 = new Double(stringArray[3].trim());
                Double d3 = new Double(stringArray[7].trim());
                Measurement measurement = new Measurement(d, d2, d3, stringArray[8]);
                jperfStreamResult.addBW(measurement);
            } else if (stringArray.length == 14) {
                Double d = new Double(stringArray[2].trim());
                Double d4 = new Double(stringArray[3].trim());
                Double d5 = new Double(stringArray[7].trim());
                Measurement measurement = new Measurement(d, d4, d5, stringArray[7]);
                jperfStreamResult.addBW(measurement);
                Double d6 = new Double(stringArray[9].trim());
                measurement = new Measurement(d, d4, d6, stringArray[10]);
                jperfStreamResult.addJitter(measurement);
            }
        }
    }
}

